/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CUGL {
    public static final int CU_GL_DEVICE_LIST_ALL = 1;
    public static final int CU_GL_DEVICE_LIST_CURRENT_FRAME = 2;
    public static final int CU_GL_DEVICE_LIST_NEXT_FRAME = 3;
    public static final int CU_GL_MAP_RESOURCE_FLAGS_NONE = 1;
    public static final int CU_GL_MAP_RESOURCE_FLAGS_READ_ONLY = 2;
    public static final int CU_GL_MAP_RESOURCE_FLAGS_WRITE_DISCARD = 3;

    protected CUGL() {
        throw new UnsupportedOperationException();
    }

    public static int ncuGraphicsGLRegisterBuffer(long pCudaResource, int buffer, int Flags2) {
        long __functionAddress = Functions.GraphicsGLRegisterBuffer;
        return JNI.callPI(pCudaResource, buffer, Flags2, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsGLRegisterBuffer(@NativeType(value="CUgraphicsResource *") PointerBuffer pCudaResource, @NativeType(value="GLuint") int buffer, @NativeType(value="unsigned int") int Flags2) {
        if (Checks.CHECKS) {
            Checks.check(pCudaResource, 1);
        }
        return CUGL.ncuGraphicsGLRegisterBuffer(MemoryUtil.memAddress(pCudaResource), buffer, Flags2);
    }

    public static int ncuGraphicsGLRegisterImage(long pCudaResource, int image, int target, int Flags2) {
        long __functionAddress = Functions.GraphicsGLRegisterImage;
        return JNI.callPI(pCudaResource, image, target, Flags2, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsGLRegisterImage(@NativeType(value="CUgraphicsResource *") PointerBuffer pCudaResource, @NativeType(value="GLuint") int image, @NativeType(value="GLenum") int target, @NativeType(value="unsigned int") int Flags2) {
        if (Checks.CHECKS) {
            Checks.check(pCudaResource, 1);
        }
        return CUGL.ncuGraphicsGLRegisterImage(MemoryUtil.memAddress(pCudaResource), image, target, Flags2);
    }

    public static int ncuGLGetDevices(long pCudaDeviceCount, long pCudaDevices, int cudaDeviceCount, int deviceList) {
        long __functionAddress = Functions.GLGetDevices;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(pCudaDeviceCount, pCudaDevices, cudaDeviceCount, deviceList, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLGetDevices(@NativeType(value="unsigned int *") IntBuffer pCudaDeviceCount, @NativeType(value="CUdevice *") IntBuffer pCudaDevices, @NativeType(value="CUGLDeviceList") int deviceList) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pCudaDeviceCount, 1);
        }
        return CUGL.ncuGLGetDevices(MemoryUtil.memAddress(pCudaDeviceCount), MemoryUtil.memAddress(pCudaDevices), pCudaDevices.remaining(), deviceList);
    }

    public static int ncuGLCtxCreate(long pCtx, int Flags2, int device) {
        long __functionAddress = Functions.GLCtxCreate;
        return JNI.callPI(pCtx, Flags2, device, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLCtxCreate(@NativeType(value="CUcontext *") PointerBuffer pCtx, @NativeType(value="unsigned int") int Flags2, @NativeType(value="CUdevice") int device) {
        if (Checks.CHECKS) {
            Checks.check(pCtx, 1);
        }
        return CUGL.ncuGLCtxCreate(MemoryUtil.memAddress(pCtx), Flags2, device);
    }

    @NativeType(value="CUresult")
    public static int cuGLInit() {
        long __functionAddress = Functions.GLInit;
        return JNI.callI(__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLRegisterBufferObject(@NativeType(value="GLuint") int buffer) {
        long __functionAddress = Functions.GLRegisterBufferObject;
        return JNI.callI(buffer, __functionAddress);
    }

    public static int ncuGLMapBufferObject(long dptr, long size, int buffer) {
        long __functionAddress = Functions.GLMapBufferObject;
        return JNI.callPPI(dptr, size, buffer, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLMapBufferObject(@NativeType(value="CUdeviceptr *") PointerBuffer dptr, @NativeType(value="size_t *") PointerBuffer size, @NativeType(value="GLuint") int buffer) {
        if (Checks.CHECKS) {
            Checks.check(dptr, 1);
            Checks.check(size, 1);
        }
        return CUGL.ncuGLMapBufferObject(MemoryUtil.memAddress(dptr), MemoryUtil.memAddress(size), buffer);
    }

    @NativeType(value="CUresult")
    public static int cuGLUnmapBufferObject(@NativeType(value="GLuint") int buffer) {
        long __functionAddress = Functions.GLUnmapBufferObject;
        return JNI.callI(buffer, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLUnregisterBufferObject(@NativeType(value="GLuint") int buffer) {
        long __functionAddress = Functions.GLUnregisterBufferObject;
        return JNI.callI(buffer, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLSetBufferObjectMapFlags(@NativeType(value="GLuint") int buffer, @NativeType(value="unsigned int") int Flags2) {
        long __functionAddress = Functions.GLSetBufferObjectMapFlags;
        return JNI.callI(buffer, Flags2, __functionAddress);
    }

    public static int ncuGLMapBufferObjectAsync(long dptr, long size, int buffer, long hStream) {
        long __functionAddress = Functions.GLMapBufferObjectAsync;
        return JNI.callPPPI(dptr, size, buffer, hStream, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLMapBufferObjectAsync(@NativeType(value="CUdeviceptr *") PointerBuffer dptr, @NativeType(value="size_t *") PointerBuffer size, @NativeType(value="GLuint") int buffer, @NativeType(value="CUstream") long hStream) {
        if (Checks.CHECKS) {
            Checks.check(dptr, 1);
            Checks.check(size, 1);
        }
        return CUGL.ncuGLMapBufferObjectAsync(MemoryUtil.memAddress(dptr), MemoryUtil.memAddress(size), buffer, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuGLUnmapBufferObjectAsync(@NativeType(value="GLuint") int buffer, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.GLUnmapBufferObjectAsync;
        return JNI.callPI(buffer, hStream, __functionAddress);
    }

    public static final class Functions {
        public static final long GraphicsGLRegisterBuffer = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuGraphicsGLRegisterBuffer");
        public static final long GraphicsGLRegisterImage = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuGraphicsGLRegisterImage");
        public static final long GLGetDevices = APIUtil.apiGetFunctionAddressOptional(CU.getLibrary(), CUDA.__CUDA_API_VERSION("cuGLGetDevices", 2));
        public static final long GLCtxCreate = APIUtil.apiGetFunctionAddress(CU.getLibrary(), CUDA.__CUDA_API_VERSION("cuGLCtxCreate", 2));
        public static final long GLInit = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuGLInit");
        public static final long GLRegisterBufferObject = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuGLRegisterBufferObject");
        public static final long GLMapBufferObject = APIUtil.apiGetFunctionAddress(CU.getLibrary(), CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuGLMapBufferObject", 2)));
        public static final long GLUnmapBufferObject = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuGLUnmapBufferObject");
        public static final long GLUnregisterBufferObject = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuGLUnregisterBufferObject");
        public static final long GLSetBufferObjectMapFlags = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuGLSetBufferObjectMapFlags");
        public static final long GLMapBufferObjectAsync = APIUtil.apiGetFunctionAddress(CU.getLibrary(), CUDA.__CUDA_API_PTSZ(CUDA.__CUDA_API_VERSION("cuGLMapBufferObjectAsync", 2)));
        public static final long GLUnmapBufferObjectAsync = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuGLUnmapBufferObjectAsync");

        private Functions() {
        }
    }
}

