/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct CUipcEventHandle")
public class CUIPCEventHandle
extends Struct<CUIPCEventHandle>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;

    protected CUIPCEventHandle(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUIPCEventHandle create(long address, @Nullable ByteBuffer container) {
        return new CUIPCEventHandle(address, container);
    }

    public CUIPCEventHandle(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUIPCEventHandle.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[CU_IPC_HANDLE_SIZE]")
    public ByteBuffer reserved() {
        return CUIPCEventHandle.nreserved(this.address());
    }

    @NativeType(value="char")
    public byte reserved(int index) {
        return CUIPCEventHandle.nreserved(this.address(), index);
    }

    public CUIPCEventHandle reserved(@NativeType(value="char[CU_IPC_HANDLE_SIZE]") ByteBuffer value) {
        CUIPCEventHandle.nreserved(this.address(), value);
        return this;
    }

    public CUIPCEventHandle reserved(int index, @NativeType(value="char") byte value) {
        CUIPCEventHandle.nreserved(this.address(), index, value);
        return this;
    }

    public CUIPCEventHandle set(CUIPCEventHandle src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUIPCEventHandle malloc() {
        return new CUIPCEventHandle(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUIPCEventHandle calloc() {
        return new CUIPCEventHandle(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUIPCEventHandle create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUIPCEventHandle(MemoryUtil.memAddress(container), container);
    }

    public static CUIPCEventHandle create(long address) {
        return new CUIPCEventHandle(address, null);
    }

    public static @Nullable CUIPCEventHandle createSafe(long address) {
        return address == 0L ? null : new CUIPCEventHandle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUIPCEventHandle.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUIPCEventHandle.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUIPCEventHandle mallocStack() {
        return CUIPCEventHandle.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUIPCEventHandle callocStack() {
        return CUIPCEventHandle.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUIPCEventHandle mallocStack(MemoryStack stack) {
        return CUIPCEventHandle.malloc(stack);
    }

    @Deprecated
    public static CUIPCEventHandle callocStack(MemoryStack stack) {
        return CUIPCEventHandle.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUIPCEventHandle.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUIPCEventHandle.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUIPCEventHandle.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUIPCEventHandle.calloc(capacity, stack);
    }

    public static CUIPCEventHandle malloc(MemoryStack stack) {
        return new CUIPCEventHandle(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUIPCEventHandle calloc(MemoryStack stack) {
        return new CUIPCEventHandle(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nreserved(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED, 64);
    }

    public static byte nreserved(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)RESERVED + Checks.check(index, 64) * 1L);
    }

    public static void nreserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 1);
    }

    public static void nreserved(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)RESERVED + Checks.check(index, 64) * 1L, value);
    }

    static {
        Struct.Layout layout = CUIPCEventHandle.__struct(CUIPCEventHandle.__array(1, 64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CUIPCEventHandle, Buffer>
    implements NativeResource {
        private static final CUIPCEventHandle ELEMENT_FACTORY = CUIPCEventHandle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUIPCEventHandle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[CU_IPC_HANDLE_SIZE]")
        public ByteBuffer reserved() {
            return CUIPCEventHandle.nreserved(this.address());
        }

        @NativeType(value="char")
        public byte reserved(int index) {
            return CUIPCEventHandle.nreserved(this.address(), index);
        }

        public Buffer reserved(@NativeType(value="char[CU_IPC_HANDLE_SIZE]") ByteBuffer value) {
            CUIPCEventHandle.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="char") byte value) {
            CUIPCEventHandle.nreserved(this.address(), index, value);
            return this;
        }
    }
}

