/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct CUipcMemHandle")
public class CUIPCMemHandle
extends Struct<CUIPCMemHandle>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;

    protected CUIPCMemHandle(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUIPCMemHandle create(long address, @Nullable ByteBuffer container) {
        return new CUIPCMemHandle(address, container);
    }

    public CUIPCMemHandle(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUIPCMemHandle.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[CU_IPC_HANDLE_SIZE]")
    public ByteBuffer reserved() {
        return CUIPCMemHandle.nreserved(this.address());
    }

    @NativeType(value="char")
    public byte reserved(int index) {
        return CUIPCMemHandle.nreserved(this.address(), index);
    }

    public CUIPCMemHandle reserved(@NativeType(value="char[CU_IPC_HANDLE_SIZE]") ByteBuffer value) {
        CUIPCMemHandle.nreserved(this.address(), value);
        return this;
    }

    public CUIPCMemHandle reserved(int index, @NativeType(value="char") byte value) {
        CUIPCMemHandle.nreserved(this.address(), index, value);
        return this;
    }

    public CUIPCMemHandle set(CUIPCMemHandle src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUIPCMemHandle malloc() {
        return new CUIPCMemHandle(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUIPCMemHandle calloc() {
        return new CUIPCMemHandle(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUIPCMemHandle create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUIPCMemHandle(MemoryUtil.memAddress(container), container);
    }

    public static CUIPCMemHandle create(long address) {
        return new CUIPCMemHandle(address, null);
    }

    public static @Nullable CUIPCMemHandle createSafe(long address) {
        return address == 0L ? null : new CUIPCMemHandle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUIPCMemHandle.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUIPCMemHandle.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUIPCMemHandle mallocStack() {
        return CUIPCMemHandle.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUIPCMemHandle callocStack() {
        return CUIPCMemHandle.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUIPCMemHandle mallocStack(MemoryStack stack) {
        return CUIPCMemHandle.malloc(stack);
    }

    @Deprecated
    public static CUIPCMemHandle callocStack(MemoryStack stack) {
        return CUIPCMemHandle.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUIPCMemHandle.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUIPCMemHandle.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUIPCMemHandle.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUIPCMemHandle.calloc(capacity, stack);
    }

    public static CUIPCMemHandle malloc(MemoryStack stack) {
        return new CUIPCMemHandle(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUIPCMemHandle calloc(MemoryStack stack) {
        return new CUIPCMemHandle(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nreserved(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED, 64);
    }

    public static byte nreserved(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)RESERVED + Checks.check(index, 64) * 1L);
    }

    public static void nreserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 1);
    }

    public static void nreserved(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)RESERVED + Checks.check(index, 64) * 1L, value);
    }

    static {
        Struct.Layout layout = CUIPCMemHandle.__struct(CUIPCMemHandle.__array(1, 64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CUIPCMemHandle, Buffer>
    implements NativeResource {
        private static final CUIPCMemHandle ELEMENT_FACTORY = CUIPCMemHandle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUIPCMemHandle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[CU_IPC_HANDLE_SIZE]")
        public ByteBuffer reserved() {
            return CUIPCMemHandle.nreserved(this.address());
        }

        @NativeType(value="char")
        public byte reserved(int index) {
            return CUIPCMemHandle.nreserved(this.address(), index);
        }

        public Buffer reserved(@NativeType(value="char[CU_IPC_HANDLE_SIZE]") ByteBuffer value) {
            CUIPCMemHandle.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="char") byte value) {
            CUIPCMemHandle.nreserved(this.address(), index, value);
            return this;
        }
    }
}

