/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUexecAffinitySmCount;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUexecAffinityParam
extends Struct<CUexecAffinityParam>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int PARAM;
    public static final int PARAM_SMCOUNT;

    protected CUexecAffinityParam(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUexecAffinityParam create(long address, @Nullable ByteBuffer container) {
        return new CUexecAffinityParam(address, container);
    }

    public CUexecAffinityParam(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUexecAffinityParam.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUexecAffinityType")
    public int type() {
        return CUexecAffinityParam.ntype(this.address());
    }

    public CUexecAffinitySmCount param_smCount() {
        return CUexecAffinityParam.nparam_smCount(this.address());
    }

    public CUexecAffinityParam type(@NativeType(value="CUexecAffinityType") int value) {
        CUexecAffinityParam.ntype(this.address(), value);
        return this;
    }

    public CUexecAffinityParam param_smCount(CUexecAffinitySmCount value) {
        CUexecAffinityParam.nparam_smCount(this.address(), value);
        return this;
    }

    public CUexecAffinityParam param_smCount(Consumer<CUexecAffinitySmCount> consumer) {
        consumer.accept(this.param_smCount());
        return this;
    }

    public CUexecAffinityParam set(CUexecAffinityParam src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUexecAffinityParam malloc() {
        return new CUexecAffinityParam(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUexecAffinityParam calloc() {
        return new CUexecAffinityParam(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUexecAffinityParam create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUexecAffinityParam(MemoryUtil.memAddress(container), container);
    }

    public static CUexecAffinityParam create(long address) {
        return new CUexecAffinityParam(address, null);
    }

    public static @Nullable CUexecAffinityParam createSafe(long address) {
        return address == 0L ? null : new CUexecAffinityParam(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUexecAffinityParam.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUexecAffinityParam.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUexecAffinityParam malloc(MemoryStack stack) {
        return new CUexecAffinityParam(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUexecAffinityParam calloc(MemoryStack stack) {
        return new CUexecAffinityParam(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static CUexecAffinitySmCount nparam_smCount(long struct) {
        return CUexecAffinitySmCount.create(struct + (long)PARAM_SMCOUNT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nparam_smCount(long struct, CUexecAffinitySmCount value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PARAM_SMCOUNT, CUexecAffinitySmCount.SIZEOF);
    }

    static {
        Struct.Layout layout = CUexecAffinityParam.__struct(CUexecAffinityParam.__member(4), CUexecAffinityParam.__union(CUexecAffinityParam.__member(CUexecAffinitySmCount.SIZEOF, CUexecAffinitySmCount.ALIGNOF)));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        PARAM = layout.offsetof(1);
        PARAM_SMCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CUexecAffinityParam, Buffer>
    implements NativeResource {
        private static final CUexecAffinityParam ELEMENT_FACTORY = CUexecAffinityParam.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUexecAffinityParam getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUexecAffinityType")
        public int type() {
            return CUexecAffinityParam.ntype(this.address());
        }

        public CUexecAffinitySmCount param_smCount() {
            return CUexecAffinityParam.nparam_smCount(this.address());
        }

        public Buffer type(@NativeType(value="CUexecAffinityType") int value) {
            CUexecAffinityParam.ntype(this.address(), value);
            return this;
        }

        public Buffer param_smCount(CUexecAffinitySmCount value) {
            CUexecAffinityParam.nparam_smCount(this.address(), value);
            return this;
        }

        public Buffer param_smCount(Consumer<CUexecAffinitySmCount> consumer) {
            consumer.accept(this.param_smCount());
            return this;
        }
    }
}

