/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUlaunchAttributeValue;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUlaunchAttribute
extends Struct<CUlaunchAttribute>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int PAD;
    public static final int VALUE;

    protected CUlaunchAttribute(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUlaunchAttribute create(long address, @Nullable ByteBuffer container) {
        return new CUlaunchAttribute(address, container);
    }

    public CUlaunchAttribute(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUlaunchAttribute.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUlaunchAttributeID")
    public int id() {
        return CUlaunchAttribute.nid(this.address());
    }

    @NativeType(value="char[4]")
    public ByteBuffer pad() {
        return CUlaunchAttribute.npad(this.address());
    }

    @NativeType(value="char")
    public byte pad(int index) {
        return CUlaunchAttribute.npad(this.address(), index);
    }

    public CUlaunchAttributeValue value() {
        return CUlaunchAttribute.nvalue(this.address());
    }

    public CUlaunchAttribute id(@NativeType(value="CUlaunchAttributeID") int value) {
        CUlaunchAttribute.nid(this.address(), value);
        return this;
    }

    public CUlaunchAttribute pad(@NativeType(value="char[4]") ByteBuffer value) {
        CUlaunchAttribute.npad(this.address(), value);
        return this;
    }

    public CUlaunchAttribute pad(int index, @NativeType(value="char") byte value) {
        CUlaunchAttribute.npad(this.address(), index, value);
        return this;
    }

    public CUlaunchAttribute value(CUlaunchAttributeValue value) {
        CUlaunchAttribute.nvalue(this.address(), value);
        return this;
    }

    public CUlaunchAttribute value(Consumer<CUlaunchAttributeValue> consumer) {
        consumer.accept(this.value());
        return this;
    }

    public CUlaunchAttribute set(int id, ByteBuffer pad, CUlaunchAttributeValue value) {
        this.id(id);
        this.pad(pad);
        this.value(value);
        return this;
    }

    public CUlaunchAttribute set(CUlaunchAttribute src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUlaunchAttribute malloc() {
        return new CUlaunchAttribute(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUlaunchAttribute calloc() {
        return new CUlaunchAttribute(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUlaunchAttribute create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUlaunchAttribute(MemoryUtil.memAddress(container), container);
    }

    public static CUlaunchAttribute create(long address) {
        return new CUlaunchAttribute(address, null);
    }

    public static @Nullable CUlaunchAttribute createSafe(long address) {
        return address == 0L ? null : new CUlaunchAttribute(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUlaunchAttribute.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUlaunchAttribute.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUlaunchAttribute malloc(MemoryStack stack) {
        return new CUlaunchAttribute(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUlaunchAttribute calloc(MemoryStack stack) {
        return new CUlaunchAttribute(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ID);
    }

    public static ByteBuffer npad(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)PAD, 4);
    }

    public static byte npad(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)PAD + Checks.check(index, 4) * 1L);
    }

    public static CUlaunchAttributeValue nvalue(long struct) {
        return CUlaunchAttributeValue.create(struct + (long)VALUE);
    }

    public static void nid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ID, value);
    }

    public static void npad(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)PAD, value.remaining() * 1);
    }

    public static void npad(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)PAD + Checks.check(index, 4) * 1L, value);
    }

    public static void nvalue(long struct, CUlaunchAttributeValue value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VALUE, CUlaunchAttributeValue.SIZEOF);
    }

    static {
        Struct.Layout layout = CUlaunchAttribute.__struct(CUlaunchAttribute.__member(4), CUlaunchAttribute.__array(1, 4), CUlaunchAttribute.__member(CUlaunchAttributeValue.SIZEOF, CUlaunchAttributeValue.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        PAD = layout.offsetof(1);
        VALUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CUlaunchAttribute, Buffer>
    implements NativeResource {
        private static final CUlaunchAttribute ELEMENT_FACTORY = CUlaunchAttribute.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUlaunchAttribute getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUlaunchAttributeID")
        public int id() {
            return CUlaunchAttribute.nid(this.address());
        }

        @NativeType(value="char[4]")
        public ByteBuffer pad() {
            return CUlaunchAttribute.npad(this.address());
        }

        @NativeType(value="char")
        public byte pad(int index) {
            return CUlaunchAttribute.npad(this.address(), index);
        }

        public CUlaunchAttributeValue value() {
            return CUlaunchAttribute.nvalue(this.address());
        }

        public Buffer id(@NativeType(value="CUlaunchAttributeID") int value) {
            CUlaunchAttribute.nid(this.address(), value);
            return this;
        }

        public Buffer pad(@NativeType(value="char[4]") ByteBuffer value) {
            CUlaunchAttribute.npad(this.address(), value);
            return this;
        }

        public Buffer pad(int index, @NativeType(value="char") byte value) {
            CUlaunchAttribute.npad(this.address(), index, value);
            return this;
        }

        public Buffer value(CUlaunchAttributeValue value) {
            CUlaunchAttribute.nvalue(this.address(), value);
            return this;
        }

        public Buffer value(Consumer<CUlaunchAttributeValue> consumer) {
            consumer.accept(this.value());
            return this;
        }
    }
}

