/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUlaunchAttribute;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUlaunchConfig
extends Struct<CUlaunchConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int GRIDDIMX;
    public static final int GRIDDIMY;
    public static final int GRIDDIMZ;
    public static final int BLOCKDIMX;
    public static final int BLOCKDIMY;
    public static final int BLOCKDIMZ;
    public static final int SHAREDMEMBYTES;
    public static final int HSTREAM;
    public static final int ATTRS;
    public static final int NUMATTRS;

    protected CUlaunchConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUlaunchConfig create(long address, @Nullable ByteBuffer container) {
        return new CUlaunchConfig(address, container);
    }

    public CUlaunchConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUlaunchConfig.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int gridDimX() {
        return CUlaunchConfig.ngridDimX(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimY() {
        return CUlaunchConfig.ngridDimY(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimZ() {
        return CUlaunchConfig.ngridDimZ(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimX() {
        return CUlaunchConfig.nblockDimX(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimY() {
        return CUlaunchConfig.nblockDimY(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimZ() {
        return CUlaunchConfig.nblockDimZ(this.address());
    }

    @NativeType(value="unsigned int")
    public int sharedMemBytes() {
        return CUlaunchConfig.nsharedMemBytes(this.address());
    }

    @NativeType(value="CUstream")
    public long hStream() {
        return CUlaunchConfig.nhStream(this.address());
    }

    @NativeType(value="CUlaunchAttribute *")
    public @Nullable CUlaunchAttribute.Buffer attrs() {
        return CUlaunchConfig.nattrs(this.address());
    }

    @NativeType(value="unsigned int")
    public int numAttrs() {
        return CUlaunchConfig.nnumAttrs(this.address());
    }

    public CUlaunchConfig gridDimX(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.ngridDimX(this.address(), value);
        return this;
    }

    public CUlaunchConfig gridDimY(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.ngridDimY(this.address(), value);
        return this;
    }

    public CUlaunchConfig gridDimZ(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.ngridDimZ(this.address(), value);
        return this;
    }

    public CUlaunchConfig blockDimX(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nblockDimX(this.address(), value);
        return this;
    }

    public CUlaunchConfig blockDimY(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nblockDimY(this.address(), value);
        return this;
    }

    public CUlaunchConfig blockDimZ(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nblockDimZ(this.address(), value);
        return this;
    }

    public CUlaunchConfig sharedMemBytes(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nsharedMemBytes(this.address(), value);
        return this;
    }

    public CUlaunchConfig hStream(@NativeType(value="CUstream") long value) {
        CUlaunchConfig.nhStream(this.address(), value);
        return this;
    }

    public CUlaunchConfig attrs(@NativeType(value="CUlaunchAttribute *") @Nullable CUlaunchAttribute.Buffer value) {
        CUlaunchConfig.nattrs(this.address(), value);
        return this;
    }

    public CUlaunchConfig numAttrs(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nnumAttrs(this.address(), value);
        return this;
    }

    public CUlaunchConfig set(int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, long hStream, @Nullable CUlaunchAttribute.Buffer attrs, int numAttrs) {
        this.gridDimX(gridDimX);
        this.gridDimY(gridDimY);
        this.gridDimZ(gridDimZ);
        this.blockDimX(blockDimX);
        this.blockDimY(blockDimY);
        this.blockDimZ(blockDimZ);
        this.sharedMemBytes(sharedMemBytes);
        this.hStream(hStream);
        this.attrs(attrs);
        this.numAttrs(numAttrs);
        return this;
    }

    public CUlaunchConfig set(CUlaunchConfig src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUlaunchConfig malloc() {
        return new CUlaunchConfig(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUlaunchConfig calloc() {
        return new CUlaunchConfig(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUlaunchConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUlaunchConfig(MemoryUtil.memAddress(container), container);
    }

    public static CUlaunchConfig create(long address) {
        return new CUlaunchConfig(address, null);
    }

    public static @Nullable CUlaunchConfig createSafe(long address) {
        return address == 0L ? null : new CUlaunchConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUlaunchConfig.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUlaunchConfig.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUlaunchConfig malloc(MemoryStack stack) {
        return new CUlaunchConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUlaunchConfig calloc(MemoryStack stack) {
        return new CUlaunchConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ngridDimX(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GRIDDIMX);
    }

    public static int ngridDimY(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GRIDDIMY);
    }

    public static int ngridDimZ(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GRIDDIMZ);
    }

    public static int nblockDimX(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKDIMX);
    }

    public static int nblockDimY(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKDIMY);
    }

    public static int nblockDimZ(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKDIMZ);
    }

    public static int nsharedMemBytes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHAREDMEMBYTES);
    }

    public static long nhStream(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HSTREAM);
    }

    public static @Nullable CUlaunchAttribute.Buffer nattrs(long struct) {
        return CUlaunchAttribute.createSafe(MemoryUtil.memGetAddress(struct + (long)ATTRS), CUlaunchConfig.nnumAttrs(struct));
    }

    public static int nnumAttrs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMATTRS);
    }

    public static void ngridDimX(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GRIDDIMX, value);
    }

    public static void ngridDimY(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GRIDDIMY, value);
    }

    public static void ngridDimZ(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GRIDDIMZ, value);
    }

    public static void nblockDimX(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKDIMX, value);
    }

    public static void nblockDimY(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKDIMY, value);
    }

    public static void nblockDimZ(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKDIMZ, value);
    }

    public static void nsharedMemBytes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHAREDMEMBYTES, value);
    }

    public static void nhStream(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HSTREAM, value);
    }

    public static void nattrs(long struct, @Nullable CUlaunchAttribute.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)ATTRS, MemoryUtil.memAddressSafe(value));
        CUlaunchConfig.nnumAttrs(struct, value == null ? 0 : value.remaining());
    }

    public static void nnumAttrs(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUMATTRS, value);
    }

    static {
        Struct.Layout layout = CUlaunchConfig.__struct(CUlaunchConfig.__member(4), CUlaunchConfig.__member(4), CUlaunchConfig.__member(4), CUlaunchConfig.__member(4), CUlaunchConfig.__member(4), CUlaunchConfig.__member(4), CUlaunchConfig.__member(4), CUlaunchConfig.__member(POINTER_SIZE), CUlaunchConfig.__member(POINTER_SIZE), CUlaunchConfig.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        GRIDDIMX = layout.offsetof(0);
        GRIDDIMY = layout.offsetof(1);
        GRIDDIMZ = layout.offsetof(2);
        BLOCKDIMX = layout.offsetof(3);
        BLOCKDIMY = layout.offsetof(4);
        BLOCKDIMZ = layout.offsetof(5);
        SHAREDMEMBYTES = layout.offsetof(6);
        HSTREAM = layout.offsetof(7);
        ATTRS = layout.offsetof(8);
        NUMATTRS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<CUlaunchConfig, Buffer>
    implements NativeResource {
        private static final CUlaunchConfig ELEMENT_FACTORY = CUlaunchConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUlaunchConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int gridDimX() {
            return CUlaunchConfig.ngridDimX(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimY() {
            return CUlaunchConfig.ngridDimY(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimZ() {
            return CUlaunchConfig.ngridDimZ(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimX() {
            return CUlaunchConfig.nblockDimX(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimY() {
            return CUlaunchConfig.nblockDimY(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimZ() {
            return CUlaunchConfig.nblockDimZ(this.address());
        }

        @NativeType(value="unsigned int")
        public int sharedMemBytes() {
            return CUlaunchConfig.nsharedMemBytes(this.address());
        }

        @NativeType(value="CUstream")
        public long hStream() {
            return CUlaunchConfig.nhStream(this.address());
        }

        @NativeType(value="CUlaunchAttribute *")
        public @Nullable CUlaunchAttribute.Buffer attrs() {
            return CUlaunchConfig.nattrs(this.address());
        }

        @NativeType(value="unsigned int")
        public int numAttrs() {
            return CUlaunchConfig.nnumAttrs(this.address());
        }

        public Buffer gridDimX(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.ngridDimX(this.address(), value);
            return this;
        }

        public Buffer gridDimY(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.ngridDimY(this.address(), value);
            return this;
        }

        public Buffer gridDimZ(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.ngridDimZ(this.address(), value);
            return this;
        }

        public Buffer blockDimX(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nblockDimX(this.address(), value);
            return this;
        }

        public Buffer blockDimY(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nblockDimY(this.address(), value);
            return this;
        }

        public Buffer blockDimZ(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nblockDimZ(this.address(), value);
            return this;
        }

        public Buffer sharedMemBytes(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nsharedMemBytes(this.address(), value);
            return this;
        }

        public Buffer hStream(@NativeType(value="CUstream") long value) {
            CUlaunchConfig.nhStream(this.address(), value);
            return this;
        }

        public Buffer attrs(@NativeType(value="CUlaunchAttribute *") @Nullable CUlaunchAttribute.Buffer value) {
            CUlaunchConfig.nattrs(this.address(), value);
            return this;
        }

        public Buffer numAttrs(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nnumAttrs(this.address(), value);
            return this;
        }
    }
}

