/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmemLocation
extends Struct<CUmemLocation>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int ID;

    protected CUmemLocation(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUmemLocation create(long address, @Nullable ByteBuffer container) {
        return new CUmemLocation(address, container);
    }

    public CUmemLocation(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUmemLocation.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUmemLocationType")
    public int type() {
        return CUmemLocation.ntype(this.address());
    }

    public int id() {
        return CUmemLocation.nid(this.address());
    }

    public CUmemLocation type(@NativeType(value="CUmemLocationType") int value) {
        CUmemLocation.ntype(this.address(), value);
        return this;
    }

    public CUmemLocation id(int value) {
        CUmemLocation.nid(this.address(), value);
        return this;
    }

    public CUmemLocation set(int type, int id) {
        this.type(type);
        this.id(id);
        return this;
    }

    public CUmemLocation set(CUmemLocation src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUmemLocation malloc() {
        return new CUmemLocation(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUmemLocation calloc() {
        return new CUmemLocation(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUmemLocation create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUmemLocation(MemoryUtil.memAddress(container), container);
    }

    public static CUmemLocation create(long address) {
        return new CUmemLocation(address, null);
    }

    public static @Nullable CUmemLocation createSafe(long address) {
        return address == 0L ? null : new CUmemLocation(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUmemLocation.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmemLocation.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUmemLocation malloc(MemoryStack stack) {
        return new CUmemLocation(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUmemLocation calloc(MemoryStack stack) {
        return new CUmemLocation(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ID);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ID, value);
    }

    static {
        Struct.Layout layout = CUmemLocation.__struct(CUmemLocation.__member(4), CUmemLocation.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        ID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUmemLocation, Buffer>
    implements NativeResource {
        private static final CUmemLocation ELEMENT_FACTORY = CUmemLocation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUmemLocation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUmemLocationType")
        public int type() {
            return CUmemLocation.ntype(this.address());
        }

        public int id() {
            return CUmemLocation.nid(this.address());
        }

        public Buffer type(@NativeType(value="CUmemLocationType") int value) {
            CUmemLocation.ntype(this.address(), value);
            return this;
        }

        public Buffer id(int value) {
            CUmemLocation.nid(this.address(), value);
            return this;
        }
    }
}

