/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmulticastObjectProp
extends Struct<CUmulticastObjectProp>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUMDEVICES;
    public static final int SIZE;
    public static final int HANDLETYPES;
    public static final int FLAGS;

    protected CUmulticastObjectProp(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUmulticastObjectProp create(long address, @Nullable ByteBuffer container) {
        return new CUmulticastObjectProp(address, container);
    }

    public CUmulticastObjectProp(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUmulticastObjectProp.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int numDevices() {
        return CUmulticastObjectProp.nnumDevices(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return CUmulticastObjectProp.nsize(this.address());
    }

    @NativeType(value="unsigned long long")
    public long handleTypes() {
        return CUmulticastObjectProp.nhandleTypes(this.address());
    }

    @NativeType(value="unsigned long long")
    public long flags() {
        return CUmulticastObjectProp.nflags(this.address());
    }

    public CUmulticastObjectProp numDevices(@NativeType(value="unsigned int") int value) {
        CUmulticastObjectProp.nnumDevices(this.address(), value);
        return this;
    }

    public CUmulticastObjectProp size(@NativeType(value="size_t") long value) {
        CUmulticastObjectProp.nsize(this.address(), value);
        return this;
    }

    public CUmulticastObjectProp handleTypes(@NativeType(value="unsigned long long") long value) {
        CUmulticastObjectProp.nhandleTypes(this.address(), value);
        return this;
    }

    public CUmulticastObjectProp flags(@NativeType(value="unsigned long long") long value) {
        CUmulticastObjectProp.nflags(this.address(), value);
        return this;
    }

    public CUmulticastObjectProp set(int numDevices, long size, long handleTypes, long flags) {
        this.numDevices(numDevices);
        this.size(size);
        this.handleTypes(handleTypes);
        this.flags(flags);
        return this;
    }

    public CUmulticastObjectProp set(CUmulticastObjectProp src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUmulticastObjectProp malloc() {
        return new CUmulticastObjectProp(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUmulticastObjectProp calloc() {
        return new CUmulticastObjectProp(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUmulticastObjectProp create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUmulticastObjectProp(MemoryUtil.memAddress(container), container);
    }

    public static CUmulticastObjectProp create(long address) {
        return new CUmulticastObjectProp(address, null);
    }

    public static @Nullable CUmulticastObjectProp createSafe(long address) {
        return address == 0L ? null : new CUmulticastObjectProp(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUmulticastObjectProp.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmulticastObjectProp.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUmulticastObjectProp malloc(MemoryStack stack) {
        return new CUmulticastObjectProp(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUmulticastObjectProp calloc(MemoryStack stack) {
        return new CUmulticastObjectProp(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nnumDevices(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMDEVICES);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static long nhandleTypes(long struct) {
        return MemoryUtil.memGetLong(struct + (long)HANDLETYPES);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLAGS);
    }

    public static void nnumDevices(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUMDEVICES, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    public static void nhandleTypes(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)HANDLETYPES, value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = CUmulticastObjectProp.__struct(CUmulticastObjectProp.__member(4), CUmulticastObjectProp.__member(POINTER_SIZE), CUmulticastObjectProp.__member(8), CUmulticastObjectProp.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUMDEVICES = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUmulticastObjectProp, Buffer>
    implements NativeResource {
        private static final CUmulticastObjectProp ELEMENT_FACTORY = CUmulticastObjectProp.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUmulticastObjectProp getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int numDevices() {
            return CUmulticastObjectProp.nnumDevices(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return CUmulticastObjectProp.nsize(this.address());
        }

        @NativeType(value="unsigned long long")
        public long handleTypes() {
            return CUmulticastObjectProp.nhandleTypes(this.address());
        }

        @NativeType(value="unsigned long long")
        public long flags() {
            return CUmulticastObjectProp.nflags(this.address());
        }

        public Buffer numDevices(@NativeType(value="unsigned int") int value) {
            CUmulticastObjectProp.nnumDevices(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            CUmulticastObjectProp.nsize(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="unsigned long long") long value) {
            CUmulticastObjectProp.nhandleTypes(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned long long") long value) {
            CUmulticastObjectProp.nflags(this.address(), value);
            return this;
        }
    }
}

