/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUstreamBatchMemOpParams
extends Struct<CUstreamBatchMemOpParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPERATION;
    public static final int WAITVALUE;
    public static final int WAITVALUE_OPERATION;
    public static final int WAITVALUE_ADDRESS;
    public static final int WAITVALUE_VALUE;
    public static final int WAITVALUE_VALUE64;
    public static final int WAITVALUE_FLAGS;
    public static final int WAITVALUE_ALIAS;
    public static final int WRITEVALUE;
    public static final int WRITEVALUE_OPERATION;
    public static final int WRITEVALUE_ADDRESS;
    public static final int WRITEVALUE_VALUE;
    public static final int WRITEVALUE_VALUE64;
    public static final int WRITEVALUE_FLAGS;
    public static final int WRITEVALUE_ALIAS;
    public static final int FLUSHREMOTEWRITES;
    public static final int FLUSHREMOTEWRITES_OPERATION;
    public static final int FLUSHREMOTEWRITES_FLAGS;
    public static final int MEMORYBARRIER;
    public static final int MEMORYBARRIER_OPERATION;
    public static final int MEMORYBARRIER_FLAGS;
    public static final int PAD;

    protected CUstreamBatchMemOpParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUstreamBatchMemOpParams create(long address, @Nullable ByteBuffer container) {
        return new CUstreamBatchMemOpParams(address, container);
    }

    public CUstreamBatchMemOpParams(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUstreamBatchMemOpParams.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUstreamBatchMemOpType")
    public int operation() {
        return CUstreamBatchMemOpParams.noperation(this.address());
    }

    @NativeType(value="CUstreamBatchMemOpType")
    public int waitValue_operation() {
        return CUstreamBatchMemOpParams.nwaitValue_operation(this.address());
    }

    @NativeType(value="CUdeviceptr")
    public long waitValue_address() {
        return CUstreamBatchMemOpParams.nwaitValue_address(this.address());
    }

    @NativeType(value="cuuint32_t")
    public int waitValue_value() {
        return CUstreamBatchMemOpParams.nwaitValue_value(this.address());
    }

    @NativeType(value="cuuint64_t")
    public long waitValue_value64() {
        return CUstreamBatchMemOpParams.nwaitValue_value64(this.address());
    }

    @NativeType(value="unsigned int")
    public int waitValue_flags() {
        return CUstreamBatchMemOpParams.nwaitValue_flags(this.address());
    }

    @NativeType(value="CUdeviceptr")
    public long waitValue_alias() {
        return CUstreamBatchMemOpParams.nwaitValue_alias(this.address());
    }

    @NativeType(value="CUstreamBatchMemOpType")
    public int writeValue_operation() {
        return CUstreamBatchMemOpParams.nwriteValue_operation(this.address());
    }

    @NativeType(value="CUdeviceptr")
    public long writeValue_address() {
        return CUstreamBatchMemOpParams.nwriteValue_address(this.address());
    }

    @NativeType(value="cuuint32_t")
    public int writeValue_value() {
        return CUstreamBatchMemOpParams.nwriteValue_value(this.address());
    }

    @NativeType(value="cuuint64_t")
    public long writeValue_value64() {
        return CUstreamBatchMemOpParams.nwriteValue_value64(this.address());
    }

    @NativeType(value="unsigned int")
    public int writeValue_flags() {
        return CUstreamBatchMemOpParams.nwriteValue_flags(this.address());
    }

    @NativeType(value="CUdeviceptr")
    public long writeValue_alias() {
        return CUstreamBatchMemOpParams.nwriteValue_alias(this.address());
    }

    @NativeType(value="CUstreamBatchMemOpType")
    public int flushRemoteWrites_operation() {
        return CUstreamBatchMemOpParams.nflushRemoteWrites_operation(this.address());
    }

    @NativeType(value="unsigned int")
    public int flushRemoteWrites_flags() {
        return CUstreamBatchMemOpParams.nflushRemoteWrites_flags(this.address());
    }

    @NativeType(value="CUstreamBatchMemOpType")
    public int memoryBarrier_operation() {
        return CUstreamBatchMemOpParams.nmemoryBarrier_operation(this.address());
    }

    @NativeType(value="unsigned int")
    public int memoryBarrier_flags() {
        return CUstreamBatchMemOpParams.nmemoryBarrier_flags(this.address());
    }

    @NativeType(value="cuuint64_t[6]")
    public LongBuffer pad() {
        return CUstreamBatchMemOpParams.npad(this.address());
    }

    @NativeType(value="cuuint64_t")
    public long pad(int index) {
        return CUstreamBatchMemOpParams.npad(this.address(), index);
    }

    public CUstreamBatchMemOpParams operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
        CUstreamBatchMemOpParams.noperation(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams waitValue_operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
        CUstreamBatchMemOpParams.nwaitValue_operation(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams waitValue_address(@NativeType(value="CUdeviceptr") long value) {
        CUstreamBatchMemOpParams.nwaitValue_address(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams waitValue_value(@NativeType(value="cuuint32_t") int value) {
        CUstreamBatchMemOpParams.nwaitValue_value(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams waitValue_value64(@NativeType(value="cuuint64_t") long value) {
        CUstreamBatchMemOpParams.nwaitValue_value64(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams waitValue_flags(@NativeType(value="unsigned int") int value) {
        CUstreamBatchMemOpParams.nwaitValue_flags(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams waitValue_alias(@NativeType(value="CUdeviceptr") long value) {
        CUstreamBatchMemOpParams.nwaitValue_alias(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams writeValue_operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
        CUstreamBatchMemOpParams.nwriteValue_operation(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams writeValue_address(@NativeType(value="CUdeviceptr") long value) {
        CUstreamBatchMemOpParams.nwriteValue_address(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams writeValue_value(@NativeType(value="cuuint32_t") int value) {
        CUstreamBatchMemOpParams.nwriteValue_value(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams writeValue_value64(@NativeType(value="cuuint64_t") long value) {
        CUstreamBatchMemOpParams.nwriteValue_value64(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams writeValue_flags(@NativeType(value="unsigned int") int value) {
        CUstreamBatchMemOpParams.nwriteValue_flags(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams writeValue_alias(@NativeType(value="CUdeviceptr") long value) {
        CUstreamBatchMemOpParams.nwriteValue_alias(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams flushRemoteWrites_operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
        CUstreamBatchMemOpParams.nflushRemoteWrites_operation(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams flushRemoteWrites_flags(@NativeType(value="unsigned int") int value) {
        CUstreamBatchMemOpParams.nflushRemoteWrites_flags(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams memoryBarrier_operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
        CUstreamBatchMemOpParams.nmemoryBarrier_operation(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams memoryBarrier_flags(@NativeType(value="unsigned int") int value) {
        CUstreamBatchMemOpParams.nmemoryBarrier_flags(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams pad(@NativeType(value="cuuint64_t[6]") LongBuffer value) {
        CUstreamBatchMemOpParams.npad(this.address(), value);
        return this;
    }

    public CUstreamBatchMemOpParams pad(int index, @NativeType(value="cuuint64_t") long value) {
        CUstreamBatchMemOpParams.npad(this.address(), index, value);
        return this;
    }

    public CUstreamBatchMemOpParams set(CUstreamBatchMemOpParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUstreamBatchMemOpParams malloc() {
        return new CUstreamBatchMemOpParams(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUstreamBatchMemOpParams calloc() {
        return new CUstreamBatchMemOpParams(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUstreamBatchMemOpParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUstreamBatchMemOpParams(MemoryUtil.memAddress(container), container);
    }

    public static CUstreamBatchMemOpParams create(long address) {
        return new CUstreamBatchMemOpParams(address, null);
    }

    public static @Nullable CUstreamBatchMemOpParams createSafe(long address) {
        return address == 0L ? null : new CUstreamBatchMemOpParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUstreamBatchMemOpParams.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUstreamBatchMemOpParams.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUstreamBatchMemOpParams mallocStack() {
        return CUstreamBatchMemOpParams.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUstreamBatchMemOpParams callocStack() {
        return CUstreamBatchMemOpParams.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUstreamBatchMemOpParams mallocStack(MemoryStack stack) {
        return CUstreamBatchMemOpParams.malloc(stack);
    }

    @Deprecated
    public static CUstreamBatchMemOpParams callocStack(MemoryStack stack) {
        return CUstreamBatchMemOpParams.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUstreamBatchMemOpParams.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUstreamBatchMemOpParams.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUstreamBatchMemOpParams.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUstreamBatchMemOpParams.calloc(capacity, stack);
    }

    public static CUstreamBatchMemOpParams malloc(MemoryStack stack) {
        return new CUstreamBatchMemOpParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUstreamBatchMemOpParams calloc(MemoryStack stack) {
        return new CUstreamBatchMemOpParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int noperation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OPERATION);
    }

    public static int nwaitValue_operation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WAITVALUE_OPERATION);
    }

    public static long nwaitValue_address(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WAITVALUE_ADDRESS);
    }

    public static int nwaitValue_value(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WAITVALUE_VALUE);
    }

    public static long nwaitValue_value64(long struct) {
        return MemoryUtil.memGetLong(struct + (long)WAITVALUE_VALUE64);
    }

    public static int nwaitValue_flags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WAITVALUE_FLAGS);
    }

    public static long nwaitValue_alias(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WAITVALUE_ALIAS);
    }

    public static int nwriteValue_operation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WRITEVALUE_OPERATION);
    }

    public static long nwriteValue_address(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WRITEVALUE_ADDRESS);
    }

    public static int nwriteValue_value(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WRITEVALUE_VALUE);
    }

    public static long nwriteValue_value64(long struct) {
        return MemoryUtil.memGetLong(struct + (long)WRITEVALUE_VALUE64);
    }

    public static int nwriteValue_flags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WRITEVALUE_FLAGS);
    }

    public static long nwriteValue_alias(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WRITEVALUE_ALIAS);
    }

    public static int nflushRemoteWrites_operation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLUSHREMOTEWRITES_OPERATION);
    }

    public static int nflushRemoteWrites_flags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLUSHREMOTEWRITES_FLAGS);
    }

    public static int nmemoryBarrier_operation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYBARRIER_OPERATION);
    }

    public static int nmemoryBarrier_flags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYBARRIER_FLAGS);
    }

    public static LongBuffer npad(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)PAD, 6);
    }

    public static long npad(long struct, int index) {
        return MemoryUtil.memGetLong(struct + (long)PAD + Checks.check(index, 6) * 8L);
    }

    public static void noperation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OPERATION, value);
    }

    public static void nwaitValue_operation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WAITVALUE_OPERATION, value);
    }

    public static void nwaitValue_address(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WAITVALUE_ADDRESS, value);
    }

    public static void nwaitValue_value(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WAITVALUE_VALUE, value);
    }

    public static void nwaitValue_value64(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)WAITVALUE_VALUE64, value);
    }

    public static void nwaitValue_flags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WAITVALUE_FLAGS, value);
    }

    public static void nwaitValue_alias(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WAITVALUE_ALIAS, value);
    }

    public static void nwriteValue_operation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WRITEVALUE_OPERATION, value);
    }

    public static void nwriteValue_address(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WRITEVALUE_ADDRESS, value);
    }

    public static void nwriteValue_value(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WRITEVALUE_VALUE, value);
    }

    public static void nwriteValue_value64(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)WRITEVALUE_VALUE64, value);
    }

    public static void nwriteValue_flags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WRITEVALUE_FLAGS, value);
    }

    public static void nwriteValue_alias(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WRITEVALUE_ALIAS, value);
    }

    public static void nflushRemoteWrites_operation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLUSHREMOTEWRITES_OPERATION, value);
    }

    public static void nflushRemoteWrites_flags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLUSHREMOTEWRITES_FLAGS, value);
    }

    public static void nmemoryBarrier_operation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYBARRIER_OPERATION, value);
    }

    public static void nmemoryBarrier_flags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYBARRIER_FLAGS, value);
    }

    public static void npad(long struct, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)PAD, value.remaining() * 8);
    }

    public static void npad(long struct, int index, long value) {
        MemoryUtil.memPutLong(struct + (long)PAD + Checks.check(index, 6) * 8L, value);
    }

    static {
        Struct.Layout layout = CUstreamBatchMemOpParams.__union(CUstreamBatchMemOpParams.__member(4), CUstreamBatchMemOpParams.__struct(CUstreamBatchMemOpParams.__member(4), CUstreamBatchMemOpParams.__member(POINTER_SIZE), CUstreamBatchMemOpParams.__union(CUstreamBatchMemOpParams.__member(4), CUstreamBatchMemOpParams.__member(8)), CUstreamBatchMemOpParams.__member(4), CUstreamBatchMemOpParams.__member(POINTER_SIZE)), CUstreamBatchMemOpParams.__struct(CUstreamBatchMemOpParams.__member(4), CUstreamBatchMemOpParams.__member(POINTER_SIZE), CUstreamBatchMemOpParams.__union(CUstreamBatchMemOpParams.__member(4), CUstreamBatchMemOpParams.__member(8)), CUstreamBatchMemOpParams.__member(4), CUstreamBatchMemOpParams.__member(POINTER_SIZE)), CUstreamBatchMemOpParams.__struct(CUstreamBatchMemOpParams.__member(4), CUstreamBatchMemOpParams.__member(4)), CUstreamBatchMemOpParams.__struct(CUstreamBatchMemOpParams.__member(4), CUstreamBatchMemOpParams.__member(4)), CUstreamBatchMemOpParams.__array(8, 6));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OPERATION = layout.offsetof(0);
        WAITVALUE = layout.offsetof(1);
        WAITVALUE_OPERATION = layout.offsetof(2);
        WAITVALUE_ADDRESS = layout.offsetof(3);
        WAITVALUE_VALUE = layout.offsetof(5);
        WAITVALUE_VALUE64 = layout.offsetof(6);
        WAITVALUE_FLAGS = layout.offsetof(7);
        WAITVALUE_ALIAS = layout.offsetof(8);
        WRITEVALUE = layout.offsetof(9);
        WRITEVALUE_OPERATION = layout.offsetof(10);
        WRITEVALUE_ADDRESS = layout.offsetof(11);
        WRITEVALUE_VALUE = layout.offsetof(13);
        WRITEVALUE_VALUE64 = layout.offsetof(14);
        WRITEVALUE_FLAGS = layout.offsetof(15);
        WRITEVALUE_ALIAS = layout.offsetof(16);
        FLUSHREMOTEWRITES = layout.offsetof(17);
        FLUSHREMOTEWRITES_OPERATION = layout.offsetof(18);
        FLUSHREMOTEWRITES_FLAGS = layout.offsetof(19);
        MEMORYBARRIER = layout.offsetof(20);
        MEMORYBARRIER_OPERATION = layout.offsetof(21);
        MEMORYBARRIER_FLAGS = layout.offsetof(22);
        PAD = layout.offsetof(23);
    }

    public static class Buffer
    extends StructBuffer<CUstreamBatchMemOpParams, Buffer>
    implements NativeResource {
        private static final CUstreamBatchMemOpParams ELEMENT_FACTORY = CUstreamBatchMemOpParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUstreamBatchMemOpParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUstreamBatchMemOpType")
        public int operation() {
            return CUstreamBatchMemOpParams.noperation(this.address());
        }

        @NativeType(value="CUstreamBatchMemOpType")
        public int waitValue_operation() {
            return CUstreamBatchMemOpParams.nwaitValue_operation(this.address());
        }

        @NativeType(value="CUdeviceptr")
        public long waitValue_address() {
            return CUstreamBatchMemOpParams.nwaitValue_address(this.address());
        }

        @NativeType(value="cuuint32_t")
        public int waitValue_value() {
            return CUstreamBatchMemOpParams.nwaitValue_value(this.address());
        }

        @NativeType(value="cuuint64_t")
        public long waitValue_value64() {
            return CUstreamBatchMemOpParams.nwaitValue_value64(this.address());
        }

        @NativeType(value="unsigned int")
        public int waitValue_flags() {
            return CUstreamBatchMemOpParams.nwaitValue_flags(this.address());
        }

        @NativeType(value="CUdeviceptr")
        public long waitValue_alias() {
            return CUstreamBatchMemOpParams.nwaitValue_alias(this.address());
        }

        @NativeType(value="CUstreamBatchMemOpType")
        public int writeValue_operation() {
            return CUstreamBatchMemOpParams.nwriteValue_operation(this.address());
        }

        @NativeType(value="CUdeviceptr")
        public long writeValue_address() {
            return CUstreamBatchMemOpParams.nwriteValue_address(this.address());
        }

        @NativeType(value="cuuint32_t")
        public int writeValue_value() {
            return CUstreamBatchMemOpParams.nwriteValue_value(this.address());
        }

        @NativeType(value="cuuint64_t")
        public long writeValue_value64() {
            return CUstreamBatchMemOpParams.nwriteValue_value64(this.address());
        }

        @NativeType(value="unsigned int")
        public int writeValue_flags() {
            return CUstreamBatchMemOpParams.nwriteValue_flags(this.address());
        }

        @NativeType(value="CUdeviceptr")
        public long writeValue_alias() {
            return CUstreamBatchMemOpParams.nwriteValue_alias(this.address());
        }

        @NativeType(value="CUstreamBatchMemOpType")
        public int flushRemoteWrites_operation() {
            return CUstreamBatchMemOpParams.nflushRemoteWrites_operation(this.address());
        }

        @NativeType(value="unsigned int")
        public int flushRemoteWrites_flags() {
            return CUstreamBatchMemOpParams.nflushRemoteWrites_flags(this.address());
        }

        @NativeType(value="CUstreamBatchMemOpType")
        public int memoryBarrier_operation() {
            return CUstreamBatchMemOpParams.nmemoryBarrier_operation(this.address());
        }

        @NativeType(value="unsigned int")
        public int memoryBarrier_flags() {
            return CUstreamBatchMemOpParams.nmemoryBarrier_flags(this.address());
        }

        @NativeType(value="cuuint64_t[6]")
        public LongBuffer pad() {
            return CUstreamBatchMemOpParams.npad(this.address());
        }

        @NativeType(value="cuuint64_t")
        public long pad(int index) {
            return CUstreamBatchMemOpParams.npad(this.address(), index);
        }

        public Buffer operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
            CUstreamBatchMemOpParams.noperation(this.address(), value);
            return this;
        }

        public Buffer waitValue_operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
            CUstreamBatchMemOpParams.nwaitValue_operation(this.address(), value);
            return this;
        }

        public Buffer waitValue_address(@NativeType(value="CUdeviceptr") long value) {
            CUstreamBatchMemOpParams.nwaitValue_address(this.address(), value);
            return this;
        }

        public Buffer waitValue_value(@NativeType(value="cuuint32_t") int value) {
            CUstreamBatchMemOpParams.nwaitValue_value(this.address(), value);
            return this;
        }

        public Buffer waitValue_value64(@NativeType(value="cuuint64_t") long value) {
            CUstreamBatchMemOpParams.nwaitValue_value64(this.address(), value);
            return this;
        }

        public Buffer waitValue_flags(@NativeType(value="unsigned int") int value) {
            CUstreamBatchMemOpParams.nwaitValue_flags(this.address(), value);
            return this;
        }

        public Buffer waitValue_alias(@NativeType(value="CUdeviceptr") long value) {
            CUstreamBatchMemOpParams.nwaitValue_alias(this.address(), value);
            return this;
        }

        public Buffer writeValue_operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
            CUstreamBatchMemOpParams.nwriteValue_operation(this.address(), value);
            return this;
        }

        public Buffer writeValue_address(@NativeType(value="CUdeviceptr") long value) {
            CUstreamBatchMemOpParams.nwriteValue_address(this.address(), value);
            return this;
        }

        public Buffer writeValue_value(@NativeType(value="cuuint32_t") int value) {
            CUstreamBatchMemOpParams.nwriteValue_value(this.address(), value);
            return this;
        }

        public Buffer writeValue_value64(@NativeType(value="cuuint64_t") long value) {
            CUstreamBatchMemOpParams.nwriteValue_value64(this.address(), value);
            return this;
        }

        public Buffer writeValue_flags(@NativeType(value="unsigned int") int value) {
            CUstreamBatchMemOpParams.nwriteValue_flags(this.address(), value);
            return this;
        }

        public Buffer writeValue_alias(@NativeType(value="CUdeviceptr") long value) {
            CUstreamBatchMemOpParams.nwriteValue_alias(this.address(), value);
            return this;
        }

        public Buffer flushRemoteWrites_operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
            CUstreamBatchMemOpParams.nflushRemoteWrites_operation(this.address(), value);
            return this;
        }

        public Buffer flushRemoteWrites_flags(@NativeType(value="unsigned int") int value) {
            CUstreamBatchMemOpParams.nflushRemoteWrites_flags(this.address(), value);
            return this;
        }

        public Buffer memoryBarrier_operation(@NativeType(value="CUstreamBatchMemOpType") int value) {
            CUstreamBatchMemOpParams.nmemoryBarrier_operation(this.address(), value);
            return this;
        }

        public Buffer memoryBarrier_flags(@NativeType(value="unsigned int") int value) {
            CUstreamBatchMemOpParams.nmemoryBarrier_flags(this.address(), value);
            return this;
        }

        public Buffer pad(@NativeType(value="cuuint64_t[6]") LongBuffer value) {
            CUstreamBatchMemOpParams.npad(this.address(), value);
            return this;
        }

        public Buffer pad(int index, @NativeType(value="cuuint64_t") long value) {
            CUstreamBatchMemOpParams.npad(this.address(), index, value);
            return this;
        }
    }
}

