/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGL14;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EGL15
extends EGL14 {
    public static final int EGL_CONTEXT_MAJOR_VERSION = 12440;
    public static final int EGL_CONTEXT_MINOR_VERSION = 12539;
    public static final int EGL_CONTEXT_OPENGL_PROFILE_MASK = 12541;
    public static final int EGL_CONTEXT_OPENGL_RESET_NOTIFICATION_STRATEGY = 12733;
    public static final int EGL_NO_RESET_NOTIFICATION = 12734;
    public static final int EGL_LOSE_CONTEXT_ON_RESET = 12735;
    public static final int EGL_CONTEXT_OPENGL_CORE_PROFILE_BIT = 1;
    public static final int EGL_CONTEXT_OPENGL_COMPATIBILITY_PROFILE_BIT = 2;
    public static final int EGL_CONTEXT_OPENGL_DEBUG = 12720;
    public static final int EGL_CONTEXT_OPENGL_FORWARD_COMPATIBLE = 12721;
    public static final int EGL_CONTEXT_OPENGL_ROBUST_ACCESS = 12722;
    public static final int EGL_OPENGL_ES3_BIT = 64;
    public static final int EGL_CL_EVENT_HANDLE = 12444;
    public static final int EGL_SYNC_CL_EVENT = 12542;
    public static final int EGL_SYNC_CL_EVENT_COMPLETE = 12543;
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE = 12528;
    public static final int EGL_SYNC_TYPE = 12535;
    public static final int EGL_SYNC_STATUS = 12529;
    public static final int EGL_SYNC_CONDITION = 12536;
    public static final int EGL_SIGNALED = 12530;
    public static final int EGL_UNSIGNALED = 12531;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final int EGL_TIMEOUT_EXPIRED = 12533;
    public static final int EGL_CONDITION_SATISFIED = 12534;
    public static final int EGL_SYNC_FENCE = 12537;
    public static final int EGL_GL_COLORSPACE = 12445;
    public static final int EGL_GL_COLORSPACE_SRGB = 12425;
    public static final int EGL_GL_COLORSPACE_LINEAR = 12426;
    public static final int EGL_GL_RENDERBUFFER = 12473;
    public static final int EGL_GL_TEXTURE_2D = 12465;
    public static final int EGL_GL_TEXTURE_LEVEL = 12476;
    public static final int EGL_GL_TEXTURE_3D = 12466;
    public static final int EGL_GL_TEXTURE_ZOFFSET = 12477;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X = 12467;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 12468;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 12469;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 12470;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 12471;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 12472;
    public static final int EGL_IMAGE_PRESERVED = 12498;
    public static final long EGL_FOREVER = -1L;
    public static final long EGL_NO_SYNC = 0L;
    public static final long EGL_NO_IMAGE = 0L;

    protected EGL15() {
        throw new UnsupportedOperationException();
    }

    public static long neglCreateSync(long dpy, int type, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateSync;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPP(dpy, type, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSync")
    public static long eglCreateSync(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLenum") int type, @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT(attrib_list, 12344L);
        }
        return EGL15.neglCreateSync(dpy, type, MemoryUtil.memAddress(attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroySync(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSync") long sync) {
        long __functionAddress = EGL.getCapabilities().eglDestroySync;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(sync);
        }
        return JNI.callPPI(dpy, sync, __functionAddress) != 0;
    }

    @NativeType(value="EGLint")
    public static int eglClientWaitSync(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSync") long sync, @NativeType(value="EGLint") int flags, @NativeType(value="EGLTime") long timeout) {
        long __functionAddress = EGL.getCapabilities().eglClientWaitSync;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(sync);
        }
        return JNI.callPPJI(dpy, sync, flags, timeout, __functionAddress);
    }

    public static int neglGetSyncAttrib(long dpy, long sync, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttrib;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(sync);
        }
        return JNI.callPPPI(dpy, sync, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetSyncAttrib(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSync") long sync, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib const *") PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        return EGL15.neglGetSyncAttrib(dpy, sync, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static long neglCreateImage(long dpy, long ctx, int target, long buffer, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(ctx);
            Checks.check(buffer);
        }
        return JNI.callPPPPP(dpy, ctx, target, buffer, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLImage")
    public static long eglCreateImage(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLContext") long ctx, @NativeType(value="EGLenum") int target, @NativeType(value="EGLClientBuffer") long buffer, @NativeType(value="EGLAttrib const *") @Nullable PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return EGL15.neglCreateImage(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe(attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroyImage(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLImage") long image) {
        long __functionAddress = EGL.getCapabilities().eglDestroyImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(image);
        }
        return JNI.callPPI(dpy, image, __functionAddress) != 0;
    }

    public static long neglGetPlatformDisplay(int platform, long native_display, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglGetPlatformDisplay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(native_display);
        }
        return JNI.callPPP(platform, native_display, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLDisplay")
    public static long eglGetPlatformDisplay(@NativeType(value="EGLenum") int platform, @NativeType(value="void *") long native_display, @NativeType(value="EGLAttrib const *") @Nullable PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return EGL15.neglGetPlatformDisplay(platform, native_display, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformWindowSurface(long dpy, long config, long native_window, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformWindowSurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(native_window);
        }
        return JNI.callPPPPP(dpy, config, native_window, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePlatformWindowSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="void *") long native_window, @NativeType(value="EGLAttrib const *") @Nullable PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return EGL15.neglCreatePlatformWindowSurface(dpy, config, native_window, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformPixmapSurface(long dpy, long config, long native_pixmap, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformPixmapSurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(native_pixmap);
        }
        return JNI.callPPPPP(dpy, config, native_pixmap, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePlatformPixmapSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="void *") long native_pixmap, @NativeType(value="EGLAttrib const *") @Nullable PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return EGL15.neglCreatePlatformPixmapSurface(dpy, config, native_pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglWaitSync(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSync") long sync, @NativeType(value="EGLint") int flags) {
        long __functionAddress = EGL.getCapabilities().eglWaitSync;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(sync);
        }
        return JNI.callPPI(dpy, sync, flags, __functionAddress) != 0;
    }
}

