/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FSBANK_SUBSOUND
extends Struct<FSBANK_SUBSOUND>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FILENAMES;
    public static final int FILEDATA;
    public static final int FILEDATALENGTHS;
    public static final int NUMFILES;
    public static final int OVERRIDEFLAGS;
    public static final int OVERRIDEQUALITY;
    public static final int DESIREDSAMPLERATE;
    public static final int PERCENTOPTIMIZEDRATE;

    protected FSBANK_SUBSOUND(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FSBANK_SUBSOUND create(long address, @Nullable ByteBuffer container) {
        return new FSBANK_SUBSOUND(address, container);
    }

    public FSBANK_SUBSOUND(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), FSBANK_SUBSOUND.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const * const *")
    public PointerBuffer fileNames() {
        return FSBANK_SUBSOUND.nfileNames(this.address());
    }

    @NativeType(value="void const * const *")
    public PointerBuffer fileData() {
        return FSBANK_SUBSOUND.nfileData(this.address());
    }

    @NativeType(value="unsigned int const *")
    public IntBuffer fileDataLengths() {
        return FSBANK_SUBSOUND.nfileDataLengths(this.address());
    }

    @NativeType(value="unsigned int")
    public int numFiles() {
        return FSBANK_SUBSOUND.nnumFiles(this.address());
    }

    @NativeType(value="FSBANK_BUILDFLAGS")
    public int overrideFlags() {
        return FSBANK_SUBSOUND.noverrideFlags(this.address());
    }

    @NativeType(value="unsigned int")
    public int overrideQuality() {
        return FSBANK_SUBSOUND.noverrideQuality(this.address());
    }

    public float desiredSampleRate() {
        return FSBANK_SUBSOUND.ndesiredSampleRate(this.address());
    }

    public float percentOptimizedRate() {
        return FSBANK_SUBSOUND.npercentOptimizedRate(this.address());
    }

    public FSBANK_SUBSOUND fileNames(@NativeType(value="char const * const *") PointerBuffer value) {
        FSBANK_SUBSOUND.nfileNames(this.address(), value);
        return this;
    }

    public FSBANK_SUBSOUND fileData(@NativeType(value="void const * const *") PointerBuffer value) {
        FSBANK_SUBSOUND.nfileData(this.address(), value);
        return this;
    }

    public FSBANK_SUBSOUND fileDataLengths(@NativeType(value="unsigned int const *") IntBuffer value) {
        FSBANK_SUBSOUND.nfileDataLengths(this.address(), value);
        return this;
    }

    public FSBANK_SUBSOUND numFiles(@NativeType(value="unsigned int") int value) {
        FSBANK_SUBSOUND.nnumFiles(this.address(), value);
        return this;
    }

    public FSBANK_SUBSOUND overrideFlags(@NativeType(value="FSBANK_BUILDFLAGS") int value) {
        FSBANK_SUBSOUND.noverrideFlags(this.address(), value);
        return this;
    }

    public FSBANK_SUBSOUND overrideQuality(@NativeType(value="unsigned int") int value) {
        FSBANK_SUBSOUND.noverrideQuality(this.address(), value);
        return this;
    }

    public FSBANK_SUBSOUND desiredSampleRate(float value) {
        FSBANK_SUBSOUND.ndesiredSampleRate(this.address(), value);
        return this;
    }

    public FSBANK_SUBSOUND percentOptimizedRate(float value) {
        FSBANK_SUBSOUND.npercentOptimizedRate(this.address(), value);
        return this;
    }

    public FSBANK_SUBSOUND set(PointerBuffer fileNames, PointerBuffer fileData, IntBuffer fileDataLengths, int numFiles, int overrideFlags, int overrideQuality, float desiredSampleRate, float percentOptimizedRate) {
        this.fileNames(fileNames);
        this.fileData(fileData);
        this.fileDataLengths(fileDataLengths);
        this.numFiles(numFiles);
        this.overrideFlags(overrideFlags);
        this.overrideQuality(overrideQuality);
        this.desiredSampleRate(desiredSampleRate);
        this.percentOptimizedRate(percentOptimizedRate);
        return this;
    }

    public FSBANK_SUBSOUND set(FSBANK_SUBSOUND src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static FSBANK_SUBSOUND malloc() {
        return new FSBANK_SUBSOUND(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FSBANK_SUBSOUND calloc() {
        return new FSBANK_SUBSOUND(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FSBANK_SUBSOUND create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new FSBANK_SUBSOUND(MemoryUtil.memAddress(container), container);
    }

    public static FSBANK_SUBSOUND create(long address) {
        return new FSBANK_SUBSOUND(address, null);
    }

    public static @Nullable FSBANK_SUBSOUND createSafe(long address) {
        return address == 0L ? null : new FSBANK_SUBSOUND(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(FSBANK_SUBSOUND.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FSBANK_SUBSOUND.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FSBANK_SUBSOUND malloc(MemoryStack stack) {
        return new FSBANK_SUBSOUND(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FSBANK_SUBSOUND calloc(MemoryStack stack) {
        return new FSBANK_SUBSOUND(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nfileNames(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)FILENAMES), FSBANK_SUBSOUND.nnumFiles(struct));
    }

    public static PointerBuffer nfileData(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)FILEDATA), FSBANK_SUBSOUND.nnumFiles(struct));
    }

    public static IntBuffer nfileDataLengths(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)FILEDATALENGTHS), FSBANK_SUBSOUND.nnumFiles(struct));
    }

    public static int nnumFiles(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMFILES);
    }

    public static int noverrideFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OVERRIDEFLAGS);
    }

    public static int noverrideQuality(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OVERRIDEQUALITY);
    }

    public static float ndesiredSampleRate(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DESIREDSAMPLERATE);
    }

    public static float npercentOptimizedRate(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)PERCENTOPTIMIZEDRATE);
    }

    public static void nfileNames(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)FILENAMES, MemoryUtil.memAddress(value));
    }

    public static void nfileData(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)FILEDATA, MemoryUtil.memAddress(value));
    }

    public static void nfileDataLengths(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)FILEDATALENGTHS, MemoryUtil.memAddress(value));
    }

    public static void nnumFiles(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUMFILES, value);
    }

    public static void noverrideFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OVERRIDEFLAGS, value);
    }

    public static void noverrideQuality(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OVERRIDEQUALITY, value);
    }

    public static void ndesiredSampleRate(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DESIREDSAMPLERATE, value);
    }

    public static void npercentOptimizedRate(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)PERCENTOPTIMIZEDRATE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FILENAMES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FILEDATA));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FILEDATALENGTHS));
    }

    static {
        Struct.Layout layout = FSBANK_SUBSOUND.__struct(FSBANK_SUBSOUND.__member(POINTER_SIZE), FSBANK_SUBSOUND.__member(POINTER_SIZE), FSBANK_SUBSOUND.__member(POINTER_SIZE), FSBANK_SUBSOUND.__member(4), FSBANK_SUBSOUND.__member(4), FSBANK_SUBSOUND.__member(4), FSBANK_SUBSOUND.__member(4), FSBANK_SUBSOUND.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FILENAMES = layout.offsetof(0);
        FILEDATA = layout.offsetof(1);
        FILEDATALENGTHS = layout.offsetof(2);
        NUMFILES = layout.offsetof(3);
        OVERRIDEFLAGS = layout.offsetof(4);
        OVERRIDEQUALITY = layout.offsetof(5);
        DESIREDSAMPLERATE = layout.offsetof(6);
        PERCENTOPTIMIZEDRATE = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<FSBANK_SUBSOUND, Buffer>
    implements NativeResource {
        private static final FSBANK_SUBSOUND ELEMENT_FACTORY = FSBANK_SUBSOUND.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected FSBANK_SUBSOUND getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const * const *")
        public PointerBuffer fileNames() {
            return FSBANK_SUBSOUND.nfileNames(this.address());
        }

        @NativeType(value="void const * const *")
        public PointerBuffer fileData() {
            return FSBANK_SUBSOUND.nfileData(this.address());
        }

        @NativeType(value="unsigned int const *")
        public IntBuffer fileDataLengths() {
            return FSBANK_SUBSOUND.nfileDataLengths(this.address());
        }

        @NativeType(value="unsigned int")
        public int numFiles() {
            return FSBANK_SUBSOUND.nnumFiles(this.address());
        }

        @NativeType(value="FSBANK_BUILDFLAGS")
        public int overrideFlags() {
            return FSBANK_SUBSOUND.noverrideFlags(this.address());
        }

        @NativeType(value="unsigned int")
        public int overrideQuality() {
            return FSBANK_SUBSOUND.noverrideQuality(this.address());
        }

        public float desiredSampleRate() {
            return FSBANK_SUBSOUND.ndesiredSampleRate(this.address());
        }

        public float percentOptimizedRate() {
            return FSBANK_SUBSOUND.npercentOptimizedRate(this.address());
        }

        public Buffer fileNames(@NativeType(value="char const * const *") PointerBuffer value) {
            FSBANK_SUBSOUND.nfileNames(this.address(), value);
            return this;
        }

        public Buffer fileData(@NativeType(value="void const * const *") PointerBuffer value) {
            FSBANK_SUBSOUND.nfileData(this.address(), value);
            return this;
        }

        public Buffer fileDataLengths(@NativeType(value="unsigned int const *") IntBuffer value) {
            FSBANK_SUBSOUND.nfileDataLengths(this.address(), value);
            return this;
        }

        public Buffer numFiles(@NativeType(value="unsigned int") int value) {
            FSBANK_SUBSOUND.nnumFiles(this.address(), value);
            return this;
        }

        public Buffer overrideFlags(@NativeType(value="FSBANK_BUILDFLAGS") int value) {
            FSBANK_SUBSOUND.noverrideFlags(this.address(), value);
            return this;
        }

        public Buffer overrideQuality(@NativeType(value="unsigned int") int value) {
            FSBANK_SUBSOUND.noverrideQuality(this.address(), value);
            return this;
        }

        public Buffer desiredSampleRate(float value) {
            FSBANK_SUBSOUND.ndesiredSampleRate(this.address(), value);
            return this;
        }

        public Buffer percentOptimizedRate(float value) {
            FSBANK_SUBSOUND.npercentOptimizedRate(this.address(), value);
            return this;
        }
    }
}

