/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXCompletionResult;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCodeCompleteResults
extends Struct<CXCodeCompleteResults>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESULTS;
    public static final int NUMRESULTS;

    protected CXCodeCompleteResults(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXCodeCompleteResults create(long address, @Nullable ByteBuffer container) {
        return new CXCodeCompleteResults(address, container);
    }

    public CXCodeCompleteResults(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXCodeCompleteResults.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXCompletionResult *")
    public CXCompletionResult.Buffer Results() {
        return CXCodeCompleteResults.nResults(this.address());
    }

    @NativeType(value="unsigned")
    public int NumResults() {
        return CXCodeCompleteResults.nNumResults(this.address());
    }

    public static CXCodeCompleteResults malloc() {
        return new CXCodeCompleteResults(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CXCodeCompleteResults calloc() {
        return new CXCodeCompleteResults(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CXCodeCompleteResults create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CXCodeCompleteResults(MemoryUtil.memAddress(container), container);
    }

    public static CXCodeCompleteResults create(long address) {
        return new CXCodeCompleteResults(address, null);
    }

    public static @Nullable CXCodeCompleteResults createSafe(long address) {
        return address == 0L ? null : new CXCodeCompleteResults(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CXCodeCompleteResults.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCodeCompleteResults.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXCodeCompleteResults mallocStack() {
        return CXCodeCompleteResults.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCodeCompleteResults callocStack() {
        return CXCodeCompleteResults.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCodeCompleteResults mallocStack(MemoryStack stack) {
        return CXCodeCompleteResults.malloc(stack);
    }

    @Deprecated
    public static CXCodeCompleteResults callocStack(MemoryStack stack) {
        return CXCodeCompleteResults.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXCodeCompleteResults.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXCodeCompleteResults.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXCodeCompleteResults.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXCodeCompleteResults.calloc(capacity, stack);
    }

    public static CXCodeCompleteResults malloc(MemoryStack stack) {
        return new CXCodeCompleteResults(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXCodeCompleteResults calloc(MemoryStack stack) {
        return new CXCodeCompleteResults(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CXCompletionResult.Buffer nResults(long struct) {
        return CXCompletionResult.create(MemoryUtil.memGetAddress(struct + (long)RESULTS), CXCodeCompleteResults.nNumResults(struct));
    }

    public static int nNumResults(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMRESULTS);
    }

    static {
        Struct.Layout layout = CXCodeCompleteResults.__struct(CXCodeCompleteResults.__member(POINTER_SIZE), CXCodeCompleteResults.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESULTS = layout.offsetof(0);
        NUMRESULTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXCodeCompleteResults, Buffer>
    implements NativeResource {
        private static final CXCodeCompleteResults ELEMENT_FACTORY = CXCodeCompleteResults.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXCodeCompleteResults getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXCompletionResult *")
        public CXCompletionResult.Buffer Results() {
            return CXCodeCompleteResults.nResults(this.address());
        }

        @NativeType(value="unsigned")
        public int NumResults() {
            return CXCodeCompleteResults.nNumResults(this.address());
        }
    }
}

