/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.llvm.CXIdxLoc;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxImportedASTFileInfo
extends Struct<CXIdxImportedASTFileInfo> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FILE;
    public static final int MODULE;
    public static final int LOC;
    public static final int ISIMPLICIT;

    protected CXIdxImportedASTFileInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXIdxImportedASTFileInfo create(long address, @Nullable ByteBuffer container) {
        return new CXIdxImportedASTFileInfo(address, container);
    }

    public CXIdxImportedASTFileInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXIdxImportedASTFileInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXFile")
    public long file() {
        return CXIdxImportedASTFileInfo.nfile(this.address());
    }

    @NativeType(value="CXModule")
    public long module() {
        return CXIdxImportedASTFileInfo.nmodule(this.address());
    }

    public CXIdxLoc loc() {
        return CXIdxImportedASTFileInfo.nloc(this.address());
    }

    @NativeType(value="int")
    public boolean isImplicit() {
        return CXIdxImportedASTFileInfo.nisImplicit(this.address()) != 0;
    }

    public static CXIdxImportedASTFileInfo create(long address) {
        return new CXIdxImportedASTFileInfo(address, null);
    }

    public static @Nullable CXIdxImportedASTFileInfo createSafe(long address) {
        return address == 0L ? null : new CXIdxImportedASTFileInfo(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long nfile(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FILE);
    }

    public static long nmodule(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MODULE);
    }

    public static CXIdxLoc nloc(long struct) {
        return CXIdxLoc.create(struct + (long)LOC);
    }

    public static int nisImplicit(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISIMPLICIT);
    }

    static {
        Struct.Layout layout = CXIdxImportedASTFileInfo.__struct(CXIdxImportedASTFileInfo.__member(POINTER_SIZE), CXIdxImportedASTFileInfo.__member(POINTER_SIZE), CXIdxImportedASTFileInfo.__member(CXIdxLoc.SIZEOF, CXIdxLoc.ALIGNOF), CXIdxImportedASTFileInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FILE = layout.offsetof(0);
        MODULE = layout.offsetof(1);
        LOC = layout.offsetof(2);
        ISIMPLICIT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CXIdxImportedASTFileInfo, Buffer> {
        private static final CXIdxImportedASTFileInfo ELEMENT_FACTORY = CXIdxImportedASTFileInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXIdxImportedASTFileInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXFile")
        public long file() {
            return CXIdxImportedASTFileInfo.nfile(this.address());
        }

        @NativeType(value="CXModule")
        public long module() {
            return CXIdxImportedASTFileInfo.nmodule(this.address());
        }

        public CXIdxLoc loc() {
            return CXIdxImportedASTFileInfo.nloc(this.address());
        }

        @NativeType(value="int")
        public boolean isImplicit() {
            return CXIdxImportedASTFileInfo.nisImplicit(this.address()) != 0;
        }
    }
}

