/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxLoc
extends Struct<CXIdxLoc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR_DATA;
    public static final int INT_DATA;

    protected CXIdxLoc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXIdxLoc create(long address, @Nullable ByteBuffer container) {
        return new CXIdxLoc(address, container);
    }

    public CXIdxLoc(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXIdxLoc.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *[2]")
    public PointerBuffer ptr_data() {
        return CXIdxLoc.nptr_data(this.address());
    }

    @NativeType(value="void *")
    public long ptr_data(int index) {
        return CXIdxLoc.nptr_data(this.address(), index);
    }

    @NativeType(value="unsigned")
    public int int_data() {
        return CXIdxLoc.nint_data(this.address());
    }

    public static CXIdxLoc malloc() {
        return new CXIdxLoc(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CXIdxLoc calloc() {
        return new CXIdxLoc(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CXIdxLoc create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CXIdxLoc(MemoryUtil.memAddress(container), container);
    }

    public static CXIdxLoc create(long address) {
        return new CXIdxLoc(address, null);
    }

    public static @Nullable CXIdxLoc createSafe(long address) {
        return address == 0L ? null : new CXIdxLoc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CXIdxLoc.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIdxLoc.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXIdxLoc mallocStack() {
        return CXIdxLoc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxLoc callocStack() {
        return CXIdxLoc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxLoc mallocStack(MemoryStack stack) {
        return CXIdxLoc.malloc(stack);
    }

    @Deprecated
    public static CXIdxLoc callocStack(MemoryStack stack) {
        return CXIdxLoc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXIdxLoc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXIdxLoc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXIdxLoc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXIdxLoc.calloc(capacity, stack);
    }

    public static CXIdxLoc malloc(MemoryStack stack) {
        return new CXIdxLoc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXIdxLoc calloc(MemoryStack stack) {
        return new CXIdxLoc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nptr_data(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)PTR_DATA, 2);
    }

    public static long nptr_data(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)PTR_DATA + Checks.check(index, 2) * (long)POINTER_SIZE);
    }

    public static int nint_data(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INT_DATA);
    }

    static {
        Struct.Layout layout = CXIdxLoc.__struct(CXIdxLoc.__array(POINTER_SIZE, 2), CXIdxLoc.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR_DATA = layout.offsetof(0);
        INT_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXIdxLoc, Buffer>
    implements NativeResource {
        private static final CXIdxLoc ELEMENT_FACTORY = CXIdxLoc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXIdxLoc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *[2]")
        public PointerBuffer ptr_data() {
            return CXIdxLoc.nptr_data(this.address());
        }

        @NativeType(value="void *")
        public long ptr_data(int index) {
            return CXIdxLoc.nptr_data(this.address(), index);
        }

        @NativeType(value="unsigned")
        public int int_data() {
            return CXIdxLoc.nint_data(this.address());
        }
    }
}

