/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXString;
import org.lwjgl.llvm.CXVersion;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXPlatformAvailability
extends Struct<CXPlatformAvailability>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PLATFORM;
    public static final int INTRODUCED;
    public static final int DEPRECATED;
    public static final int OBSOLETED;
    public static final int UNAVAILABLE;
    public static final int MESSAGE;

    protected CXPlatformAvailability(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXPlatformAvailability create(long address, @Nullable ByteBuffer container) {
        return new CXPlatformAvailability(address, container);
    }

    public CXPlatformAvailability(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXPlatformAvailability.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public CXString Platform() {
        return CXPlatformAvailability.nPlatform(this.address());
    }

    public CXVersion Introduced() {
        return CXPlatformAvailability.nIntroduced(this.address());
    }

    public CXVersion Deprecated() {
        return CXPlatformAvailability.nDeprecated(this.address());
    }

    public CXVersion Obsoleted() {
        return CXPlatformAvailability.nObsoleted(this.address());
    }

    public int Unavailable() {
        return CXPlatformAvailability.nUnavailable(this.address());
    }

    public CXString Message() {
        return CXPlatformAvailability.nMessage(this.address());
    }

    public static CXPlatformAvailability malloc() {
        return new CXPlatformAvailability(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CXPlatformAvailability calloc() {
        return new CXPlatformAvailability(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CXPlatformAvailability create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CXPlatformAvailability(MemoryUtil.memAddress(container), container);
    }

    public static CXPlatformAvailability create(long address) {
        return new CXPlatformAvailability(address, null);
    }

    public static @Nullable CXPlatformAvailability createSafe(long address) {
        return address == 0L ? null : new CXPlatformAvailability(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CXPlatformAvailability.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXPlatformAvailability.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXPlatformAvailability mallocStack() {
        return CXPlatformAvailability.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXPlatformAvailability callocStack() {
        return CXPlatformAvailability.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXPlatformAvailability mallocStack(MemoryStack stack) {
        return CXPlatformAvailability.malloc(stack);
    }

    @Deprecated
    public static CXPlatformAvailability callocStack(MemoryStack stack) {
        return CXPlatformAvailability.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXPlatformAvailability.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXPlatformAvailability.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXPlatformAvailability.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXPlatformAvailability.calloc(capacity, stack);
    }

    public static CXPlatformAvailability malloc(MemoryStack stack) {
        return new CXPlatformAvailability(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXPlatformAvailability calloc(MemoryStack stack) {
        return new CXPlatformAvailability(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CXString nPlatform(long struct) {
        return CXString.create(struct + (long)PLATFORM);
    }

    public static CXVersion nIntroduced(long struct) {
        return CXVersion.create(struct + (long)INTRODUCED);
    }

    public static CXVersion nDeprecated(long struct) {
        return CXVersion.create(struct + (long)DEPRECATED);
    }

    public static CXVersion nObsoleted(long struct) {
        return CXVersion.create(struct + (long)OBSOLETED);
    }

    public static int nUnavailable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNAVAILABLE);
    }

    public static CXString nMessage(long struct) {
        return CXString.create(struct + (long)MESSAGE);
    }

    static {
        Struct.Layout layout = CXPlatformAvailability.__struct(CXPlatformAvailability.__member(CXString.SIZEOF, CXString.ALIGNOF), CXPlatformAvailability.__member(CXVersion.SIZEOF, CXVersion.ALIGNOF), CXPlatformAvailability.__member(CXVersion.SIZEOF, CXVersion.ALIGNOF), CXPlatformAvailability.__member(CXVersion.SIZEOF, CXVersion.ALIGNOF), CXPlatformAvailability.__member(4), CXPlatformAvailability.__member(CXString.SIZEOF, CXString.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PLATFORM = layout.offsetof(0);
        INTRODUCED = layout.offsetof(1);
        DEPRECATED = layout.offsetof(2);
        OBSOLETED = layout.offsetof(3);
        UNAVAILABLE = layout.offsetof(4);
        MESSAGE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CXPlatformAvailability, Buffer>
    implements NativeResource {
        private static final CXPlatformAvailability ELEMENT_FACTORY = CXPlatformAvailability.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXPlatformAvailability getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CXString Platform() {
            return CXPlatformAvailability.nPlatform(this.address());
        }

        public CXVersion Introduced() {
            return CXPlatformAvailability.nIntroduced(this.address());
        }

        public CXVersion Deprecated() {
            return CXPlatformAvailability.nDeprecated(this.address());
        }

        public CXVersion Obsoleted() {
            return CXPlatformAvailability.nObsoleted(this.address());
        }

        public int Unavailable() {
            return CXPlatformAvailability.nUnavailable(this.address());
        }

        public CXString Message() {
            return CXPlatformAvailability.nMessage(this.address());
        }
    }
}

