/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.llvm.CXSourceRange;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXSourceRangeList
extends Struct<CXSourceRangeList> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COUNT;
    public static final int RANGES;

    protected CXSourceRangeList(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXSourceRangeList create(long address, @Nullable ByteBuffer container) {
        return new CXSourceRangeList(address, container);
    }

    public CXSourceRangeList(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXSourceRangeList.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int count() {
        return CXSourceRangeList.ncount(this.address());
    }

    @NativeType(value="CXSourceRange *")
    public CXSourceRange.Buffer ranges() {
        return CXSourceRangeList.nranges(this.address());
    }

    public static CXSourceRangeList create(long address) {
        return new CXSourceRangeList(address, null);
    }

    public static @Nullable CXSourceRangeList createSafe(long address) {
        return address == 0L ? null : new CXSourceRangeList(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int ncount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COUNT);
    }

    public static CXSourceRange.Buffer nranges(long struct) {
        return CXSourceRange.create(MemoryUtil.memGetAddress(struct + (long)RANGES), CXSourceRangeList.ncount(struct));
    }

    static {
        Struct.Layout layout = CXSourceRangeList.__struct(CXSourceRangeList.__member(4), CXSourceRangeList.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COUNT = layout.offsetof(0);
        RANGES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXSourceRangeList, Buffer> {
        private static final CXSourceRangeList ELEMENT_FACTORY = CXSourceRangeList.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXSourceRangeList getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int count() {
            return CXSourceRangeList.ncount(this.address());
        }

        @NativeType(value="CXSourceRange *")
        public CXSourceRange.Buffer ranges() {
            return CXSourceRangeList.nranges(this.address());
        }
    }
}

