/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXTUResourceUsageEntry
extends Struct<CXTUResourceUsageEntry>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int AMOUNT;

    protected CXTUResourceUsageEntry(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXTUResourceUsageEntry create(long address, @Nullable ByteBuffer container) {
        return new CXTUResourceUsageEntry(address, container);
    }

    public CXTUResourceUsageEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXTUResourceUsageEntry.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXTUResourceUsageKind")
    public int kind() {
        return CXTUResourceUsageEntry.nkind(this.address());
    }

    @NativeType(value="unsigned long")
    public long amount() {
        return CXTUResourceUsageEntry.namount(this.address());
    }

    public static CXTUResourceUsageEntry malloc() {
        return new CXTUResourceUsageEntry(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CXTUResourceUsageEntry calloc() {
        return new CXTUResourceUsageEntry(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CXTUResourceUsageEntry create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CXTUResourceUsageEntry(MemoryUtil.memAddress(container), container);
    }

    public static CXTUResourceUsageEntry create(long address) {
        return new CXTUResourceUsageEntry(address, null);
    }

    public static @Nullable CXTUResourceUsageEntry createSafe(long address) {
        return address == 0L ? null : new CXTUResourceUsageEntry(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CXTUResourceUsageEntry.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXTUResourceUsageEntry.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXTUResourceUsageEntry mallocStack() {
        return CXTUResourceUsageEntry.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXTUResourceUsageEntry callocStack() {
        return CXTUResourceUsageEntry.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXTUResourceUsageEntry mallocStack(MemoryStack stack) {
        return CXTUResourceUsageEntry.malloc(stack);
    }

    @Deprecated
    public static CXTUResourceUsageEntry callocStack(MemoryStack stack) {
        return CXTUResourceUsageEntry.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXTUResourceUsageEntry.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXTUResourceUsageEntry.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXTUResourceUsageEntry.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXTUResourceUsageEntry.calloc(capacity, stack);
    }

    public static CXTUResourceUsageEntry malloc(MemoryStack stack) {
        return new CXTUResourceUsageEntry(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXTUResourceUsageEntry calloc(MemoryStack stack) {
        return new CXTUResourceUsageEntry(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nkind(long struct) {
        return MemoryUtil.memGetInt(struct + (long)KIND);
    }

    public static long namount(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)AMOUNT);
    }

    static {
        Struct.Layout layout = CXTUResourceUsageEntry.__struct(CXTUResourceUsageEntry.__member(4), CXTUResourceUsageEntry.__member(CLONG_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        AMOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXTUResourceUsageEntry, Buffer>
    implements NativeResource {
        private static final CXTUResourceUsageEntry ELEMENT_FACTORY = CXTUResourceUsageEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXTUResourceUsageEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXTUResourceUsageKind")
        public int kind() {
            return CXTUResourceUsageEntry.nkind(this.address());
        }

        @NativeType(value="unsigned long")
        public long amount() {
            return CXTUResourceUsageEntry.namount(this.address());
        }
    }
}

