/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMIRReader {
    protected LLVMIRReader() {
        throw new UnsupportedOperationException();
    }

    public static int nLLVMParseIRInContext(long ContextRef, long MemBuf, long OutM, long OutMessage) {
        long __functionAddress = Functions.ParseIRInContext;
        if (Checks.CHECKS) {
            Checks.check(ContextRef);
            Checks.check(MemBuf);
        }
        return JNI.invokePPPPI(ContextRef, MemBuf, OutM, OutMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMParseIRInContext(@NativeType(value="LLVMContextRef") long ContextRef, @NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMModuleRef *") PointerBuffer OutM, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check(OutM, 1);
            Checks.check(OutMessage, 1);
        }
        return LLVMIRReader.nLLVMParseIRInContext(ContextRef, MemBuf, MemoryUtil.memAddress(OutM), MemoryUtil.memAddress(OutMessage)) != 0;
    }

    public static final class Functions {
        public static final long ParseIRInContext = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMParseIRInContext");

        private Functions() {
        }
    }
}

