/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMJITSymbolFlags
extends Struct<LLVMJITSymbolFlags>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int GENERICFLAGS;
    public static final int TARGETFLAGS;

    protected LLVMJITSymbolFlags(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMJITSymbolFlags create(long address, @Nullable ByteBuffer container) {
        return new LLVMJITSymbolFlags(address, container);
    }

    public LLVMJITSymbolFlags(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMJITSymbolFlags.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte GenericFlags() {
        return LLVMJITSymbolFlags.nGenericFlags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte TargetFlags() {
        return LLVMJITSymbolFlags.nTargetFlags(this.address());
    }

    public LLVMJITSymbolFlags GenericFlags(@NativeType(value="uint8_t") byte value) {
        LLVMJITSymbolFlags.nGenericFlags(this.address(), value);
        return this;
    }

    public LLVMJITSymbolFlags TargetFlags(@NativeType(value="uint8_t") byte value) {
        LLVMJITSymbolFlags.nTargetFlags(this.address(), value);
        return this;
    }

    public LLVMJITSymbolFlags set(byte GenericFlags, byte TargetFlags) {
        this.GenericFlags(GenericFlags);
        this.TargetFlags(TargetFlags);
        return this;
    }

    public LLVMJITSymbolFlags set(LLVMJITSymbolFlags src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMJITSymbolFlags malloc() {
        return new LLVMJITSymbolFlags(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMJITSymbolFlags calloc() {
        return new LLVMJITSymbolFlags(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMJITSymbolFlags create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMJITSymbolFlags(MemoryUtil.memAddress(container), container);
    }

    public static LLVMJITSymbolFlags create(long address) {
        return new LLVMJITSymbolFlags(address, null);
    }

    public static @Nullable LLVMJITSymbolFlags createSafe(long address) {
        return address == 0L ? null : new LLVMJITSymbolFlags(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMJITSymbolFlags.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMJITSymbolFlags.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMJITSymbolFlags malloc(MemoryStack stack) {
        return new LLVMJITSymbolFlags(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMJITSymbolFlags calloc(MemoryStack stack) {
        return new LLVMJITSymbolFlags(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nGenericFlags(long struct) {
        return MemoryUtil.memGetByte(struct + (long)GENERICFLAGS);
    }

    public static byte nTargetFlags(long struct) {
        return MemoryUtil.memGetByte(struct + (long)TARGETFLAGS);
    }

    public static void nGenericFlags(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)GENERICFLAGS, value);
    }

    public static void nTargetFlags(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)TARGETFLAGS, value);
    }

    static {
        Struct.Layout layout = LLVMJITSymbolFlags.__struct(LLVMJITSymbolFlags.__member(1), LLVMJITSymbolFlags.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        GENERICFLAGS = layout.offsetof(0);
        TARGETFLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMJITSymbolFlags, Buffer>
    implements NativeResource {
        private static final LLVMJITSymbolFlags ELEMENT_FACTORY = LLVMJITSymbolFlags.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMJITSymbolFlags getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte GenericFlags() {
            return LLVMJITSymbolFlags.nGenericFlags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte TargetFlags() {
            return LLVMJITSymbolFlags.nTargetFlags(this.address());
        }

        public Buffer GenericFlags(@NativeType(value="uint8_t") byte value) {
            LLVMJITSymbolFlags.nGenericFlags(this.address(), value);
            return this;
        }

        public Buffer TargetFlags(@NativeType(value="uint8_t") byte value) {
            LLVMJITSymbolFlags.nTargetFlags(this.address(), value);
            return this;
        }
    }
}

