/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMObject {
    public static final int LLVMBinaryTypeArchive = 0;
    public static final int LLVMBinaryTypeMachOUniversalBinary = 1;
    public static final int LLVMBinaryTypeCOFFImportFile = 2;
    public static final int LLVMBinaryTypeIR = 3;
    public static final int LLVMBinaryTypeWinRes = 4;
    public static final int LLVMBinaryTypeCOFF = 5;
    public static final int LLVMBinaryTypeELF32L = 6;
    public static final int LLVMBinaryTypeELF32B = 7;
    public static final int LLVMBinaryTypeELF64L = 8;
    public static final int LLVMBinaryTypeELF64B = 9;
    public static final int LLVMBinaryTypeMachO32L = 10;
    public static final int LLVMBinaryTypeMachO32B = 11;
    public static final int LLVMBinaryTypeMachO64L = 12;
    public static final int LLVMBinaryTypeMachO64B = 13;
    public static final int LLVMBinaryTypeWasm = 14;
    public static final int LLVMBinaryTypeOffload = 15;

    protected LLVMObject() {
        throw new UnsupportedOperationException();
    }

    public static long nLLVMCreateBinary(long MemBuf, long Context2, long ErrorMessage) {
        long __functionAddress = Functions.CreateBinary;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MemBuf);
        }
        return JNI.invokePPPP(MemBuf, Context2, ErrorMessage, __functionAddress);
    }

    @NativeType(value="LLVMBinaryRef")
    public static long LLVMCreateBinary(@NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMContextRef") long Context2, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check(ErrorMessage, 1);
        }
        return LLVMObject.nLLVMCreateBinary(MemBuf, Context2, MemoryUtil.memAddress(ErrorMessage));
    }

    public static void LLVMDisposeBinary(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.DisposeBinary;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(BR);
        }
        JNI.invokePV(BR, __functionAddress);
    }

    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMBinaryCopyMemoryBuffer(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.BinaryCopyMemoryBuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(BR);
        }
        return JNI.invokePP(BR, __functionAddress);
    }

    @NativeType(value="LLVMBinaryType")
    public static int LLVMBinaryGetType(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.BinaryGetType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(BR);
        }
        return JNI.invokePI(BR, __functionAddress);
    }

    public static long nLLVMMachOUniversalBinaryCopyObjectForArch(long BR, long Arch, long ArchLen, long ErrorMessage) {
        long __functionAddress = Functions.MachOUniversalBinaryCopyObjectForArch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(BR);
        }
        return JNI.invokePPPPP(BR, Arch, ArchLen, ErrorMessage, __functionAddress);
    }

    @NativeType(value="LLVMBinaryRef")
    public static long LLVMMachOUniversalBinaryCopyObjectForArch(@NativeType(value="LLVMBinaryRef") long BR, @NativeType(value="char const *") ByteBuffer Arch, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check(ErrorMessage, 1);
        }
        return LLVMObject.nLLVMMachOUniversalBinaryCopyObjectForArch(BR, MemoryUtil.memAddress(Arch), Arch.remaining(), MemoryUtil.memAddress(ErrorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBinaryRef")
    public static long LLVMMachOUniversalBinaryCopyObjectForArch(@NativeType(value="LLVMBinaryRef") long BR, @NativeType(value="char const *") CharSequence Arch, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check(ErrorMessage, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int ArchEncodedLength = stack.nUTF8(Arch, false);
            long ArchEncoded = stack.getPointerAddress();
            long l = LLVMObject.nLLVMMachOUniversalBinaryCopyObjectForArch(BR, ArchEncoded, ArchEncodedLength, MemoryUtil.memAddress(ErrorMessage));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMSectionIteratorRef")
    public static long LLVMObjectFileCopySectionIterator(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.ObjectFileCopySectionIterator;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(BR);
        }
        return JNI.invokePP(BR, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMObjectFileIsSectionIteratorAtEnd(@NativeType(value="LLVMBinaryRef") long BR, @NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.ObjectFileIsSectionIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(BR);
            Checks.check(SI);
        }
        return JNI.invokePPI(BR, SI, __functionAddress) != 0;
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMObjectFileCopySymbolIterator(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.ObjectFileCopySymbolIterator;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(BR);
        }
        return JNI.invokePP(BR, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMObjectFileIsSymbolIteratorAtEnd(@NativeType(value="LLVMBinaryRef") long BR, @NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.ObjectFileIsSymbolIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(BR);
            Checks.check(SI);
        }
        return JNI.invokePPI(BR, SI, __functionAddress) != 0;
    }

    public static void LLVMDisposeSectionIterator(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.DisposeSectionIterator;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        JNI.invokePV(SI, __functionAddress);
    }

    public static void LLVMMoveToNextSection(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.MoveToNextSection;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        JNI.invokePV(SI, __functionAddress);
    }

    public static void LLVMMoveToContainingSection(@NativeType(value="LLVMSectionIteratorRef") long Sect, @NativeType(value="LLVMSymbolIteratorRef") long Sym) {
        long __functionAddress = Functions.MoveToContainingSection;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Sect);
            Checks.check(Sym);
        }
        JNI.invokePPV(Sect, Sym, __functionAddress);
    }

    public static void LLVMDisposeSymbolIterator(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.DisposeSymbolIterator;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        JNI.invokePV(SI, __functionAddress);
    }

    public static void LLVMMoveToNextSymbol(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.MoveToNextSymbol;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        JNI.invokePV(SI, __functionAddress);
    }

    public static long nLLVMGetSectionName(long SI) {
        long __functionAddress = Functions.GetSectionName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        return JNI.invokePP(SI, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMGetSectionName(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSectionName(SI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSectionSize(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.GetSectionSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        return JNI.invokePJ(SI, __functionAddress);
    }

    public static long nLLVMGetSectionContents(long SI) {
        long __functionAddress = Functions.GetSectionContents;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        return JNI.invokePP(SI, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMGetSectionContents(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSectionContents(SI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSectionAddress(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.GetSectionAddress;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        return JNI.invokePJ(SI, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetSectionContainsSymbol(@NativeType(value="LLVMSectionIteratorRef") long SI, @NativeType(value="LLVMSymbolIteratorRef") long Sym) {
        long __functionAddress = Functions.GetSectionContainsSymbol;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
            Checks.check(Sym);
        }
        return JNI.invokePPI(SI, Sym, __functionAddress) != 0;
    }

    @NativeType(value="LLVMRelocationIteratorRef")
    public static long LLVMGetRelocations(@NativeType(value="LLVMSectionIteratorRef") long Section2) {
        long __functionAddress = Functions.GetRelocations;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Section2);
        }
        return JNI.invokePP(Section2, __functionAddress);
    }

    public static void LLVMDisposeRelocationIterator(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.DisposeRelocationIterator;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(RI);
        }
        JNI.invokePV(RI, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsRelocationIteratorAtEnd(@NativeType(value="LLVMSectionIteratorRef") long Section2, @NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.IsRelocationIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Section2);
            Checks.check(RI);
        }
        return JNI.invokePPI(Section2, RI, __functionAddress) != 0;
    }

    public static void LLVMMoveToNextRelocation(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.MoveToNextRelocation;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(RI);
        }
        JNI.invokePV(RI, __functionAddress);
    }

    public static long nLLVMGetSymbolName(long SI) {
        long __functionAddress = Functions.GetSymbolName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        return JNI.invokePP(SI, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMGetSymbolName(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSymbolName(SI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSymbolAddress(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.GetSymbolAddress;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        return JNI.invokePJ(SI, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSymbolSize(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.GetSymbolSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(SI);
        }
        return JNI.invokePJ(SI, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetRelocationOffset(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationOffset;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(RI);
        }
        return JNI.invokePJ(RI, __functionAddress);
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMGetRelocationSymbol(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationSymbol;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(RI);
        }
        return JNI.invokePP(RI, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetRelocationType(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(RI);
        }
        return JNI.invokePJ(RI, __functionAddress);
    }

    public static long nLLVMGetRelocationTypeName(long RI) {
        long __functionAddress = Functions.GetRelocationTypeName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(RI);
        }
        return JNI.invokePP(RI, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMGetRelocationTypeName(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __result = LLVMObject.nLLVMGetRelocationTypeName(RI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static long nLLVMGetRelocationValueString(long RI) {
        long __functionAddress = Functions.GetRelocationValueString;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(RI);
        }
        return JNI.invokePP(RI, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMGetRelocationValueString(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __result = LLVMObject.nLLVMGetRelocationValueString(RI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="LLVMObjectFileRef")
    public static long LLVMCreateObjectFile(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __functionAddress = Functions.CreateObjectFile;
        if (Checks.CHECKS) {
            Checks.check(MemBuf);
        }
        return JNI.invokePP(MemBuf, __functionAddress);
    }

    public static void LLVMDisposeObjectFile(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.DisposeObjectFile;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
        }
        JNI.invokePV(ObjectFile, __functionAddress);
    }

    @NativeType(value="LLVMSectionIteratorRef")
    public static long LLVMGetSections(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.GetSections;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
        }
        return JNI.invokePP(ObjectFile, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsSectionIteratorAtEnd(@NativeType(value="LLVMObjectFileRef") long ObjectFile, @NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.IsSectionIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
            Checks.check(SI);
        }
        return JNI.invokePPI(ObjectFile, SI, __functionAddress) != 0;
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMGetSymbols(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.GetSymbols;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
        }
        return JNI.invokePP(ObjectFile, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsSymbolIteratorAtEnd(@NativeType(value="LLVMObjectFileRef") long ObjectFile, @NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.IsSymbolIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
            Checks.check(SI);
        }
        return JNI.invokePPI(ObjectFile, SI, __functionAddress) != 0;
    }

    public static final class Functions {
        public static final long CreateBinary = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMCreateBinary");
        public static final long DisposeBinary = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMDisposeBinary");
        public static final long BinaryCopyMemoryBuffer = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMBinaryCopyMemoryBuffer");
        public static final long BinaryGetType = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMBinaryGetType");
        public static final long MachOUniversalBinaryCopyObjectForArch = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMMachOUniversalBinaryCopyObjectForArch");
        public static final long ObjectFileCopySectionIterator = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMObjectFileCopySectionIterator");
        public static final long ObjectFileIsSectionIteratorAtEnd = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMObjectFileIsSectionIteratorAtEnd");
        public static final long ObjectFileCopySymbolIterator = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMObjectFileCopySymbolIterator");
        public static final long ObjectFileIsSymbolIteratorAtEnd = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMObjectFileIsSymbolIteratorAtEnd");
        public static final long DisposeSectionIterator = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMDisposeSectionIterator");
        public static final long MoveToNextSection = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMMoveToNextSection");
        public static final long MoveToContainingSection = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMMoveToContainingSection");
        public static final long DisposeSymbolIterator = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMDisposeSymbolIterator");
        public static final long MoveToNextSymbol = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMMoveToNextSymbol");
        public static final long GetSectionName = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetSectionName");
        public static final long GetSectionSize = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetSectionSize");
        public static final long GetSectionContents = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetSectionContents");
        public static final long GetSectionAddress = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetSectionAddress");
        public static final long GetSectionContainsSymbol = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetSectionContainsSymbol");
        public static final long GetRelocations = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetRelocations");
        public static final long DisposeRelocationIterator = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMDisposeRelocationIterator");
        public static final long IsRelocationIteratorAtEnd = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMIsRelocationIteratorAtEnd");
        public static final long MoveToNextRelocation = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMMoveToNextRelocation");
        public static final long GetSymbolName = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetSymbolName");
        public static final long GetSymbolAddress = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetSymbolAddress");
        public static final long GetSymbolSize = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetSymbolSize");
        public static final long GetRelocationOffset = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetRelocationOffset");
        public static final long GetRelocationSymbol = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetRelocationSymbol");
        public static final long GetRelocationType = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetRelocationType");
        public static final long GetRelocationTypeName = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetRelocationTypeName");
        public static final long GetRelocationValueString = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMGetRelocationValueString");
        public static final long CreateObjectFile = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateObjectFile");
        public static final long DisposeObjectFile = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeObjectFile");
        public static final long GetSections = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSections");
        public static final long IsSectionIteratorAtEnd = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMIsSectionIteratorAtEnd");
        public static final long GetSymbols = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSymbols");
        public static final long IsSymbolIteratorAtEnd = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMIsSymbolIteratorAtEnd");

        private Functions() {
        }
    }
}

