/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMOpInfoSymbol1;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LLVMOpInfo1")
public class LLVMOpInfo1
extends Struct<LLVMOpInfo1>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDSYMBOL;
    public static final int SUBTRACTSYMBOL;
    public static final int VALUE;
    public static final int VARIANTKIND;

    protected LLVMOpInfo1(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMOpInfo1 create(long address, @Nullable ByteBuffer container) {
        return new LLVMOpInfo1(address, container);
    }

    public LLVMOpInfo1(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOpInfo1.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct LLVMOpInfoSymbol1")
    public LLVMOpInfoSymbol1 AddSymbol() {
        return LLVMOpInfo1.nAddSymbol(this.address());
    }

    @NativeType(value="struct LLVMOpInfoSymbol1")
    public LLVMOpInfoSymbol1 SubtractSymbol() {
        return LLVMOpInfo1.nSubtractSymbol(this.address());
    }

    @NativeType(value="uint64_t")
    public long Value() {
        return LLVMOpInfo1.nValue(this.address());
    }

    @NativeType(value="uint64_t")
    public long VariantKind() {
        return LLVMOpInfo1.nVariantKind(this.address());
    }

    public LLVMOpInfo1 AddSymbol(@NativeType(value="struct LLVMOpInfoSymbol1") LLVMOpInfoSymbol1 value) {
        LLVMOpInfo1.nAddSymbol(this.address(), value);
        return this;
    }

    public LLVMOpInfo1 AddSymbol(Consumer<LLVMOpInfoSymbol1> consumer) {
        consumer.accept(this.AddSymbol());
        return this;
    }

    public LLVMOpInfo1 SubtractSymbol(@NativeType(value="struct LLVMOpInfoSymbol1") LLVMOpInfoSymbol1 value) {
        LLVMOpInfo1.nSubtractSymbol(this.address(), value);
        return this;
    }

    public LLVMOpInfo1 SubtractSymbol(Consumer<LLVMOpInfoSymbol1> consumer) {
        consumer.accept(this.SubtractSymbol());
        return this;
    }

    public LLVMOpInfo1 Value(@NativeType(value="uint64_t") long value) {
        LLVMOpInfo1.nValue(this.address(), value);
        return this;
    }

    public LLVMOpInfo1 VariantKind(@NativeType(value="uint64_t") long value) {
        LLVMOpInfo1.nVariantKind(this.address(), value);
        return this;
    }

    public LLVMOpInfo1 set(LLVMOpInfoSymbol1 AddSymbol, LLVMOpInfoSymbol1 SubtractSymbol, long Value2, long VariantKind) {
        this.AddSymbol(AddSymbol);
        this.SubtractSymbol(SubtractSymbol);
        this.Value(Value2);
        this.VariantKind(VariantKind);
        return this;
    }

    public LLVMOpInfo1 set(LLVMOpInfo1 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOpInfo1 malloc() {
        return new LLVMOpInfo1(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMOpInfo1 calloc() {
        return new LLVMOpInfo1(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMOpInfo1 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMOpInfo1(MemoryUtil.memAddress(container), container);
    }

    public static LLVMOpInfo1 create(long address) {
        return new LLVMOpInfo1(address, null);
    }

    public static @Nullable LLVMOpInfo1 createSafe(long address) {
        return address == 0L ? null : new LLVMOpInfo1(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMOpInfo1.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOpInfo1.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static LLVMOpInfo1 mallocStack() {
        return LLVMOpInfo1.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMOpInfo1 callocStack() {
        return LLVMOpInfo1.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMOpInfo1 mallocStack(MemoryStack stack) {
        return LLVMOpInfo1.malloc(stack);
    }

    @Deprecated
    public static LLVMOpInfo1 callocStack(MemoryStack stack) {
        return LLVMOpInfo1.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LLVMOpInfo1.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LLVMOpInfo1.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LLVMOpInfo1.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LLVMOpInfo1.calloc(capacity, stack);
    }

    public static LLVMOpInfo1 malloc(MemoryStack stack) {
        return new LLVMOpInfo1(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOpInfo1 calloc(MemoryStack stack) {
        return new LLVMOpInfo1(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static LLVMOpInfoSymbol1 nAddSymbol(long struct) {
        return LLVMOpInfoSymbol1.create(struct + (long)ADDSYMBOL);
    }

    public static LLVMOpInfoSymbol1 nSubtractSymbol(long struct) {
        return LLVMOpInfoSymbol1.create(struct + (long)SUBTRACTSYMBOL);
    }

    public static long nValue(long struct) {
        return MemoryUtil.memGetLong(struct + (long)VALUE);
    }

    public static long nVariantKind(long struct) {
        return MemoryUtil.memGetLong(struct + (long)VARIANTKIND);
    }

    public static void nAddSymbol(long struct, LLVMOpInfoSymbol1 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ADDSYMBOL, LLVMOpInfoSymbol1.SIZEOF);
    }

    public static void nSubtractSymbol(long struct, LLVMOpInfoSymbol1 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBTRACTSYMBOL, LLVMOpInfoSymbol1.SIZEOF);
    }

    public static void nValue(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)VALUE, value);
    }

    public static void nVariantKind(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)VARIANTKIND, value);
    }

    static {
        Struct.Layout layout = LLVMOpInfo1.__struct(LLVMOpInfo1.__member(LLVMOpInfoSymbol1.SIZEOF, LLVMOpInfoSymbol1.ALIGNOF), LLVMOpInfo1.__member(LLVMOpInfoSymbol1.SIZEOF, LLVMOpInfoSymbol1.ALIGNOF), LLVMOpInfo1.__member(8), LLVMOpInfo1.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ADDSYMBOL = layout.offsetof(0);
        SUBTRACTSYMBOL = layout.offsetof(1);
        VALUE = layout.offsetof(2);
        VARIANTKIND = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<LLVMOpInfo1, Buffer>
    implements NativeResource {
        private static final LLVMOpInfo1 ELEMENT_FACTORY = LLVMOpInfo1.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMOpInfo1 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct LLVMOpInfoSymbol1")
        public LLVMOpInfoSymbol1 AddSymbol() {
            return LLVMOpInfo1.nAddSymbol(this.address());
        }

        @NativeType(value="struct LLVMOpInfoSymbol1")
        public LLVMOpInfoSymbol1 SubtractSymbol() {
            return LLVMOpInfo1.nSubtractSymbol(this.address());
        }

        @NativeType(value="uint64_t")
        public long Value() {
            return LLVMOpInfo1.nValue(this.address());
        }

        @NativeType(value="uint64_t")
        public long VariantKind() {
            return LLVMOpInfo1.nVariantKind(this.address());
        }

        public Buffer AddSymbol(@NativeType(value="struct LLVMOpInfoSymbol1") LLVMOpInfoSymbol1 value) {
            LLVMOpInfo1.nAddSymbol(this.address(), value);
            return this;
        }

        public Buffer AddSymbol(Consumer<LLVMOpInfoSymbol1> consumer) {
            consumer.accept(this.AddSymbol());
            return this;
        }

        public Buffer SubtractSymbol(@NativeType(value="struct LLVMOpInfoSymbol1") LLVMOpInfoSymbol1 value) {
            LLVMOpInfo1.nSubtractSymbol(this.address(), value);
            return this;
        }

        public Buffer SubtractSymbol(Consumer<LLVMOpInfoSymbol1> consumer) {
            consumer.accept(this.SubtractSymbol());
            return this;
        }

        public Buffer Value(@NativeType(value="uint64_t") long value) {
            LLVMOpInfo1.nValue(this.address(), value);
            return this;
        }

        public Buffer VariantKind(@NativeType(value="uint64_t") long value) {
            LLVMOpInfo1.nVariantKind(this.address(), value);
            return this;
        }
    }
}

