/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMOrcCSymbolsList;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCDependenceMapPair
extends Struct<LLVMOrcCDependenceMapPair>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int JD;
    public static final int NAMES;

    protected LLVMOrcCDependenceMapPair(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMOrcCDependenceMapPair create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCDependenceMapPair(address, container);
    }

    public LLVMOrcCDependenceMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCDependenceMapPair.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public long JD() {
        return LLVMOrcCDependenceMapPair.nJD(this.address());
    }

    public LLVMOrcCSymbolsList Names() {
        return LLVMOrcCDependenceMapPair.nNames(this.address());
    }

    public LLVMOrcCDependenceMapPair JD(@NativeType(value="LLVMOrcJITDylibRef") long value) {
        LLVMOrcCDependenceMapPair.nJD(this.address(), value);
        return this;
    }

    public LLVMOrcCDependenceMapPair Names(LLVMOrcCSymbolsList value) {
        LLVMOrcCDependenceMapPair.nNames(this.address(), value);
        return this;
    }

    public LLVMOrcCDependenceMapPair Names(Consumer<LLVMOrcCSymbolsList> consumer) {
        consumer.accept(this.Names());
        return this;
    }

    public LLVMOrcCDependenceMapPair set(long JD, LLVMOrcCSymbolsList Names) {
        this.JD(JD);
        this.Names(Names);
        return this;
    }

    public LLVMOrcCDependenceMapPair set(LLVMOrcCDependenceMapPair src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCDependenceMapPair malloc() {
        return new LLVMOrcCDependenceMapPair(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMOrcCDependenceMapPair calloc() {
        return new LLVMOrcCDependenceMapPair(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMOrcCDependenceMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMOrcCDependenceMapPair(MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCDependenceMapPair create(long address) {
        return new LLVMOrcCDependenceMapPair(address, null);
    }

    public static @Nullable LLVMOrcCDependenceMapPair createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCDependenceMapPair(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMOrcCDependenceMapPair.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCDependenceMapPair.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCDependenceMapPair malloc(MemoryStack stack) {
        return new LLVMOrcCDependenceMapPair(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCDependenceMapPair calloc(MemoryStack stack) {
        return new LLVMOrcCDependenceMapPair(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nJD(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)JD);
    }

    public static LLVMOrcCSymbolsList nNames(long struct) {
        return LLVMOrcCSymbolsList.create(struct + (long)NAMES);
    }

    public static void nJD(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)JD, Checks.check(value));
    }

    public static void nNames(long struct, LLVMOrcCSymbolsList value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NAMES, LLVMOrcCSymbolsList.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JD));
        LLVMOrcCSymbolsList.validate(struct + (long)NAMES);
    }

    static {
        Struct.Layout layout = LLVMOrcCDependenceMapPair.__struct(LLVMOrcCDependenceMapPair.__member(POINTER_SIZE), LLVMOrcCDependenceMapPair.__member(LLVMOrcCSymbolsList.SIZEOF, LLVMOrcCSymbolsList.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        JD = layout.offsetof(0);
        NAMES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCDependenceMapPair, Buffer>
    implements NativeResource {
        private static final LLVMOrcCDependenceMapPair ELEMENT_FACTORY = LLVMOrcCDependenceMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMOrcCDependenceMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcJITDylibRef")
        public long JD() {
            return LLVMOrcCDependenceMapPair.nJD(this.address());
        }

        public LLVMOrcCSymbolsList Names() {
            return LLVMOrcCDependenceMapPair.nNames(this.address());
        }

        public Buffer JD(@NativeType(value="LLVMOrcJITDylibRef") long value) {
            LLVMOrcCDependenceMapPair.nJD(this.address(), value);
            return this;
        }

        public Buffer Names(LLVMOrcCSymbolsList value) {
            LLVMOrcCDependenceMapPair.nNames(this.address(), value);
            return this;
        }

        public Buffer Names(Consumer<LLVMOrcCSymbolsList> consumer) {
            consumer.accept(this.Names());
            return this;
        }
    }
}

