/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMJITEvaluatedSymbol;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolMapPair
extends Struct<LLVMOrcCSymbolMapPair>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int SYM;

    protected LLVMOrcCSymbolMapPair(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMOrcCSymbolMapPair create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCSymbolMapPair(address, container);
    }

    public LLVMOrcCSymbolMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCSymbolMapPair.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCSymbolMapPair.nName(this.address());
    }

    public LLVMJITEvaluatedSymbol Sym() {
        return LLVMOrcCSymbolMapPair.nSym(this.address());
    }

    public LLVMOrcCSymbolMapPair Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCSymbolMapPair.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolMapPair Sym(LLVMJITEvaluatedSymbol value) {
        LLVMOrcCSymbolMapPair.nSym(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolMapPair Sym(Consumer<LLVMJITEvaluatedSymbol> consumer) {
        consumer.accept(this.Sym());
        return this;
    }

    public LLVMOrcCSymbolMapPair set(long Name4, LLVMJITEvaluatedSymbol Sym) {
        this.Name(Name4);
        this.Sym(Sym);
        return this;
    }

    public LLVMOrcCSymbolMapPair set(LLVMOrcCSymbolMapPair src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolMapPair malloc() {
        return new LLVMOrcCSymbolMapPair(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMOrcCSymbolMapPair calloc() {
        return new LLVMOrcCSymbolMapPair(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMOrcCSymbolMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMOrcCSymbolMapPair(MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCSymbolMapPair create(long address) {
        return new LLVMOrcCSymbolMapPair(address, null);
    }

    public static @Nullable LLVMOrcCSymbolMapPair createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCSymbolMapPair(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMOrcCSymbolMapPair.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolMapPair.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCSymbolMapPair malloc(MemoryStack stack) {
        return new LLVMOrcCSymbolMapPair(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCSymbolMapPair calloc(MemoryStack stack) {
        return new LLVMOrcCSymbolMapPair(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NAME);
    }

    public static LLVMJITEvaluatedSymbol nSym(long struct) {
        return LLVMJITEvaluatedSymbol.create(struct + (long)SYM);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NAME, Checks.check(value));
    }

    public static void nSym(long struct, LLVMJITEvaluatedSymbol value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SYM, LLVMJITEvaluatedSymbol.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolMapPair.__struct(LLVMOrcCSymbolMapPair.__member(POINTER_SIZE), LLVMOrcCSymbolMapPair.__member(LLVMJITEvaluatedSymbol.SIZEOF, LLVMJITEvaluatedSymbol.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        SYM = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolMapPair, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolMapPair ELEMENT_FACTORY = LLVMOrcCSymbolMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMOrcCSymbolMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCSymbolMapPair.nName(this.address());
        }

        public LLVMJITEvaluatedSymbol Sym() {
            return LLVMOrcCSymbolMapPair.nSym(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCSymbolMapPair.nName(this.address(), value);
            return this;
        }

        public Buffer Sym(LLVMJITEvaluatedSymbol value) {
            LLVMOrcCSymbolMapPair.nSym(this.address(), value);
            return this;
        }

        public Buffer Sym(Consumer<LLVMJITEvaluatedSymbol> consumer) {
            consumer.accept(this.Sym());
            return this;
        }
    }
}

