/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMRemarks {
    public static final int REMARKS_API_VERSION = 1;
    public static final int LLVMRemarkTypeUnknown = 0;
    public static final int LLVMRemarkTypePassed = 1;
    public static final int LLVMRemarkTypeMissed = 2;
    public static final int LLVMRemarkTypeAnalysis = 3;
    public static final int LLVMRemarkTypeAnalysisFPCommute = 4;
    public static final int LLVMRemarkTypeAnalysisAliasing = 5;
    public static final int LLVMRemarkTypeFailure = 6;

    protected LLVMRemarks() {
        throw new UnsupportedOperationException();
    }

    public static long nLLVMRemarkStringGetData(long String2) {
        long __functionAddress = Functions.RemarkStringGetData;
        if (Checks.CHECKS) {
            Checks.check(String2);
        }
        return JNI.invokePP(String2, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMRemarkStringGetData(@NativeType(value="LLVMRemarkStringRef") long String2) {
        long __result = LLVMRemarks.nLLVMRemarkStringGetData(String2);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkStringGetLen(@NativeType(value="LLVMRemarkStringRef") long String2) {
        long __functionAddress = Functions.RemarkStringGetLen;
        if (Checks.CHECKS) {
            Checks.check(String2);
        }
        return JNI.invokePI(String2, __functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkDebugLocGetSourceFilePath(@NativeType(value="LLVMRemarkDebugLocRef") long DL) {
        long __functionAddress = Functions.RemarkDebugLocGetSourceFilePath;
        if (Checks.CHECKS) {
            Checks.check(DL);
        }
        return JNI.invokePP(DL, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkDebugLocGetSourceLine(@NativeType(value="LLVMRemarkDebugLocRef") long DL) {
        long __functionAddress = Functions.RemarkDebugLocGetSourceLine;
        if (Checks.CHECKS) {
            Checks.check(DL);
        }
        return JNI.invokePI(DL, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkDebugLocGetSourceColumn(@NativeType(value="LLVMRemarkDebugLocRef") long DL) {
        long __functionAddress = Functions.RemarkDebugLocGetSourceColumn;
        if (Checks.CHECKS) {
            Checks.check(DL);
        }
        return JNI.invokePI(DL, __functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkArgGetKey(@NativeType(value="LLVMRemarkArgRef") long Arg2) {
        long __functionAddress = Functions.RemarkArgGetKey;
        if (Checks.CHECKS) {
            Checks.check(Arg2);
        }
        return JNI.invokePP(Arg2, __functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkArgGetValue(@NativeType(value="LLVMRemarkArgRef") long Arg2) {
        long __functionAddress = Functions.RemarkArgGetValue;
        if (Checks.CHECKS) {
            Checks.check(Arg2);
        }
        return JNI.invokePP(Arg2, __functionAddress);
    }

    @NativeType(value="LLVMRemarkDebugLocRef")
    public static long LLVMRemarkArgGetDebugLoc(@NativeType(value="LLVMRemarkArgRef") long Arg2) {
        long __functionAddress = Functions.RemarkArgGetDebugLoc;
        if (Checks.CHECKS) {
            Checks.check(Arg2);
        }
        return JNI.invokePP(Arg2, __functionAddress);
    }

    public static void LLVMRemarkEntryDispose(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryDispose;
        if (Checks.CHECKS) {
            Checks.check(Remark);
        }
        JNI.invokePV(Remark, __functionAddress);
    }

    @NativeType(value="enum LLVMRemarkType")
    public static int LLVMRemarkEntryGetType(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetType;
        if (Checks.CHECKS) {
            Checks.check(Remark);
        }
        return JNI.invokePI(Remark, __functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkEntryGetPassName(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetPassName;
        if (Checks.CHECKS) {
            Checks.check(Remark);
        }
        return JNI.invokePP(Remark, __functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkEntryGetRemarkName(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetRemarkName;
        if (Checks.CHECKS) {
            Checks.check(Remark);
        }
        return JNI.invokePP(Remark, __functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkEntryGetFunctionName(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetFunctionName;
        if (Checks.CHECKS) {
            Checks.check(Remark);
        }
        return JNI.invokePP(Remark, __functionAddress);
    }

    @NativeType(value="LLVMRemarkDebugLocRef")
    public static long LLVMRemarkEntryGetDebugLoc(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetDebugLoc;
        if (Checks.CHECKS) {
            Checks.check(Remark);
        }
        return JNI.invokePP(Remark, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMRemarkEntryGetHotness(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetHotness;
        if (Checks.CHECKS) {
            Checks.check(Remark);
        }
        return JNI.invokePJ(Remark, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkEntryGetNumArgs(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetNumArgs;
        if (Checks.CHECKS) {
            Checks.check(Remark);
        }
        return JNI.invokePI(Remark, __functionAddress);
    }

    @NativeType(value="LLVMRemarkArgRef")
    public static long LLVMRemarkEntryGetFirstArg(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetFirstArg;
        if (Checks.CHECKS) {
            Checks.check(Remark);
        }
        return JNI.invokePP(Remark, __functionAddress);
    }

    @NativeType(value="LLVMRemarkArgRef")
    public static long LLVMRemarkEntryGetNextArg(@NativeType(value="LLVMRemarkArgRef") long It, @NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetNextArg;
        if (Checks.CHECKS) {
            Checks.check(It);
            Checks.check(Remark);
        }
        return JNI.invokePPP(It, Remark, __functionAddress);
    }

    public static long nLLVMRemarkParserCreateYAML(long Buf, long Size) {
        long __functionAddress = Functions.RemarkParserCreateYAML;
        return JNI.invokePJP(Buf, Size, __functionAddress);
    }

    @NativeType(value="LLVMRemarkParserRef")
    public static long LLVMRemarkParserCreateYAML(@NativeType(value="void const *") ByteBuffer Buf) {
        return LLVMRemarks.nLLVMRemarkParserCreateYAML(MemoryUtil.memAddress(Buf), Buf.remaining());
    }

    public static long nLLVMRemarkParserCreateBitstream(long Buf, long Size) {
        long __functionAddress = Functions.RemarkParserCreateBitstream;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePJP(Buf, Size, __functionAddress);
    }

    @NativeType(value="LLVMRemarkParserRef")
    public static long LLVMRemarkParserCreateBitstream(@NativeType(value="void const *") ByteBuffer Buf) {
        return LLVMRemarks.nLLVMRemarkParserCreateBitstream(MemoryUtil.memAddress(Buf), Buf.remaining());
    }

    @NativeType(value="LLVMRemarkEntryRef")
    public static long LLVMRemarkParserGetNext(@NativeType(value="LLVMRemarkParserRef") long Parser2) {
        long __functionAddress = Functions.RemarkParserGetNext;
        if (Checks.CHECKS) {
            Checks.check(Parser2);
        }
        return JNI.invokePP(Parser2, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMRemarkParserHasError(@NativeType(value="LLVMRemarkParserRef") long Parser2) {
        long __functionAddress = Functions.RemarkParserHasError;
        if (Checks.CHECKS) {
            Checks.check(Parser2);
        }
        return JNI.invokePI(Parser2, __functionAddress) != 0;
    }

    public static long nLLVMRemarkParserGetErrorMessage(long Parser2) {
        long __functionAddress = Functions.RemarkParserGetErrorMessage;
        if (Checks.CHECKS) {
            Checks.check(Parser2);
        }
        return JNI.invokePP(Parser2, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMRemarkParserGetErrorMessage(@NativeType(value="LLVMRemarkParserRef") long Parser2) {
        long __result = LLVMRemarks.nLLVMRemarkParserGetErrorMessage(Parser2);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static void LLVMRemarkParserDispose(@NativeType(value="LLVMRemarkParserRef") long Parser2) {
        long __functionAddress = Functions.RemarkParserDispose;
        if (Checks.CHECKS) {
            Checks.check(Parser2);
        }
        JNI.invokePV(Parser2, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkVersion() {
        long __functionAddress = Functions.RemarkVersion;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeI(__functionAddress);
    }

    public static final class Functions {
        public static final long RemarkStringGetData = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkStringGetData");
        public static final long RemarkStringGetLen = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkStringGetLen");
        public static final long RemarkDebugLocGetSourceFilePath = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkDebugLocGetSourceFilePath");
        public static final long RemarkDebugLocGetSourceLine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkDebugLocGetSourceLine");
        public static final long RemarkDebugLocGetSourceColumn = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkDebugLocGetSourceColumn");
        public static final long RemarkArgGetKey = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkArgGetKey");
        public static final long RemarkArgGetValue = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkArgGetValue");
        public static final long RemarkArgGetDebugLoc = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkArgGetDebugLoc");
        public static final long RemarkEntryDispose = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryDispose");
        public static final long RemarkEntryGetType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryGetType");
        public static final long RemarkEntryGetPassName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryGetPassName");
        public static final long RemarkEntryGetRemarkName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryGetRemarkName");
        public static final long RemarkEntryGetFunctionName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryGetFunctionName");
        public static final long RemarkEntryGetDebugLoc = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryGetDebugLoc");
        public static final long RemarkEntryGetHotness = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryGetHotness");
        public static final long RemarkEntryGetNumArgs = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryGetNumArgs");
        public static final long RemarkEntryGetFirstArg = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryGetFirstArg");
        public static final long RemarkEntryGetNextArg = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkEntryGetNextArg");
        public static final long RemarkParserCreateYAML = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkParserCreateYAML");
        public static final long RemarkParserCreateBitstream = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMRemarkParserCreateBitstream");
        public static final long RemarkParserGetNext = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkParserGetNext");
        public static final long RemarkParserHasError = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkParserHasError");
        public static final long RemarkParserGetErrorMessage = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkParserGetErrorMessage");
        public static final long RemarkParserDispose = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemarkParserDispose");
        public static final long RemarkVersion = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMRemarkVersion");

        private Functions() {
        }
    }
}

