/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMMustPreserveI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMTransforms {
    protected LLVMTransforms() {
        throw new UnsupportedOperationException();
    }

    public static void LLVMAddAggressiveInstCombinerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAggressiveInstCombinerPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCoroEarlyPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroEarlyPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCoroSplitPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroSplitPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCoroElidePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroElidePass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCoroCleanupPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroCleanupPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMPassManagerBuilderAddCoroutinePassesToExtensionPoints(@NativeType(value="LLVMPassManagerBuilderRef") long PMB) {
        long __functionAddress = Functions.PassManagerBuilderAddCoroutinePassesToExtensionPoints;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, __functionAddress);
    }

    public static void LLVMAddInstructionCombiningPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddInstructionCombiningPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddInstructionSimplifyPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddInstructionSimplifyPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddArgumentPromotionPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddArgumentPromotionPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddConstantMergePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddConstantMergePass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddMergeFunctionsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddMergeFunctionsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCalledValuePropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCalledValuePropagationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddDeadArgEliminationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDeadArgEliminationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddFunctionAttrsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddFunctionAttrsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddFunctionInliningPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddFunctionInliningPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddAlwaysInlinerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAlwaysInlinerPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddGlobalDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddGlobalDCEPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddGlobalOptimizerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddGlobalOptimizerPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddIPConstantPropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddIPConstantPropagationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddPruneEHPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddPruneEHPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddIPSCCPPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddIPSCCPPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddInternalizePass(@NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="unsigned int") int AllButMain) {
        long __functionAddress = Functions.AddInternalizePass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, AllButMain, __functionAddress);
    }

    public static void nLLVMAddInternalizePassWithMustPreservePredicate(long PM, long Context2, long MustPreserve) {
        long __functionAddress = Functions.AddInternalizePassWithMustPreservePredicate;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
            Checks.check(Context2);
        }
        JNI.invokePPPV(PM, Context2, MustPreserve, __functionAddress);
    }

    public static void LLVMAddInternalizePassWithMustPreservePredicate(@NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="void *") long Context2, @NativeType(value="LLVMBool (*) (LLVMValueRef, void *)") LLVMMustPreserveI MustPreserve) {
        LLVMTransforms.nLLVMAddInternalizePassWithMustPreservePredicate(PM, Context2, MustPreserve.address());
    }

    public static void LLVMAddStripDeadPrototypesPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddStripDeadPrototypesPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddStripSymbolsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddStripSymbolsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static long nLLVMRunPasses(long M, long Passes, long TM, long Options) {
        long __functionAddress = Functions.RunPasses;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
            Checks.check(TM);
            Checks.check(Options);
        }
        return JNI.invokePPPPP(M, Passes, TM, Options, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMRunPasses(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Passes, @NativeType(value="LLVMTargetMachineRef") long TM, @NativeType(value="LLVMPassBuilderOptionsRef") long Options) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Passes);
        }
        return LLVMTransforms.nLLVMRunPasses(M, MemoryUtil.memAddress(Passes), TM, Options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMRunPasses(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Passes, @NativeType(value="LLVMTargetMachineRef") long TM, @NativeType(value="LLVMPassBuilderOptionsRef") long Options) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Passes, true);
            long PassesEncoded = stack.getPointerAddress();
            long l = LLVMTransforms.nLLVMRunPasses(M, PassesEncoded, TM, Options);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMPassBuilderOptionsRef")
    public static long LLVMCreatePassBuilderOptions() {
        long __functionAddress = Functions.CreatePassBuilderOptions;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetVerifyEach(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean VerifyEach) {
        long __functionAddress = Functions.PassBuilderOptionsSetVerifyEach;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, VerifyEach ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetDebugLogging(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean DebugLogging) {
        long __functionAddress = Functions.PassBuilderOptionsSetDebugLogging;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, DebugLogging ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLoopInterleaving(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean LoopInterleaving) {
        long __functionAddress = Functions.PassBuilderOptionsSetLoopInterleaving;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, LoopInterleaving ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLoopVectorization(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean LoopVectorization) {
        long __functionAddress = Functions.PassBuilderOptionsSetLoopVectorization;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, LoopVectorization ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetSLPVectorization(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean SLPVectorization) {
        long __functionAddress = Functions.PassBuilderOptionsSetSLPVectorization;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, SLPVectorization ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLoopUnrolling(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean LoopUnrolling) {
        long __functionAddress = Functions.PassBuilderOptionsSetLoopUnrolling;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, LoopUnrolling ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean ForgetAllSCEVInLoopUnroll) {
        long __functionAddress = Functions.PassBuilderOptionsSetForgetAllSCEVInLoopUnroll;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, ForgetAllSCEVInLoopUnroll ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLicmMssaOptCap(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="unsigned") int LicmMssaOptCap) {
        long __functionAddress = Functions.PassBuilderOptionsSetLicmMssaOptCap;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, LicmMssaOptCap, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="unsigned") int LicmMssaNoAccForPromotionCap) {
        long __functionAddress = Functions.PassBuilderOptionsSetLicmMssaNoAccForPromotionCap;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, LicmMssaNoAccForPromotionCap, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetCallGraphProfile(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean CallGraphProfile) {
        long __functionAddress = Functions.PassBuilderOptionsSetCallGraphProfile;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, CallGraphProfile ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetMergeFunctions(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean MergeFunctions) {
        long __functionAddress = Functions.PassBuilderOptionsSetMergeFunctions;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, MergeFunctions ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetInlinerThreshold(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, int Threshold) {
        long __functionAddress = Functions.PassBuilderOptionsSetInlinerThreshold;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, Threshold, __functionAddress);
    }

    public static void LLVMDisposePassBuilderOptions(@NativeType(value="LLVMPassBuilderOptionsRef") long Options) {
        long __functionAddress = Functions.DisposePassBuilderOptions;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options);
        }
        JNI.invokePV(Options, __functionAddress);
    }

    @NativeType(value="LLVMPassManagerBuilderRef")
    public static long LLVMPassManagerBuilderCreate() {
        long __functionAddress = Functions.PassManagerBuilderCreate;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    public static void LLVMPassManagerBuilderDispose(@NativeType(value="LLVMPassManagerBuilderRef") long PMB) {
        long __functionAddress = Functions.PassManagerBuilderDispose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetOptLevel(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="unsigned int") int OptLevel) {
        long __functionAddress = Functions.PassManagerBuilderSetOptLevel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, OptLevel, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetSizeLevel(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="unsigned int") int SizeLevel) {
        long __functionAddress = Functions.PassManagerBuilderSetSizeLevel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, SizeLevel, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetDisableUnitAtATime(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMBool") boolean Value2) {
        long __functionAddress = Functions.PassManagerBuilderSetDisableUnitAtATime;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, Value2 ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetDisableUnrollLoops(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMBool") boolean Value2) {
        long __functionAddress = Functions.PassManagerBuilderSetDisableUnrollLoops;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, Value2 ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetDisableSimplifyLibCalls(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMBool") boolean Value2) {
        long __functionAddress = Functions.PassManagerBuilderSetDisableSimplifyLibCalls;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, Value2 ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassManagerBuilderUseInlinerWithThreshold(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="unsigned int") int Threshold) {
        long __functionAddress = Functions.PassManagerBuilderUseInlinerWithThreshold;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, Threshold, __functionAddress);
    }

    public static void LLVMPassManagerBuilderPopulateFunctionPassManager(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.PassManagerBuilderPopulateFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
            Checks.check(PM);
        }
        JNI.invokePPV(PMB, PM, __functionAddress);
    }

    public static void LLVMPassManagerBuilderPopulateModulePassManager(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.PassManagerBuilderPopulateModulePassManager;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
            Checks.check(PM);
        }
        JNI.invokePPV(PMB, PM, __functionAddress);
    }

    public static void LLVMPassManagerBuilderPopulateLTOPassManager(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="LLVMBool") boolean Internalize, @NativeType(value="LLVMBool") boolean RunInliner) {
        long __functionAddress = Functions.PassManagerBuilderPopulateLTOPassManager;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
            Checks.check(PM);
        }
        JNI.invokePPV(PMB, PM, Internalize ? 1 : 0, RunInliner ? 1 : 0, __functionAddress);
    }

    public static void LLVMAddAggressiveDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAggressiveDCEPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDCEPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddBitTrackingDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddBitTrackingDCEPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddAlignmentFromAssumptionsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAlignmentFromAssumptionsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCFGSimplificationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCFGSimplificationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddDeadStoreEliminationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDeadStoreEliminationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScalarizerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScalarizerPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddMergedLoadStoreMotionPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddMergedLoadStoreMotionPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddGVNPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddGVNPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddNewGVNPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddNewGVNPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddIndVarSimplifyPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddIndVarSimplifyPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddJumpThreadingPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddJumpThreadingPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLICMPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLICMPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopDeletionPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopDeletionPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopIdiomPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopIdiomPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopRotatePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopRotatePass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopRerollPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopRerollPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopUnrollPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopUnrollPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopUnrollAndJamPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopUnrollAndJamPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopUnswitchPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopUnswitchPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLowerAtomicPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerAtomicPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddMemCpyOptPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddMemCpyOptPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddPartiallyInlineLibCallsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddPartiallyInlineLibCallsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddReassociatePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddReassociatePass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddSCCPPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddSCCPPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScalarReplAggregatesPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScalarReplAggregatesPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScalarReplAggregatesPassSSA(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScalarReplAggregatesPassSSA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScalarReplAggregatesPassWithThreshold(@NativeType(value="LLVMPassManagerRef") long PM, int Threshold) {
        long __functionAddress = Functions.AddScalarReplAggregatesPassWithThreshold;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, Threshold, __functionAddress);
    }

    public static void LLVMAddSimplifyLibCallsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddSimplifyLibCallsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddTailCallEliminationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddTailCallEliminationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddConstantPropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddConstantPropagationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddDemoteMemoryToRegisterPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDemoteMemoryToRegisterPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddVerifierPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddVerifierPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCorrelatedValuePropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCorrelatedValuePropagationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddEarlyCSEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddEarlyCSEPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddEarlyCSEMemSSAPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddEarlyCSEMemSSAPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLowerExpectIntrinsicPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerExpectIntrinsicPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLowerConstantIntrinsicsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerConstantIntrinsicsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddTypeBasedAliasAnalysisPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddTypeBasedAliasAnalysisPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScopedNoAliasAAPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScopedNoAliasAAPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddBasicAliasAnalysisPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddBasicAliasAnalysisPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddUnifyFunctionExitNodesPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddUnifyFunctionExitNodesPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLowerSwitchPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerSwitchPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddPromoteMemoryToRegisterPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddPromoteMemoryToRegisterPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddAddDiscriminatorsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAddDiscriminatorsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopVectorizePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopVectorizePass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddSLPVectorizePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddSLPVectorizePass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static final class Functions {
        public static final long AddAggressiveInstCombinerPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddAggressiveInstCombinerPass");
        public static final long AddCoroEarlyPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddCoroEarlyPass");
        public static final long AddCoroSplitPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddCoroSplitPass");
        public static final long AddCoroElidePass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddCoroElidePass");
        public static final long AddCoroCleanupPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddCoroCleanupPass");
        public static final long PassManagerBuilderAddCoroutinePassesToExtensionPoints = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderAddCoroutinePassesToExtensionPoints");
        public static final long AddInstructionCombiningPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddInstructionCombiningPass");
        public static final long AddInstructionSimplifyPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddInstructionSimplifyPass");
        public static final long AddArgumentPromotionPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddArgumentPromotionPass");
        public static final long AddConstantMergePass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddConstantMergePass");
        public static final long AddMergeFunctionsPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddMergeFunctionsPass");
        public static final long AddCalledValuePropagationPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddCalledValuePropagationPass");
        public static final long AddDeadArgEliminationPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddDeadArgEliminationPass");
        public static final long AddFunctionAttrsPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddFunctionAttrsPass");
        public static final long AddFunctionInliningPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddFunctionInliningPass");
        public static final long AddAlwaysInlinerPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddAlwaysInlinerPass");
        public static final long AddGlobalDCEPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddGlobalDCEPass");
        public static final long AddGlobalOptimizerPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddGlobalOptimizerPass");
        public static final long AddIPConstantPropagationPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddIPConstantPropagationPass");
        public static final long AddPruneEHPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddPruneEHPass");
        public static final long AddIPSCCPPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddIPSCCPPass");
        public static final long AddInternalizePass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddInternalizePass");
        public static final long AddInternalizePassWithMustPreservePredicate = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddInternalizePassWithMustPreservePredicate");
        public static final long AddStripDeadPrototypesPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddStripDeadPrototypesPass");
        public static final long AddStripSymbolsPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddStripSymbolsPass");
        public static final long RunPasses = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMRunPasses");
        public static final long CreatePassBuilderOptions = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMCreatePassBuilderOptions");
        public static final long PassBuilderOptionsSetVerifyEach = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetVerifyEach");
        public static final long PassBuilderOptionsSetDebugLogging = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetDebugLogging");
        public static final long PassBuilderOptionsSetLoopInterleaving = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetLoopInterleaving");
        public static final long PassBuilderOptionsSetLoopVectorization = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetLoopVectorization");
        public static final long PassBuilderOptionsSetSLPVectorization = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetSLPVectorization");
        public static final long PassBuilderOptionsSetLoopUnrolling = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetLoopUnrolling");
        public static final long PassBuilderOptionsSetForgetAllSCEVInLoopUnroll = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll");
        public static final long PassBuilderOptionsSetLicmMssaOptCap = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetLicmMssaOptCap");
        public static final long PassBuilderOptionsSetLicmMssaNoAccForPromotionCap = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap");
        public static final long PassBuilderOptionsSetCallGraphProfile = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetCallGraphProfile");
        public static final long PassBuilderOptionsSetMergeFunctions = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetMergeFunctions");
        public static final long PassBuilderOptionsSetInlinerThreshold = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassBuilderOptionsSetInlinerThreshold");
        public static final long DisposePassBuilderOptions = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMDisposePassBuilderOptions");
        public static final long PassManagerBuilderCreate = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderCreate");
        public static final long PassManagerBuilderDispose = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderDispose");
        public static final long PassManagerBuilderSetOptLevel = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetOptLevel");
        public static final long PassManagerBuilderSetSizeLevel = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetSizeLevel");
        public static final long PassManagerBuilderSetDisableUnitAtATime = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetDisableUnitAtATime");
        public static final long PassManagerBuilderSetDisableUnrollLoops = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetDisableUnrollLoops");
        public static final long PassManagerBuilderSetDisableSimplifyLibCalls = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetDisableSimplifyLibCalls");
        public static final long PassManagerBuilderUseInlinerWithThreshold = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderUseInlinerWithThreshold");
        public static final long PassManagerBuilderPopulateFunctionPassManager = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderPopulateFunctionPassManager");
        public static final long PassManagerBuilderPopulateModulePassManager = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderPopulateModulePassManager");
        public static final long PassManagerBuilderPopulateLTOPassManager = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMPassManagerBuilderPopulateLTOPassManager");
        public static final long AddAggressiveDCEPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddAggressiveDCEPass");
        public static final long AddDCEPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddDCEPass");
        public static final long AddBitTrackingDCEPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddBitTrackingDCEPass");
        public static final long AddAlignmentFromAssumptionsPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddAlignmentFromAssumptionsPass");
        public static final long AddCFGSimplificationPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddCFGSimplificationPass");
        public static final long AddDeadStoreEliminationPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddDeadStoreEliminationPass");
        public static final long AddScalarizerPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddScalarizerPass");
        public static final long AddMergedLoadStoreMotionPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddMergedLoadStoreMotionPass");
        public static final long AddGVNPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddGVNPass");
        public static final long AddNewGVNPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddNewGVNPass");
        public static final long AddIndVarSimplifyPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddIndVarSimplifyPass");
        public static final long AddJumpThreadingPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddJumpThreadingPass");
        public static final long AddLICMPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLICMPass");
        public static final long AddLoopDeletionPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLoopDeletionPass");
        public static final long AddLoopIdiomPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLoopIdiomPass");
        public static final long AddLoopRotatePass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLoopRotatePass");
        public static final long AddLoopRerollPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLoopRerollPass");
        public static final long AddLoopUnrollPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLoopUnrollPass");
        public static final long AddLoopUnrollAndJamPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLoopUnrollAndJamPass");
        public static final long AddLoopUnswitchPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLoopUnswitchPass");
        public static final long AddLowerAtomicPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLowerAtomicPass");
        public static final long AddMemCpyOptPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddMemCpyOptPass");
        public static final long AddPartiallyInlineLibCallsPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddPartiallyInlineLibCallsPass");
        public static final long AddReassociatePass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddReassociatePass");
        public static final long AddSCCPPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddSCCPPass");
        public static final long AddScalarReplAggregatesPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddScalarReplAggregatesPass");
        public static final long AddScalarReplAggregatesPassSSA = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddScalarReplAggregatesPassSSA");
        public static final long AddScalarReplAggregatesPassWithThreshold = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddScalarReplAggregatesPassWithThreshold");
        public static final long AddSimplifyLibCallsPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddSimplifyLibCallsPass");
        public static final long AddTailCallEliminationPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddTailCallEliminationPass");
        public static final long AddConstantPropagationPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddConstantPropagationPass");
        public static final long AddDemoteMemoryToRegisterPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddDemoteMemoryToRegisterPass");
        public static final long AddVerifierPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddVerifierPass");
        public static final long AddCorrelatedValuePropagationPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddCorrelatedValuePropagationPass");
        public static final long AddEarlyCSEPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddEarlyCSEPass");
        public static final long AddEarlyCSEMemSSAPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddEarlyCSEMemSSAPass");
        public static final long AddLowerExpectIntrinsicPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLowerExpectIntrinsicPass");
        public static final long AddLowerConstantIntrinsicsPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLowerConstantIntrinsicsPass");
        public static final long AddTypeBasedAliasAnalysisPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddTypeBasedAliasAnalysisPass");
        public static final long AddScopedNoAliasAAPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddScopedNoAliasAAPass");
        public static final long AddBasicAliasAnalysisPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddBasicAliasAnalysisPass");
        public static final long AddUnifyFunctionExitNodesPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddUnifyFunctionExitNodesPass");
        public static final long AddLowerSwitchPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLowerSwitchPass");
        public static final long AddPromoteMemoryToRegisterPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddPromoteMemoryToRegisterPass");
        public static final long AddAddDiscriminatorsPass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddAddDiscriminatorsPass");
        public static final long AddLoopVectorizePass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddLoopVectorizePass");
        public static final long AddSLPVectorizePass = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMAddSLPVectorizePass");

        private Functions() {
        }
    }
}

