/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkAllocator;
import org.lwjgl.nuklear.NkBufferMarker;
import org.lwjgl.nuklear.NkMemory;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_buffer")
public class NkBuffer
extends Struct<NkBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MARKER;
    public static final int POOL;
    public static final int TYPE;
    public static final int MEMORY;
    public static final int GROW_FACTOR;
    public static final int ALLOCATED;
    public static final int NEEDED;
    public static final int CALLS;
    public static final int SIZE;

    protected NkBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkBuffer create(long address, @Nullable ByteBuffer container) {
        return new NkBuffer(address, container);
    }

    public NkBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_buffer_marker[2]")
    public NkBufferMarker.Buffer marker() {
        return NkBuffer.nmarker(this.address());
    }

    @NativeType(value="struct nk_buffer_marker")
    public NkBufferMarker marker(int index) {
        return NkBuffer.nmarker(this.address(), index);
    }

    @NativeType(value="struct nk_allocator")
    public NkAllocator pool() {
        return NkBuffer.npool(this.address());
    }

    @NativeType(value="enum nk_allocation_type")
    public int type() {
        return NkBuffer.ntype(this.address());
    }

    @NativeType(value="struct nk_memory")
    public NkMemory memory() {
        return NkBuffer.nmemory(this.address());
    }

    public float grow_factor() {
        return NkBuffer.ngrow_factor(this.address());
    }

    @NativeType(value="nk_size")
    public long allocated() {
        return NkBuffer.nallocated(this.address());
    }

    @NativeType(value="nk_size")
    public long needed() {
        return NkBuffer.nneeded(this.address());
    }

    @NativeType(value="nk_size")
    public long calls() {
        return NkBuffer.ncalls(this.address());
    }

    @NativeType(value="nk_size")
    public long size() {
        return NkBuffer.nsize(this.address());
    }

    public static NkBuffer malloc() {
        return new NkBuffer(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkBuffer calloc() {
        return new NkBuffer(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkBuffer(MemoryUtil.memAddress(container), container);
    }

    public static NkBuffer create(long address) {
        return new NkBuffer(address, null);
    }

    public static @Nullable NkBuffer createSafe(long address) {
        return address == 0L ? null : new NkBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkBuffer.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkBuffer.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkBuffer mallocStack() {
        return NkBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkBuffer callocStack() {
        return NkBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkBuffer mallocStack(MemoryStack stack) {
        return NkBuffer.malloc(stack);
    }

    @Deprecated
    public static NkBuffer callocStack(MemoryStack stack) {
        return NkBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkBuffer.calloc(capacity, stack);
    }

    public static NkBuffer malloc(MemoryStack stack) {
        return new NkBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkBuffer calloc(MemoryStack stack) {
        return new NkBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkBufferMarker.Buffer nmarker(long struct) {
        return NkBufferMarker.create(struct + (long)MARKER, 2);
    }

    public static NkBufferMarker nmarker(long struct, int index) {
        return NkBufferMarker.create(struct + (long)MARKER + Checks.check(index, 2) * (long)NkBufferMarker.SIZEOF);
    }

    public static NkAllocator npool(long struct) {
        return NkAllocator.create(struct + (long)POOL);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static NkMemory nmemory(long struct) {
        return NkMemory.create(struct + (long)MEMORY);
    }

    public static float ngrow_factor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GROW_FACTOR);
    }

    public static long nallocated(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ALLOCATED);
    }

    public static long nneeded(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEEDED);
    }

    public static long ncalls(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CALLS);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    static {
        Struct.Layout layout = NkBuffer.__struct(NkBuffer.__array(NkBufferMarker.SIZEOF, NkBufferMarker.ALIGNOF, 2), NkBuffer.__member(NkAllocator.SIZEOF, NkAllocator.ALIGNOF), NkBuffer.__member(4), NkBuffer.__member(NkMemory.SIZEOF, NkMemory.ALIGNOF), NkBuffer.__member(4), NkBuffer.__member(POINTER_SIZE), NkBuffer.__member(POINTER_SIZE), NkBuffer.__member(POINTER_SIZE), NkBuffer.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MARKER = layout.offsetof(0);
        POOL = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        GROW_FACTOR = layout.offsetof(4);
        ALLOCATED = layout.offsetof(5);
        NEEDED = layout.offsetof(6);
        CALLS = layout.offsetof(7);
        SIZE = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<NkBuffer, Buffer>
    implements NativeResource {
        private static final NkBuffer ELEMENT_FACTORY = NkBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_buffer_marker[2]")
        public NkBufferMarker.Buffer marker() {
            return NkBuffer.nmarker(this.address());
        }

        @NativeType(value="struct nk_buffer_marker")
        public NkBufferMarker marker(int index) {
            return NkBuffer.nmarker(this.address(), index);
        }

        @NativeType(value="struct nk_allocator")
        public NkAllocator pool() {
            return NkBuffer.npool(this.address());
        }

        @NativeType(value="enum nk_allocation_type")
        public int type() {
            return NkBuffer.ntype(this.address());
        }

        @NativeType(value="struct nk_memory")
        public NkMemory memory() {
            return NkBuffer.nmemory(this.address());
        }

        public float grow_factor() {
            return NkBuffer.ngrow_factor(this.address());
        }

        @NativeType(value="nk_size")
        public long allocated() {
            return NkBuffer.nallocated(this.address());
        }

        @NativeType(value="nk_size")
        public long needed() {
            return NkBuffer.nneeded(this.address());
        }

        @NativeType(value="nk_size")
        public long calls() {
            return NkBuffer.ncalls(this.address());
        }

        @NativeType(value="nk_size")
        public long size() {
            return NkBuffer.nsize(this.address());
        }
    }
}

