/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkDrawNullTexture;
import org.lwjgl.nuklear.NkDrawVertexLayoutElement;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_convert_config")
public class NkConvertConfig
extends Struct<NkConvertConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int GLOBAL_ALPHA;
    public static final int LINE_AA;
    public static final int SHAPE_AA;
    public static final int CIRCLE_SEGMENT_COUNT;
    public static final int ARC_SEGMENT_COUNT;
    public static final int CURVE_SEGMENT_COUNT;
    public static final int TEX_NULL;
    public static final int VERTEX_LAYOUT;
    public static final int VERTEX_SIZE;
    public static final int VERTEX_ALIGNMENT;

    protected NkConvertConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkConvertConfig create(long address, @Nullable ByteBuffer container) {
        return new NkConvertConfig(address, container);
    }

    public NkConvertConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkConvertConfig.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float global_alpha() {
        return NkConvertConfig.nglobal_alpha(this.address());
    }

    @NativeType(value="enum nk_anti_aliasing")
    public int line_AA() {
        return NkConvertConfig.nline_AA(this.address());
    }

    @NativeType(value="enum nk_anti_aliasing")
    public int shape_AA() {
        return NkConvertConfig.nshape_AA(this.address());
    }

    @NativeType(value="unsigned int")
    public int circle_segment_count() {
        return NkConvertConfig.ncircle_segment_count(this.address());
    }

    @NativeType(value="unsigned int")
    public int arc_segment_count() {
        return NkConvertConfig.narc_segment_count(this.address());
    }

    @NativeType(value="unsigned int")
    public int curve_segment_count() {
        return NkConvertConfig.ncurve_segment_count(this.address());
    }

    @NativeType(value="struct nk_draw_null_texture")
    public NkDrawNullTexture tex_null() {
        return NkConvertConfig.ntex_null(this.address());
    }

    @NativeType(value="struct nk_draw_vertex_layout_element *")
    public NkDrawVertexLayoutElement.Buffer vertex_layout(int capacity) {
        return NkConvertConfig.nvertex_layout(this.address(), capacity);
    }

    @NativeType(value="nk_size")
    public long vertex_size() {
        return NkConvertConfig.nvertex_size(this.address());
    }

    @NativeType(value="nk_size")
    public long vertex_alignment() {
        return NkConvertConfig.nvertex_alignment(this.address());
    }

    public NkConvertConfig global_alpha(float value) {
        NkConvertConfig.nglobal_alpha(this.address(), value);
        return this;
    }

    public NkConvertConfig line_AA(@NativeType(value="enum nk_anti_aliasing") int value) {
        NkConvertConfig.nline_AA(this.address(), value);
        return this;
    }

    public NkConvertConfig shape_AA(@NativeType(value="enum nk_anti_aliasing") int value) {
        NkConvertConfig.nshape_AA(this.address(), value);
        return this;
    }

    public NkConvertConfig circle_segment_count(@NativeType(value="unsigned int") int value) {
        NkConvertConfig.ncircle_segment_count(this.address(), value);
        return this;
    }

    public NkConvertConfig arc_segment_count(@NativeType(value="unsigned int") int value) {
        NkConvertConfig.narc_segment_count(this.address(), value);
        return this;
    }

    public NkConvertConfig curve_segment_count(@NativeType(value="unsigned int") int value) {
        NkConvertConfig.ncurve_segment_count(this.address(), value);
        return this;
    }

    public NkConvertConfig tex_null(@NativeType(value="struct nk_draw_null_texture") NkDrawNullTexture value) {
        NkConvertConfig.ntex_null(this.address(), value);
        return this;
    }

    public NkConvertConfig tex_null(Consumer<NkDrawNullTexture> consumer) {
        consumer.accept(this.tex_null());
        return this;
    }

    public NkConvertConfig vertex_layout(@NativeType(value="struct nk_draw_vertex_layout_element *") NkDrawVertexLayoutElement.Buffer value) {
        NkConvertConfig.nvertex_layout(this.address(), value);
        return this;
    }

    public NkConvertConfig vertex_size(@NativeType(value="nk_size") long value) {
        NkConvertConfig.nvertex_size(this.address(), value);
        return this;
    }

    public NkConvertConfig vertex_alignment(@NativeType(value="nk_size") long value) {
        NkConvertConfig.nvertex_alignment(this.address(), value);
        return this;
    }

    public NkConvertConfig set(float global_alpha, int line_AA, int shape_AA, int circle_segment_count, int arc_segment_count, int curve_segment_count, NkDrawNullTexture tex_null, NkDrawVertexLayoutElement.Buffer vertex_layout, long vertex_size, long vertex_alignment) {
        this.global_alpha(global_alpha);
        this.line_AA(line_AA);
        this.shape_AA(shape_AA);
        this.circle_segment_count(circle_segment_count);
        this.arc_segment_count(arc_segment_count);
        this.curve_segment_count(curve_segment_count);
        this.tex_null(tex_null);
        this.vertex_layout(vertex_layout);
        this.vertex_size(vertex_size);
        this.vertex_alignment(vertex_alignment);
        return this;
    }

    public NkConvertConfig set(NkConvertConfig src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkConvertConfig malloc() {
        return new NkConvertConfig(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkConvertConfig calloc() {
        return new NkConvertConfig(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkConvertConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkConvertConfig(MemoryUtil.memAddress(container), container);
    }

    public static NkConvertConfig create(long address) {
        return new NkConvertConfig(address, null);
    }

    public static @Nullable NkConvertConfig createSafe(long address) {
        return address == 0L ? null : new NkConvertConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkConvertConfig.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkConvertConfig.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkConvertConfig mallocStack() {
        return NkConvertConfig.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkConvertConfig callocStack() {
        return NkConvertConfig.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkConvertConfig mallocStack(MemoryStack stack) {
        return NkConvertConfig.malloc(stack);
    }

    @Deprecated
    public static NkConvertConfig callocStack(MemoryStack stack) {
        return NkConvertConfig.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkConvertConfig.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkConvertConfig.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkConvertConfig.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkConvertConfig.calloc(capacity, stack);
    }

    public static NkConvertConfig malloc(MemoryStack stack) {
        return new NkConvertConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkConvertConfig calloc(MemoryStack stack) {
        return new NkConvertConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nglobal_alpha(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GLOBAL_ALPHA);
    }

    public static int nline_AA(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LINE_AA);
    }

    public static int nshape_AA(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHAPE_AA);
    }

    public static int ncircle_segment_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CIRCLE_SEGMENT_COUNT);
    }

    public static int narc_segment_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ARC_SEGMENT_COUNT);
    }

    public static int ncurve_segment_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURVE_SEGMENT_COUNT);
    }

    public static NkDrawNullTexture ntex_null(long struct) {
        return NkDrawNullTexture.create(struct + (long)TEX_NULL);
    }

    public static NkDrawVertexLayoutElement.Buffer nvertex_layout(long struct, int capacity) {
        return NkDrawVertexLayoutElement.create(MemoryUtil.memGetAddress(struct + (long)VERTEX_LAYOUT), capacity);
    }

    public static long nvertex_size(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VERTEX_SIZE);
    }

    public static long nvertex_alignment(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VERTEX_ALIGNMENT);
    }

    public static void nglobal_alpha(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)GLOBAL_ALPHA, value);
    }

    public static void nline_AA(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LINE_AA, value);
    }

    public static void nshape_AA(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHAPE_AA, value);
    }

    public static void ncircle_segment_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CIRCLE_SEGMENT_COUNT, value);
    }

    public static void narc_segment_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ARC_SEGMENT_COUNT, value);
    }

    public static void ncurve_segment_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CURVE_SEGMENT_COUNT, value);
    }

    public static void ntex_null(long struct, NkDrawNullTexture value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEX_NULL, NkDrawNullTexture.SIZEOF);
    }

    public static void nvertex_layout(long struct, NkDrawVertexLayoutElement.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEX_LAYOUT, value.address());
    }

    public static void nvertex_size(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEX_SIZE, value);
    }

    public static void nvertex_alignment(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEX_ALIGNMENT, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTEX_LAYOUT));
    }

    static {
        Struct.Layout layout = NkConvertConfig.__struct(NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(NkDrawNullTexture.SIZEOF, NkDrawNullTexture.ALIGNOF), NkConvertConfig.__member(POINTER_SIZE), NkConvertConfig.__member(POINTER_SIZE), NkConvertConfig.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        GLOBAL_ALPHA = layout.offsetof(0);
        LINE_AA = layout.offsetof(1);
        SHAPE_AA = layout.offsetof(2);
        CIRCLE_SEGMENT_COUNT = layout.offsetof(3);
        ARC_SEGMENT_COUNT = layout.offsetof(4);
        CURVE_SEGMENT_COUNT = layout.offsetof(5);
        TEX_NULL = layout.offsetof(6);
        VERTEX_LAYOUT = layout.offsetof(7);
        VERTEX_SIZE = layout.offsetof(8);
        VERTEX_ALIGNMENT = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<NkConvertConfig, Buffer>
    implements NativeResource {
        private static final NkConvertConfig ELEMENT_FACTORY = NkConvertConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkConvertConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float global_alpha() {
            return NkConvertConfig.nglobal_alpha(this.address());
        }

        @NativeType(value="enum nk_anti_aliasing")
        public int line_AA() {
            return NkConvertConfig.nline_AA(this.address());
        }

        @NativeType(value="enum nk_anti_aliasing")
        public int shape_AA() {
            return NkConvertConfig.nshape_AA(this.address());
        }

        @NativeType(value="unsigned int")
        public int circle_segment_count() {
            return NkConvertConfig.ncircle_segment_count(this.address());
        }

        @NativeType(value="unsigned int")
        public int arc_segment_count() {
            return NkConvertConfig.narc_segment_count(this.address());
        }

        @NativeType(value="unsigned int")
        public int curve_segment_count() {
            return NkConvertConfig.ncurve_segment_count(this.address());
        }

        @NativeType(value="struct nk_draw_null_texture")
        public NkDrawNullTexture tex_null() {
            return NkConvertConfig.ntex_null(this.address());
        }

        @NativeType(value="struct nk_draw_vertex_layout_element *")
        public NkDrawVertexLayoutElement.Buffer vertex_layout(int capacity) {
            return NkConvertConfig.nvertex_layout(this.address(), capacity);
        }

        @NativeType(value="nk_size")
        public long vertex_size() {
            return NkConvertConfig.nvertex_size(this.address());
        }

        @NativeType(value="nk_size")
        public long vertex_alignment() {
            return NkConvertConfig.nvertex_alignment(this.address());
        }

        public Buffer global_alpha(float value) {
            NkConvertConfig.nglobal_alpha(this.address(), value);
            return this;
        }

        public Buffer line_AA(@NativeType(value="enum nk_anti_aliasing") int value) {
            NkConvertConfig.nline_AA(this.address(), value);
            return this;
        }

        public Buffer shape_AA(@NativeType(value="enum nk_anti_aliasing") int value) {
            NkConvertConfig.nshape_AA(this.address(), value);
            return this;
        }

        public Buffer circle_segment_count(@NativeType(value="unsigned int") int value) {
            NkConvertConfig.ncircle_segment_count(this.address(), value);
            return this;
        }

        public Buffer arc_segment_count(@NativeType(value="unsigned int") int value) {
            NkConvertConfig.narc_segment_count(this.address(), value);
            return this;
        }

        public Buffer curve_segment_count(@NativeType(value="unsigned int") int value) {
            NkConvertConfig.ncurve_segment_count(this.address(), value);
            return this;
        }

        public Buffer tex_null(@NativeType(value="struct nk_draw_null_texture") NkDrawNullTexture value) {
            NkConvertConfig.ntex_null(this.address(), value);
            return this;
        }

        public Buffer tex_null(Consumer<NkDrawNullTexture> consumer) {
            consumer.accept(this.tex_null());
            return this;
        }

        public Buffer vertex_layout(@NativeType(value="struct nk_draw_vertex_layout_element *") NkDrawVertexLayoutElement.Buffer value) {
            NkConvertConfig.nvertex_layout(this.address(), value);
            return this;
        }

        public Buffer vertex_size(@NativeType(value="nk_size") long value) {
            NkConvertConfig.nvertex_size(this.address(), value);
            return this;
        }

        public Buffer vertex_alignment(@NativeType(value="nk_size") long value) {
            NkConvertConfig.nvertex_alignment(this.address(), value);
            return this;
        }
    }
}

