/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_key")
public class NkKey
extends Struct<NkKey> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DOWN;
    public static final int CLICKED;

    protected NkKey(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkKey create(long address, @Nullable ByteBuffer container) {
        return new NkKey(address, container);
    }

    public NkKey(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkKey.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_bool")
    public boolean down() {
        return NkKey.ndown(this.address());
    }

    @NativeType(value="unsigned int")
    public int clicked() {
        return NkKey.nclicked(this.address());
    }

    public static NkKey create(long address) {
        return new NkKey(address, null);
    }

    public static @Nullable NkKey createSafe(long address) {
        return address == 0L ? null : new NkKey(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static boolean ndown(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DOWN) != 0;
    }

    public static int nclicked(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLICKED);
    }

    static {
        Struct.Layout layout = NkKey.__struct(NkKey.__member(1), NkKey.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DOWN = layout.offsetof(0);
        CLICKED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkKey, Buffer> {
        private static final NkKey ELEMENT_FACTORY = NkKey.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkKey getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_bool")
        public boolean down() {
            return NkKey.ndown(this.address());
        }

        @NativeType(value="unsigned int")
        public int clicked() {
            return NkKey.nclicked(this.address());
        }
    }
}

