/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_button")
public class NkStyleButton
extends Struct<NkStyleButton>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int COLOR_FACTOR_BACKGROUND;
    public static final int TEXT_BACKGROUND;
    public static final int TEXT_NORMAL;
    public static final int TEXT_HOVER;
    public static final int TEXT_ACTIVE;
    public static final int TEXT_ALIGNMENT;
    public static final int COLOR_FACTOR_TEXT;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int PADDING;
    public static final int IMAGE_PADDING;
    public static final int TOUCH_PADDING;
    public static final int DISABLED_FACTOR;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    protected NkStyleButton(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkStyleButton create(long address, @Nullable ByteBuffer container) {
        return new NkStyleButton(address, container);
    }

    public NkStyleButton(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkStyleButton.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleButton.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleButton.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleButton.nactive(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleButton.nborder_color(this.address());
    }

    public float color_factor_background() {
        return NkStyleButton.ncolor_factor_background(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_background() {
        return NkStyleButton.ntext_background(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_normal() {
        return NkStyleButton.ntext_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_hover() {
        return NkStyleButton.ntext_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_active() {
        return NkStyleButton.ntext_active(this.address());
    }

    @NativeType(value="nk_flags")
    public int text_alignment() {
        return NkStyleButton.ntext_alignment(this.address());
    }

    public float color_factor_text() {
        return NkStyleButton.ncolor_factor_text(this.address());
    }

    public float border() {
        return NkStyleButton.nborder(this.address());
    }

    public float rounding() {
        return NkStyleButton.nrounding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleButton.npadding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 image_padding() {
        return NkStyleButton.nimage_padding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 touch_padding() {
        return NkStyleButton.ntouch_padding(this.address());
    }

    public float disabled_factor() {
        return NkStyleButton.ndisabled_factor(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkStyleButton.nuserdata(this.address());
    }

    @NativeType(value="nk_draw_begin")
    public @Nullable NkDrawBeginCallback draw_begin() {
        return NkStyleButton.ndraw_begin(this.address());
    }

    @NativeType(value="nk_draw_end")
    public @Nullable NkDrawEndCallback draw_end() {
        return NkStyleButton.ndraw_end(this.address());
    }

    public NkStyleButton normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleButton.nnormal(this.address(), value);
        return this;
    }

    public NkStyleButton normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleButton hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleButton.nhover(this.address(), value);
        return this;
    }

    public NkStyleButton hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleButton active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleButton.nactive(this.address(), value);
        return this;
    }

    public NkStyleButton active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleButton border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleButton.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleButton border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleButton color_factor_background(float value) {
        NkStyleButton.ncolor_factor_background(this.address(), value);
        return this;
    }

    public NkStyleButton text_background(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleButton.ntext_background(this.address(), value);
        return this;
    }

    public NkStyleButton text_background(Consumer<NkColor> consumer) {
        consumer.accept(this.text_background());
        return this;
    }

    public NkStyleButton text_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleButton.ntext_normal(this.address(), value);
        return this;
    }

    public NkStyleButton text_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.text_normal());
        return this;
    }

    public NkStyleButton text_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleButton.ntext_hover(this.address(), value);
        return this;
    }

    public NkStyleButton text_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.text_hover());
        return this;
    }

    public NkStyleButton text_active(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleButton.ntext_active(this.address(), value);
        return this;
    }

    public NkStyleButton text_active(Consumer<NkColor> consumer) {
        consumer.accept(this.text_active());
        return this;
    }

    public NkStyleButton text_alignment(@NativeType(value="nk_flags") int value) {
        NkStyleButton.ntext_alignment(this.address(), value);
        return this;
    }

    public NkStyleButton color_factor_text(float value) {
        NkStyleButton.ncolor_factor_text(this.address(), value);
        return this;
    }

    public NkStyleButton border(float value) {
        NkStyleButton.nborder(this.address(), value);
        return this;
    }

    public NkStyleButton rounding(float value) {
        NkStyleButton.nrounding(this.address(), value);
        return this;
    }

    public NkStyleButton padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleButton.npadding(this.address(), value);
        return this;
    }

    public NkStyleButton padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleButton image_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleButton.nimage_padding(this.address(), value);
        return this;
    }

    public NkStyleButton image_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.image_padding());
        return this;
    }

    public NkStyleButton touch_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleButton.ntouch_padding(this.address(), value);
        return this;
    }

    public NkStyleButton touch_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.touch_padding());
        return this;
    }

    public NkStyleButton disabled_factor(float value) {
        NkStyleButton.ndisabled_factor(this.address(), value);
        return this;
    }

    public NkStyleButton userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkStyleButton.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleButton userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkStyleButton draw_begin(@NativeType(value="nk_draw_begin") @Nullable NkDrawBeginCallbackI value) {
        NkStyleButton.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleButton draw_end(@NativeType(value="nk_draw_end") @Nullable NkDrawEndCallbackI value) {
        NkStyleButton.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleButton set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, float color_factor_background, NkColor text_background, NkColor text_normal, NkColor text_hover, NkColor text_active, int text_alignment, float color_factor_text, float border, float rounding, NkVec2 padding, NkVec2 image_padding, NkVec2 touch_padding, float disabled_factor, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.color_factor_background(color_factor_background);
        this.text_background(text_background);
        this.text_normal(text_normal);
        this.text_hover(text_hover);
        this.text_active(text_active);
        this.text_alignment(text_alignment);
        this.color_factor_text(color_factor_text);
        this.border(border);
        this.rounding(rounding);
        this.padding(padding);
        this.image_padding(image_padding);
        this.touch_padding(touch_padding);
        this.disabled_factor(disabled_factor);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleButton set(NkStyleButton src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleButton malloc() {
        return new NkStyleButton(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkStyleButton calloc() {
        return new NkStyleButton(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkStyleButton create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkStyleButton(MemoryUtil.memAddress(container), container);
    }

    public static NkStyleButton create(long address) {
        return new NkStyleButton(address, null);
    }

    public static @Nullable NkStyleButton createSafe(long address) {
        return address == 0L ? null : new NkStyleButton(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkStyleButton.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleButton.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleButton mallocStack() {
        return NkStyleButton.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleButton callocStack() {
        return NkStyleButton.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleButton mallocStack(MemoryStack stack) {
        return NkStyleButton.malloc(stack);
    }

    @Deprecated
    public static NkStyleButton callocStack(MemoryStack stack) {
        return NkStyleButton.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleButton.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleButton.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleButton.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleButton.calloc(capacity, stack);
    }

    public static NkStyleButton malloc(MemoryStack stack) {
        return new NkStyleButton(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleButton calloc(MemoryStack stack) {
        return new NkStyleButton(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static float ncolor_factor_background(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)COLOR_FACTOR_BACKGROUND);
    }

    public static NkColor ntext_background(long struct) {
        return NkColor.create(struct + (long)TEXT_BACKGROUND);
    }

    public static NkColor ntext_normal(long struct) {
        return NkColor.create(struct + (long)TEXT_NORMAL);
    }

    public static NkColor ntext_hover(long struct) {
        return NkColor.create(struct + (long)TEXT_HOVER);
    }

    public static NkColor ntext_active(long struct) {
        return NkColor.create(struct + (long)TEXT_ACTIVE);
    }

    public static int ntext_alignment(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXT_ALIGNMENT);
    }

    public static float ncolor_factor_text(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)COLOR_FACTOR_TEXT);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 nimage_padding(long struct) {
        return NkVec2.create(struct + (long)IMAGE_PADDING);
    }

    public static NkVec2 ntouch_padding(long struct) {
        return NkVec2.create(struct + (long)TOUCH_PADDING);
    }

    public static float ndisabled_factor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DISABLED_FACTOR);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static @Nullable NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    public static @Nullable NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ncolor_factor_background(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)COLOR_FACTOR_BACKGROUND, value);
    }

    public static void ntext_background(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_BACKGROUND, NkColor.SIZEOF);
    }

    public static void ntext_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_NORMAL, NkColor.SIZEOF);
    }

    public static void ntext_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_HOVER, NkColor.SIZEOF);
    }

    public static void ntext_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_ACTIVE, NkColor.SIZEOF);
    }

    public static void ntext_alignment(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXT_ALIGNMENT, value);
    }

    public static void ncolor_factor_text(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)COLOR_FACTOR_TEXT, value);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nimage_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGE_PADDING, NkVec2.SIZEOF);
    }

    public static void ntouch_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TOUCH_PADDING, NkVec2.SIZEOF);
    }

    public static void ndisabled_factor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DISABLED_FACTOR, value);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, @Nullable NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, MemoryUtil.memAddressSafe(value));
    }

    public static void ndraw_end(long struct, @Nullable NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleButton.__struct(NkStyleButton.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleButton.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleButton.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(4), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleButton.__member(4), NkStyleButton.__member(4), NkStyleButton.__member(4), NkStyleButton.__member(4), NkStyleButton.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleButton.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleButton.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleButton.__member(4), NkStyleButton.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleButton.__member(POINTER_SIZE), NkStyleButton.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        COLOR_FACTOR_BACKGROUND = layout.offsetof(4);
        TEXT_BACKGROUND = layout.offsetof(5);
        TEXT_NORMAL = layout.offsetof(6);
        TEXT_HOVER = layout.offsetof(7);
        TEXT_ACTIVE = layout.offsetof(8);
        TEXT_ALIGNMENT = layout.offsetof(9);
        COLOR_FACTOR_TEXT = layout.offsetof(10);
        BORDER = layout.offsetof(11);
        ROUNDING = layout.offsetof(12);
        PADDING = layout.offsetof(13);
        IMAGE_PADDING = layout.offsetof(14);
        TOUCH_PADDING = layout.offsetof(15);
        DISABLED_FACTOR = layout.offsetof(16);
        USERDATA = layout.offsetof(17);
        DRAW_BEGIN = layout.offsetof(18);
        DRAW_END = layout.offsetof(19);
    }

    public static class Buffer
    extends StructBuffer<NkStyleButton, Buffer>
    implements NativeResource {
        private static final NkStyleButton ELEMENT_FACTORY = NkStyleButton.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkStyleButton getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleButton.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleButton.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleButton.nactive(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleButton.nborder_color(this.address());
        }

        public float color_factor_background() {
            return NkStyleButton.ncolor_factor_background(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_background() {
            return NkStyleButton.ntext_background(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_normal() {
            return NkStyleButton.ntext_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_hover() {
            return NkStyleButton.ntext_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_active() {
            return NkStyleButton.ntext_active(this.address());
        }

        @NativeType(value="nk_flags")
        public int text_alignment() {
            return NkStyleButton.ntext_alignment(this.address());
        }

        public float color_factor_text() {
            return NkStyleButton.ncolor_factor_text(this.address());
        }

        public float border() {
            return NkStyleButton.nborder(this.address());
        }

        public float rounding() {
            return NkStyleButton.nrounding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleButton.npadding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 image_padding() {
            return NkStyleButton.nimage_padding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 touch_padding() {
            return NkStyleButton.ntouch_padding(this.address());
        }

        public float disabled_factor() {
            return NkStyleButton.ndisabled_factor(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkStyleButton.nuserdata(this.address());
        }

        @NativeType(value="nk_draw_begin")
        public @Nullable NkDrawBeginCallback draw_begin() {
            return NkStyleButton.ndraw_begin(this.address());
        }

        @NativeType(value="nk_draw_end")
        public @Nullable NkDrawEndCallback draw_end() {
            return NkStyleButton.ndraw_end(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleButton.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleButton.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleButton.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleButton.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer color_factor_background(float value) {
            NkStyleButton.ncolor_factor_background(this.address(), value);
            return this;
        }

        public Buffer text_background(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleButton.ntext_background(this.address(), value);
            return this;
        }

        public Buffer text_background(Consumer<NkColor> consumer) {
            consumer.accept(this.text_background());
            return this;
        }

        public Buffer text_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleButton.ntext_normal(this.address(), value);
            return this;
        }

        public Buffer text_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.text_normal());
            return this;
        }

        public Buffer text_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleButton.ntext_hover(this.address(), value);
            return this;
        }

        public Buffer text_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.text_hover());
            return this;
        }

        public Buffer text_active(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleButton.ntext_active(this.address(), value);
            return this;
        }

        public Buffer text_active(Consumer<NkColor> consumer) {
            consumer.accept(this.text_active());
            return this;
        }

        public Buffer text_alignment(@NativeType(value="nk_flags") int value) {
            NkStyleButton.ntext_alignment(this.address(), value);
            return this;
        }

        public Buffer color_factor_text(float value) {
            NkStyleButton.ncolor_factor_text(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleButton.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleButton.nrounding(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleButton.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer image_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleButton.nimage_padding(this.address(), value);
            return this;
        }

        public Buffer image_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.image_padding());
            return this;
        }

        public Buffer touch_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleButton.ntouch_padding(this.address(), value);
            return this;
        }

        public Buffer touch_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.touch_padding());
            return this;
        }

        public Buffer disabled_factor(float value) {
            NkStyleButton.ndisabled_factor(this.address(), value);
            return this;
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkStyleButton.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer draw_begin(@NativeType(value="nk_draw_begin") @Nullable NkDrawBeginCallbackI value) {
            NkStyleButton.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(@NativeType(value="nk_draw_end") @Nullable NkDrawEndCallbackI value) {
            NkStyleButton.ndraw_end(this.address(), value);
            return this;
        }
    }
}

