/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkImage;
import org.lwjgl.nuklear.NkNineSlice;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union nk_style_item_data")
public class NkStyleItemData
extends Struct<NkStyleItemData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR;
    public static final int IMAGE;
    public static final int SLICE;

    protected NkStyleItemData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkStyleItemData create(long address, @Nullable ByteBuffer container) {
        return new NkStyleItemData(address, container);
    }

    public NkStyleItemData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkStyleItemData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_color")
    public NkColor color() {
        return NkStyleItemData.ncolor(this.address());
    }

    @NativeType(value="struct nk_image")
    public NkImage image() {
        return NkStyleItemData.nimage(this.address());
    }

    @NativeType(value="struct nk_nine_slice")
    public NkNineSlice slice$() {
        return NkStyleItemData.nslice$(this.address());
    }

    public NkStyleItemData color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleItemData.ncolor(this.address(), value);
        return this;
    }

    public NkStyleItemData color(Consumer<NkColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public NkStyleItemData image(@NativeType(value="struct nk_image") NkImage value) {
        NkStyleItemData.nimage(this.address(), value);
        return this;
    }

    public NkStyleItemData image(Consumer<NkImage> consumer) {
        consumer.accept(this.image());
        return this;
    }

    public NkStyleItemData slice$(@NativeType(value="struct nk_nine_slice") NkNineSlice value) {
        NkStyleItemData.nslice$(this.address(), value);
        return this;
    }

    public NkStyleItemData slice$(Consumer<NkNineSlice> consumer) {
        consumer.accept(this.slice$());
        return this;
    }

    public NkStyleItemData set(NkStyleItemData src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleItemData malloc() {
        return new NkStyleItemData(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkStyleItemData calloc() {
        return new NkStyleItemData(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkStyleItemData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkStyleItemData(MemoryUtil.memAddress(container), container);
    }

    public static NkStyleItemData create(long address) {
        return new NkStyleItemData(address, null);
    }

    public static @Nullable NkStyleItemData createSafe(long address) {
        return address == 0L ? null : new NkStyleItemData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkStyleItemData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleItemData.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleItemData mallocStack() {
        return NkStyleItemData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleItemData callocStack() {
        return NkStyleItemData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleItemData mallocStack(MemoryStack stack) {
        return NkStyleItemData.malloc(stack);
    }

    @Deprecated
    public static NkStyleItemData callocStack(MemoryStack stack) {
        return NkStyleItemData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleItemData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleItemData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleItemData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleItemData.calloc(capacity, stack);
    }

    public static NkStyleItemData malloc(MemoryStack stack) {
        return new NkStyleItemData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleItemData calloc(MemoryStack stack) {
        return new NkStyleItemData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkColor ncolor(long struct) {
        return NkColor.create(struct + (long)COLOR);
    }

    public static NkImage nimage(long struct) {
        return NkImage.create(struct + (long)IMAGE);
    }

    public static NkNineSlice nslice$(long struct) {
        return NkNineSlice.create(struct + (long)SLICE);
    }

    public static void ncolor(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, NkColor.SIZEOF);
    }

    public static void nimage(long struct, NkImage value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGE, NkImage.SIZEOF);
    }

    public static void nslice$(long struct, NkNineSlice value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SLICE, NkNineSlice.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleItemData.__union(NkStyleItemData.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleItemData.__member(NkImage.SIZEOF, NkImage.ALIGNOF), NkStyleItemData.__member(NkNineSlice.SIZEOF, NkNineSlice.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR = layout.offsetof(0);
        IMAGE = layout.offsetof(1);
        SLICE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkStyleItemData, Buffer>
    implements NativeResource {
        private static final NkStyleItemData ELEMENT_FACTORY = NkStyleItemData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkStyleItemData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_color")
        public NkColor color() {
            return NkStyleItemData.ncolor(this.address());
        }

        @NativeType(value="struct nk_image")
        public NkImage image() {
            return NkStyleItemData.nimage(this.address());
        }

        @NativeType(value="struct nk_nine_slice")
        public NkNineSlice slice$() {
            return NkStyleItemData.nslice$(this.address());
        }

        public Buffer color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleItemData.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<NkColor> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer image(@NativeType(value="struct nk_image") NkImage value) {
            NkStyleItemData.nimage(this.address(), value);
            return this;
        }

        public Buffer image(Consumer<NkImage> consumer) {
            consumer.accept(this.image());
            return this;
        }

        public Buffer slice$(@NativeType(value="struct nk_nine_slice") NkNineSlice value) {
            NkStyleItemData.nslice$(this.address(), value);
            return this;
        }

        public Buffer slice$(Consumer<NkNineSlice> consumer) {
            consumer.accept(this.slice$());
            return this;
        }
    }
}

