/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_knob")
public class NkStyleKnob
extends Struct<NkStyleKnob>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int KNOB_NORMAL;
    public static final int KNOB_HOVER;
    public static final int KNOB_ACTIVE;
    public static final int KNOB_BORDER_COLOR;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int CURSOR_ACTIVE;
    public static final int BORDER;
    public static final int KNOB_BORDER;
    public static final int PADDING;
    public static final int SPACING;
    public static final int CURSOR_WIDTH;
    public static final int COLOR_FACTOR;
    public static final int DISABLED_FACTOR;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    protected NkStyleKnob(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkStyleKnob create(long address, @Nullable ByteBuffer container) {
        return new NkStyleKnob(address, container);
    }

    public NkStyleKnob(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkStyleKnob.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleKnob.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleKnob.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleKnob.nactive(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleKnob.nborder_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor knob_normal() {
        return NkStyleKnob.nknob_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor knob_hover() {
        return NkStyleKnob.nknob_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor knob_active() {
        return NkStyleKnob.nknob_active(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor knob_border_color() {
        return NkStyleKnob.nknob_border_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_normal() {
        return NkStyleKnob.ncursor_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_hover() {
        return NkStyleKnob.ncursor_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_active() {
        return NkStyleKnob.ncursor_active(this.address());
    }

    public float border() {
        return NkStyleKnob.nborder(this.address());
    }

    public float knob_border() {
        return NkStyleKnob.nknob_border(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleKnob.npadding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 spacing() {
        return NkStyleKnob.nspacing(this.address());
    }

    public float cursor_width() {
        return NkStyleKnob.ncursor_width(this.address());
    }

    public float color_factor() {
        return NkStyleKnob.ncolor_factor(this.address());
    }

    public float disabled_factor() {
        return NkStyleKnob.ndisabled_factor(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkStyleKnob.nuserdata(this.address());
    }

    @NativeType(value="nk_draw_begin")
    public @Nullable NkDrawBeginCallback draw_begin() {
        return NkStyleKnob.ndraw_begin(this.address());
    }

    @NativeType(value="nk_draw_end")
    public @Nullable NkDrawEndCallback draw_end() {
        return NkStyleKnob.ndraw_end(this.address());
    }

    public NkStyleKnob normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleKnob.nnormal(this.address(), value);
        return this;
    }

    public NkStyleKnob normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleKnob hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleKnob.nhover(this.address(), value);
        return this;
    }

    public NkStyleKnob hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleKnob active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleKnob.nactive(this.address(), value);
        return this;
    }

    public NkStyleKnob active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleKnob border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleKnob.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleKnob border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleKnob knob_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleKnob.nknob_normal(this.address(), value);
        return this;
    }

    public NkStyleKnob knob_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.knob_normal());
        return this;
    }

    public NkStyleKnob knob_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleKnob.nknob_hover(this.address(), value);
        return this;
    }

    public NkStyleKnob knob_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.knob_hover());
        return this;
    }

    public NkStyleKnob knob_active(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleKnob.nknob_active(this.address(), value);
        return this;
    }

    public NkStyleKnob knob_active(Consumer<NkColor> consumer) {
        consumer.accept(this.knob_active());
        return this;
    }

    public NkStyleKnob knob_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleKnob.nknob_border_color(this.address(), value);
        return this;
    }

    public NkStyleKnob knob_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.knob_border_color());
        return this;
    }

    public NkStyleKnob cursor_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleKnob.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleKnob cursor_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_normal());
        return this;
    }

    public NkStyleKnob cursor_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleKnob.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleKnob cursor_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_hover());
        return this;
    }

    public NkStyleKnob cursor_active(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleKnob.ncursor_active(this.address(), value);
        return this;
    }

    public NkStyleKnob cursor_active(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_active());
        return this;
    }

    public NkStyleKnob border(float value) {
        NkStyleKnob.nborder(this.address(), value);
        return this;
    }

    public NkStyleKnob knob_border(float value) {
        NkStyleKnob.nknob_border(this.address(), value);
        return this;
    }

    public NkStyleKnob padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleKnob.npadding(this.address(), value);
        return this;
    }

    public NkStyleKnob padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleKnob spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleKnob.nspacing(this.address(), value);
        return this;
    }

    public NkStyleKnob spacing(Consumer<NkVec2> consumer) {
        consumer.accept(this.spacing());
        return this;
    }

    public NkStyleKnob cursor_width(float value) {
        NkStyleKnob.ncursor_width(this.address(), value);
        return this;
    }

    public NkStyleKnob color_factor(float value) {
        NkStyleKnob.ncolor_factor(this.address(), value);
        return this;
    }

    public NkStyleKnob disabled_factor(float value) {
        NkStyleKnob.ndisabled_factor(this.address(), value);
        return this;
    }

    public NkStyleKnob userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkStyleKnob.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleKnob userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkStyleKnob draw_begin(@NativeType(value="nk_draw_begin") @Nullable NkDrawBeginCallbackI value) {
        NkStyleKnob.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleKnob draw_end(@NativeType(value="nk_draw_end") @Nullable NkDrawEndCallbackI value) {
        NkStyleKnob.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleKnob set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkColor knob_normal, NkColor knob_hover, NkColor knob_active, NkColor knob_border_color, NkColor cursor_normal, NkColor cursor_hover, NkColor cursor_active, float border, float knob_border, NkVec2 padding, NkVec2 spacing, float cursor_width, float color_factor, float disabled_factor, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.knob_normal(knob_normal);
        this.knob_hover(knob_hover);
        this.knob_active(knob_active);
        this.knob_border_color(knob_border_color);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.cursor_active(cursor_active);
        this.border(border);
        this.knob_border(knob_border);
        this.padding(padding);
        this.spacing(spacing);
        this.cursor_width(cursor_width);
        this.color_factor(color_factor);
        this.disabled_factor(disabled_factor);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleKnob set(NkStyleKnob src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleKnob malloc() {
        return new NkStyleKnob(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkStyleKnob calloc() {
        return new NkStyleKnob(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkStyleKnob create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkStyleKnob(MemoryUtil.memAddress(container), container);
    }

    public static NkStyleKnob create(long address) {
        return new NkStyleKnob(address, null);
    }

    public static @Nullable NkStyleKnob createSafe(long address) {
        return address == 0L ? null : new NkStyleKnob(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkStyleKnob.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleKnob.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkStyleKnob malloc(MemoryStack stack) {
        return new NkStyleKnob(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleKnob calloc(MemoryStack stack) {
        return new NkStyleKnob(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor nknob_normal(long struct) {
        return NkColor.create(struct + (long)KNOB_NORMAL);
    }

    public static NkColor nknob_hover(long struct) {
        return NkColor.create(struct + (long)KNOB_HOVER);
    }

    public static NkColor nknob_active(long struct) {
        return NkColor.create(struct + (long)KNOB_ACTIVE);
    }

    public static NkColor nknob_border_color(long struct) {
        return NkColor.create(struct + (long)KNOB_BORDER_COLOR);
    }

    public static NkColor ncursor_normal(long struct) {
        return NkColor.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkColor ncursor_hover(long struct) {
        return NkColor.create(struct + (long)CURSOR_HOVER);
    }

    public static NkColor ncursor_active(long struct) {
        return NkColor.create(struct + (long)CURSOR_ACTIVE);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float nknob_border(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)KNOB_BORDER);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 nspacing(long struct) {
        return NkVec2.create(struct + (long)SPACING);
    }

    public static float ncursor_width(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CURSOR_WIDTH);
    }

    public static float ncolor_factor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)COLOR_FACTOR);
    }

    public static float ndisabled_factor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DISABLED_FACTOR);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static @Nullable NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    public static @Nullable NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nknob_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)KNOB_NORMAL, NkColor.SIZEOF);
    }

    public static void nknob_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)KNOB_HOVER, NkColor.SIZEOF);
    }

    public static void nknob_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)KNOB_ACTIVE, NkColor.SIZEOF);
    }

    public static void nknob_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)KNOB_BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_NORMAL, NkColor.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_HOVER, NkColor.SIZEOF);
    }

    public static void ncursor_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_ACTIVE, NkColor.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void nknob_border(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)KNOB_BORDER, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nspacing(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SPACING, NkVec2.SIZEOF);
    }

    public static void ncursor_width(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CURSOR_WIDTH, value);
    }

    public static void ncolor_factor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)COLOR_FACTOR, value);
    }

    public static void ndisabled_factor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DISABLED_FACTOR, value);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, @Nullable NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, MemoryUtil.memAddressSafe(value));
    }

    public static void ndraw_end(long struct, @Nullable NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleKnob.__struct(NkStyleKnob.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleKnob.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleKnob.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleKnob.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleKnob.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleKnob.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleKnob.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleKnob.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleKnob.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleKnob.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleKnob.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleKnob.__member(4), NkStyleKnob.__member(4), NkStyleKnob.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleKnob.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleKnob.__member(4), NkStyleKnob.__member(4), NkStyleKnob.__member(4), NkStyleKnob.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleKnob.__member(POINTER_SIZE), NkStyleKnob.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        KNOB_NORMAL = layout.offsetof(4);
        KNOB_HOVER = layout.offsetof(5);
        KNOB_ACTIVE = layout.offsetof(6);
        KNOB_BORDER_COLOR = layout.offsetof(7);
        CURSOR_NORMAL = layout.offsetof(8);
        CURSOR_HOVER = layout.offsetof(9);
        CURSOR_ACTIVE = layout.offsetof(10);
        BORDER = layout.offsetof(11);
        KNOB_BORDER = layout.offsetof(12);
        PADDING = layout.offsetof(13);
        SPACING = layout.offsetof(14);
        CURSOR_WIDTH = layout.offsetof(15);
        COLOR_FACTOR = layout.offsetof(16);
        DISABLED_FACTOR = layout.offsetof(17);
        USERDATA = layout.offsetof(18);
        DRAW_BEGIN = layout.offsetof(19);
        DRAW_END = layout.offsetof(20);
    }

    public static class Buffer
    extends StructBuffer<NkStyleKnob, Buffer>
    implements NativeResource {
        private static final NkStyleKnob ELEMENT_FACTORY = NkStyleKnob.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkStyleKnob getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleKnob.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleKnob.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleKnob.nactive(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleKnob.nborder_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor knob_normal() {
            return NkStyleKnob.nknob_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor knob_hover() {
            return NkStyleKnob.nknob_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor knob_active() {
            return NkStyleKnob.nknob_active(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor knob_border_color() {
            return NkStyleKnob.nknob_border_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_normal() {
            return NkStyleKnob.ncursor_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_hover() {
            return NkStyleKnob.ncursor_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_active() {
            return NkStyleKnob.ncursor_active(this.address());
        }

        public float border() {
            return NkStyleKnob.nborder(this.address());
        }

        public float knob_border() {
            return NkStyleKnob.nknob_border(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleKnob.npadding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 spacing() {
            return NkStyleKnob.nspacing(this.address());
        }

        public float cursor_width() {
            return NkStyleKnob.ncursor_width(this.address());
        }

        public float color_factor() {
            return NkStyleKnob.ncolor_factor(this.address());
        }

        public float disabled_factor() {
            return NkStyleKnob.ndisabled_factor(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkStyleKnob.nuserdata(this.address());
        }

        @NativeType(value="nk_draw_begin")
        public @Nullable NkDrawBeginCallback draw_begin() {
            return NkStyleKnob.ndraw_begin(this.address());
        }

        @NativeType(value="nk_draw_end")
        public @Nullable NkDrawEndCallback draw_end() {
            return NkStyleKnob.ndraw_end(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleKnob.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleKnob.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleKnob.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleKnob.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer knob_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleKnob.nknob_normal(this.address(), value);
            return this;
        }

        public Buffer knob_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.knob_normal());
            return this;
        }

        public Buffer knob_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleKnob.nknob_hover(this.address(), value);
            return this;
        }

        public Buffer knob_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.knob_hover());
            return this;
        }

        public Buffer knob_active(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleKnob.nknob_active(this.address(), value);
            return this;
        }

        public Buffer knob_active(Consumer<NkColor> consumer) {
            consumer.accept(this.knob_active());
            return this;
        }

        public Buffer knob_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleKnob.nknob_border_color(this.address(), value);
            return this;
        }

        public Buffer knob_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.knob_border_color());
            return this;
        }

        public Buffer cursor_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleKnob.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_normal());
            return this;
        }

        public Buffer cursor_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleKnob.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_hover());
            return this;
        }

        public Buffer cursor_active(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleKnob.ncursor_active(this.address(), value);
            return this;
        }

        public Buffer cursor_active(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_active());
            return this;
        }

        public Buffer border(float value) {
            NkStyleKnob.nborder(this.address(), value);
            return this;
        }

        public Buffer knob_border(float value) {
            NkStyleKnob.nknob_border(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleKnob.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleKnob.nspacing(this.address(), value);
            return this;
        }

        public Buffer spacing(Consumer<NkVec2> consumer) {
            consumer.accept(this.spacing());
            return this;
        }

        public Buffer cursor_width(float value) {
            NkStyleKnob.ncursor_width(this.address(), value);
            return this;
        }

        public Buffer color_factor(float value) {
            NkStyleKnob.ncolor_factor(this.address(), value);
            return this;
        }

        public Buffer disabled_factor(float value) {
            NkStyleKnob.ndisabled_factor(this.address(), value);
            return this;
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkStyleKnob.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer draw_begin(@NativeType(value="nk_draw_begin") @Nullable NkDrawBeginCallbackI value) {
            NkStyleKnob.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(@NativeType(value="nk_draw_end") @Nullable NkDrawEndCallbackI value) {
            NkStyleKnob.ndraw_end(this.address(), value);
            return this;
        }
    }
}

