/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_toggle")
public class NkStyleToggle
extends Struct<NkStyleToggle>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int TEXT_NORMAL;
    public static final int TEXT_HOVER;
    public static final int TEXT_ACTIVE;
    public static final int TEXT_BACKGROUND;
    public static final int TEXT_ALIGNMENT;
    public static final int PADDING;
    public static final int TOUCH_PADDING;
    public static final int SPACING;
    public static final int BORDER;
    public static final int COLOR_FACTOR;
    public static final int DISABLED_FACTOR;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    protected NkStyleToggle(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkStyleToggle create(long address, @Nullable ByteBuffer container) {
        return new NkStyleToggle(address, container);
    }

    public NkStyleToggle(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkStyleToggle.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleToggle.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleToggle.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleToggle.nactive(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleToggle.nborder_color(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_normal() {
        return NkStyleToggle.ncursor_normal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_hover() {
        return NkStyleToggle.ncursor_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_normal() {
        return NkStyleToggle.ntext_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_hover() {
        return NkStyleToggle.ntext_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_active() {
        return NkStyleToggle.ntext_active(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_background() {
        return NkStyleToggle.ntext_background(this.address());
    }

    @NativeType(value="nk_flags")
    public int text_alignment() {
        return NkStyleToggle.ntext_alignment(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleToggle.npadding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 touch_padding() {
        return NkStyleToggle.ntouch_padding(this.address());
    }

    public float spacing() {
        return NkStyleToggle.nspacing(this.address());
    }

    public float border() {
        return NkStyleToggle.nborder(this.address());
    }

    public float color_factor() {
        return NkStyleToggle.ncolor_factor(this.address());
    }

    public float disabled_factor() {
        return NkStyleToggle.ndisabled_factor(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkStyleToggle.nuserdata(this.address());
    }

    @NativeType(value="nk_draw_begin")
    public @Nullable NkDrawBeginCallback draw_begin() {
        return NkStyleToggle.ndraw_begin(this.address());
    }

    @NativeType(value="nk_draw_end")
    public @Nullable NkDrawEndCallback draw_end() {
        return NkStyleToggle.ndraw_end(this.address());
    }

    public NkStyleToggle normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.nnormal(this.address(), value);
        return this;
    }

    public NkStyleToggle normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleToggle hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.nhover(this.address(), value);
        return this;
    }

    public NkStyleToggle hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleToggle active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.nactive(this.address(), value);
        return this;
    }

    public NkStyleToggle active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleToggle border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleToggle border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleToggle cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleToggle cursor_normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_normal());
        return this;
    }

    public NkStyleToggle cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleToggle cursor_hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_hover());
        return this;
    }

    public NkStyleToggle text_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.ntext_normal(this.address(), value);
        return this;
    }

    public NkStyleToggle text_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.text_normal());
        return this;
    }

    public NkStyleToggle text_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.ntext_hover(this.address(), value);
        return this;
    }

    public NkStyleToggle text_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.text_hover());
        return this;
    }

    public NkStyleToggle text_active(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.ntext_active(this.address(), value);
        return this;
    }

    public NkStyleToggle text_active(Consumer<NkColor> consumer) {
        consumer.accept(this.text_active());
        return this;
    }

    public NkStyleToggle text_background(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.ntext_background(this.address(), value);
        return this;
    }

    public NkStyleToggle text_background(Consumer<NkColor> consumer) {
        consumer.accept(this.text_background());
        return this;
    }

    public NkStyleToggle text_alignment(@NativeType(value="nk_flags") int value) {
        NkStyleToggle.ntext_alignment(this.address(), value);
        return this;
    }

    public NkStyleToggle padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleToggle.npadding(this.address(), value);
        return this;
    }

    public NkStyleToggle padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleToggle touch_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleToggle.ntouch_padding(this.address(), value);
        return this;
    }

    public NkStyleToggle touch_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.touch_padding());
        return this;
    }

    public NkStyleToggle spacing(float value) {
        NkStyleToggle.nspacing(this.address(), value);
        return this;
    }

    public NkStyleToggle border(float value) {
        NkStyleToggle.nborder(this.address(), value);
        return this;
    }

    public NkStyleToggle color_factor(float value) {
        NkStyleToggle.ncolor_factor(this.address(), value);
        return this;
    }

    public NkStyleToggle disabled_factor(float value) {
        NkStyleToggle.ndisabled_factor(this.address(), value);
        return this;
    }

    public NkStyleToggle userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkStyleToggle.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleToggle userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkStyleToggle draw_begin(@NativeType(value="nk_draw_begin") @Nullable NkDrawBeginCallbackI value) {
        NkStyleToggle.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleToggle draw_end(@NativeType(value="nk_draw_end") @Nullable NkDrawEndCallbackI value) {
        NkStyleToggle.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleToggle set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkStyleItem cursor_normal, NkStyleItem cursor_hover, NkColor text_normal, NkColor text_hover, NkColor text_active, NkColor text_background, int text_alignment, NkVec2 padding, NkVec2 touch_padding, float spacing, float border, float color_factor, float disabled_factor, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.text_normal(text_normal);
        this.text_hover(text_hover);
        this.text_active(text_active);
        this.text_background(text_background);
        this.text_alignment(text_alignment);
        this.padding(padding);
        this.touch_padding(touch_padding);
        this.spacing(spacing);
        this.border(border);
        this.color_factor(color_factor);
        this.disabled_factor(disabled_factor);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleToggle set(NkStyleToggle src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleToggle malloc() {
        return new NkStyleToggle(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkStyleToggle calloc() {
        return new NkStyleToggle(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkStyleToggle create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkStyleToggle(MemoryUtil.memAddress(container), container);
    }

    public static NkStyleToggle create(long address) {
        return new NkStyleToggle(address, null);
    }

    public static @Nullable NkStyleToggle createSafe(long address) {
        return address == 0L ? null : new NkStyleToggle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkStyleToggle.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleToggle.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleToggle mallocStack() {
        return NkStyleToggle.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleToggle callocStack() {
        return NkStyleToggle.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleToggle mallocStack(MemoryStack stack) {
        return NkStyleToggle.malloc(stack);
    }

    @Deprecated
    public static NkStyleToggle callocStack(MemoryStack stack) {
        return NkStyleToggle.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleToggle.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleToggle.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleToggle.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleToggle.calloc(capacity, stack);
    }

    public static NkStyleToggle malloc(MemoryStack stack) {
        return new NkStyleToggle(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleToggle calloc(MemoryStack stack) {
        return new NkStyleToggle(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkStyleItem ncursor_normal(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkStyleItem ncursor_hover(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_HOVER);
    }

    public static NkColor ntext_normal(long struct) {
        return NkColor.create(struct + (long)TEXT_NORMAL);
    }

    public static NkColor ntext_hover(long struct) {
        return NkColor.create(struct + (long)TEXT_HOVER);
    }

    public static NkColor ntext_active(long struct) {
        return NkColor.create(struct + (long)TEXT_ACTIVE);
    }

    public static NkColor ntext_background(long struct) {
        return NkColor.create(struct + (long)TEXT_BACKGROUND);
    }

    public static int ntext_alignment(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXT_ALIGNMENT);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 ntouch_padding(long struct) {
        return NkVec2.create(struct + (long)TOUCH_PADDING);
    }

    public static float nspacing(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)SPACING);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float ncolor_factor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)COLOR_FACTOR);
    }

    public static float ndisabled_factor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DISABLED_FACTOR);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static @Nullable NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    public static @Nullable NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_NORMAL, NkStyleItem.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSOR_HOVER, NkStyleItem.SIZEOF);
    }

    public static void ntext_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_NORMAL, NkColor.SIZEOF);
    }

    public static void ntext_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_HOVER, NkColor.SIZEOF);
    }

    public static void ntext_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_ACTIVE, NkColor.SIZEOF);
    }

    public static void ntext_background(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT_BACKGROUND, NkColor.SIZEOF);
    }

    public static void ntext_alignment(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXT_ALIGNMENT, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void ntouch_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TOUCH_PADDING, NkVec2.SIZEOF);
    }

    public static void nspacing(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)SPACING, value);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void ncolor_factor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)COLOR_FACTOR, value);
    }

    public static void ndisabled_factor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DISABLED_FACTOR, value);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, @Nullable NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, MemoryUtil.memAddressSafe(value));
    }

    public static void ndraw_end(long struct, @Nullable NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleToggle.__struct(NkStyleToggle.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleToggle.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleToggle.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleToggle.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleToggle.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleToggle.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleToggle.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleToggle.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleToggle.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleToggle.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleToggle.__member(4), NkStyleToggle.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleToggle.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleToggle.__member(4), NkStyleToggle.__member(4), NkStyleToggle.__member(4), NkStyleToggle.__member(4), NkStyleToggle.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleToggle.__member(POINTER_SIZE), NkStyleToggle.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        CURSOR_NORMAL = layout.offsetof(4);
        CURSOR_HOVER = layout.offsetof(5);
        TEXT_NORMAL = layout.offsetof(6);
        TEXT_HOVER = layout.offsetof(7);
        TEXT_ACTIVE = layout.offsetof(8);
        TEXT_BACKGROUND = layout.offsetof(9);
        TEXT_ALIGNMENT = layout.offsetof(10);
        PADDING = layout.offsetof(11);
        TOUCH_PADDING = layout.offsetof(12);
        SPACING = layout.offsetof(13);
        BORDER = layout.offsetof(14);
        COLOR_FACTOR = layout.offsetof(15);
        DISABLED_FACTOR = layout.offsetof(16);
        USERDATA = layout.offsetof(17);
        DRAW_BEGIN = layout.offsetof(18);
        DRAW_END = layout.offsetof(19);
    }

    public static class Buffer
    extends StructBuffer<NkStyleToggle, Buffer>
    implements NativeResource {
        private static final NkStyleToggle ELEMENT_FACTORY = NkStyleToggle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkStyleToggle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleToggle.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleToggle.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleToggle.nactive(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleToggle.nborder_color(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_normal() {
            return NkStyleToggle.ncursor_normal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_hover() {
            return NkStyleToggle.ncursor_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_normal() {
            return NkStyleToggle.ntext_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_hover() {
            return NkStyleToggle.ntext_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_active() {
            return NkStyleToggle.ntext_active(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_background() {
            return NkStyleToggle.ntext_background(this.address());
        }

        @NativeType(value="nk_flags")
        public int text_alignment() {
            return NkStyleToggle.ntext_alignment(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleToggle.npadding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 touch_padding() {
            return NkStyleToggle.ntouch_padding(this.address());
        }

        public float spacing() {
            return NkStyleToggle.nspacing(this.address());
        }

        public float border() {
            return NkStyleToggle.nborder(this.address());
        }

        public float color_factor() {
            return NkStyleToggle.ncolor_factor(this.address());
        }

        public float disabled_factor() {
            return NkStyleToggle.ndisabled_factor(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkStyleToggle.nuserdata(this.address());
        }

        @NativeType(value="nk_draw_begin")
        public @Nullable NkDrawBeginCallback draw_begin() {
            return NkStyleToggle.ndraw_begin(this.address());
        }

        @NativeType(value="nk_draw_end")
        public @Nullable NkDrawEndCallback draw_end() {
            return NkStyleToggle.ndraw_end(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_normal());
            return this;
        }

        public Buffer cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_hover());
            return this;
        }

        public Buffer text_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.ntext_normal(this.address(), value);
            return this;
        }

        public Buffer text_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.text_normal());
            return this;
        }

        public Buffer text_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.ntext_hover(this.address(), value);
            return this;
        }

        public Buffer text_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.text_hover());
            return this;
        }

        public Buffer text_active(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.ntext_active(this.address(), value);
            return this;
        }

        public Buffer text_active(Consumer<NkColor> consumer) {
            consumer.accept(this.text_active());
            return this;
        }

        public Buffer text_background(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.ntext_background(this.address(), value);
            return this;
        }

        public Buffer text_background(Consumer<NkColor> consumer) {
            consumer.accept(this.text_background());
            return this;
        }

        public Buffer text_alignment(@NativeType(value="nk_flags") int value) {
            NkStyleToggle.ntext_alignment(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleToggle.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer touch_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleToggle.ntouch_padding(this.address(), value);
            return this;
        }

        public Buffer touch_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.touch_padding());
            return this;
        }

        public Buffer spacing(float value) {
            NkStyleToggle.nspacing(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleToggle.nborder(this.address(), value);
            return this;
        }

        public Buffer color_factor(float value) {
            NkStyleToggle.ncolor_factor(this.address(), value);
            return this;
        }

        public Buffer disabled_factor(float value) {
            NkStyleToggle.ndisabled_factor(this.address(), value);
            return this;
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkStyleToggle.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer draw_begin(@NativeType(value="nk_draw_begin") @Nullable NkDrawBeginCallbackI value) {
            NkStyleToggle.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(@NativeType(value="nk_draw_end") @Nullable NkDrawEndCallbackI value) {
            NkStyleToggle.ndraw_end(this.address(), value);
            return this;
        }
    }
}

