/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkStyleWindowHeader;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_window")
public class NkStyleWindow
extends Struct<NkStyleWindow>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int FIXED_BACKGROUND;
    public static final int BACKGROUND;
    public static final int BORDER_COLOR;
    public static final int POPUP_BORDER_COLOR;
    public static final int COMBO_BORDER_COLOR;
    public static final int CONTEXTUAL_BORDER_COLOR;
    public static final int MENU_BORDER_COLOR;
    public static final int GROUP_BORDER_COLOR;
    public static final int TOOLTIP_BORDER_COLOR;
    public static final int SCALER;
    public static final int BORDER;
    public static final int COMBO_BORDER;
    public static final int CONTEXTUAL_BORDER;
    public static final int MENU_BORDER;
    public static final int GROUP_BORDER;
    public static final int TOOLTIP_BORDER;
    public static final int POPUP_BORDER;
    public static final int MIN_ROW_HEIGHT_PADDING;
    public static final int ROUNDING;
    public static final int SPACING;
    public static final int SCROLLBAR_SIZE;
    public static final int MIN_SIZE;
    public static final int PADDING;
    public static final int GROUP_PADDING;
    public static final int POPUP_PADDING;
    public static final int COMBO_PADDING;
    public static final int CONTEXTUAL_PADDING;
    public static final int MENU_PADDING;
    public static final int TOOLTIP_PADDING;

    protected NkStyleWindow(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkStyleWindow create(long address, @Nullable ByteBuffer container) {
        return new NkStyleWindow(address, container);
    }

    public NkStyleWindow(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkStyleWindow.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_window_header")
    public NkStyleWindowHeader header() {
        return NkStyleWindow.nheader(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem fixed_background() {
        return NkStyleWindow.nfixed_background(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor background() {
        return NkStyleWindow.nbackground(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleWindow.nborder_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor popup_border_color() {
        return NkStyleWindow.npopup_border_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor combo_border_color() {
        return NkStyleWindow.ncombo_border_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor contextual_border_color() {
        return NkStyleWindow.ncontextual_border_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor menu_border_color() {
        return NkStyleWindow.nmenu_border_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor group_border_color() {
        return NkStyleWindow.ngroup_border_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor tooltip_border_color() {
        return NkStyleWindow.ntooltip_border_color(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem scaler() {
        return NkStyleWindow.nscaler(this.address());
    }

    public float border() {
        return NkStyleWindow.nborder(this.address());
    }

    public float combo_border() {
        return NkStyleWindow.ncombo_border(this.address());
    }

    public float contextual_border() {
        return NkStyleWindow.ncontextual_border(this.address());
    }

    public float menu_border() {
        return NkStyleWindow.nmenu_border(this.address());
    }

    public float group_border() {
        return NkStyleWindow.ngroup_border(this.address());
    }

    public float tooltip_border() {
        return NkStyleWindow.ntooltip_border(this.address());
    }

    public float popup_border() {
        return NkStyleWindow.npopup_border(this.address());
    }

    public float min_row_height_padding() {
        return NkStyleWindow.nmin_row_height_padding(this.address());
    }

    public float rounding() {
        return NkStyleWindow.nrounding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 spacing() {
        return NkStyleWindow.nspacing(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 scrollbar_size() {
        return NkStyleWindow.nscrollbar_size(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 min_size() {
        return NkStyleWindow.nmin_size(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleWindow.npadding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 group_padding() {
        return NkStyleWindow.ngroup_padding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 popup_padding() {
        return NkStyleWindow.npopup_padding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 combo_padding() {
        return NkStyleWindow.ncombo_padding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 contextual_padding() {
        return NkStyleWindow.ncontextual_padding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 menu_padding() {
        return NkStyleWindow.nmenu_padding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 tooltip_padding() {
        return NkStyleWindow.ntooltip_padding(this.address());
    }

    public NkStyleWindow header(@NativeType(value="struct nk_style_window_header") NkStyleWindowHeader value) {
        NkStyleWindow.nheader(this.address(), value);
        return this;
    }

    public NkStyleWindow header(Consumer<NkStyleWindowHeader> consumer) {
        consumer.accept(this.header());
        return this;
    }

    public NkStyleWindow fixed_background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleWindow.nfixed_background(this.address(), value);
        return this;
    }

    public NkStyleWindow fixed_background(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.fixed_background());
        return this;
    }

    public NkStyleWindow background(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindow.nbackground(this.address(), value);
        return this;
    }

    public NkStyleWindow background(Consumer<NkColor> consumer) {
        consumer.accept(this.background());
        return this;
    }

    public NkStyleWindow border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindow.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleWindow border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleWindow popup_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindow.npopup_border_color(this.address(), value);
        return this;
    }

    public NkStyleWindow popup_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.popup_border_color());
        return this;
    }

    public NkStyleWindow combo_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindow.ncombo_border_color(this.address(), value);
        return this;
    }

    public NkStyleWindow combo_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.combo_border_color());
        return this;
    }

    public NkStyleWindow contextual_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindow.ncontextual_border_color(this.address(), value);
        return this;
    }

    public NkStyleWindow contextual_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.contextual_border_color());
        return this;
    }

    public NkStyleWindow menu_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindow.nmenu_border_color(this.address(), value);
        return this;
    }

    public NkStyleWindow menu_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.menu_border_color());
        return this;
    }

    public NkStyleWindow group_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindow.ngroup_border_color(this.address(), value);
        return this;
    }

    public NkStyleWindow group_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.group_border_color());
        return this;
    }

    public NkStyleWindow tooltip_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleWindow.ntooltip_border_color(this.address(), value);
        return this;
    }

    public NkStyleWindow tooltip_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.tooltip_border_color());
        return this;
    }

    public NkStyleWindow scaler(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleWindow.nscaler(this.address(), value);
        return this;
    }

    public NkStyleWindow scaler(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.scaler());
        return this;
    }

    public NkStyleWindow border(float value) {
        NkStyleWindow.nborder(this.address(), value);
        return this;
    }

    public NkStyleWindow combo_border(float value) {
        NkStyleWindow.ncombo_border(this.address(), value);
        return this;
    }

    public NkStyleWindow contextual_border(float value) {
        NkStyleWindow.ncontextual_border(this.address(), value);
        return this;
    }

    public NkStyleWindow menu_border(float value) {
        NkStyleWindow.nmenu_border(this.address(), value);
        return this;
    }

    public NkStyleWindow group_border(float value) {
        NkStyleWindow.ngroup_border(this.address(), value);
        return this;
    }

    public NkStyleWindow tooltip_border(float value) {
        NkStyleWindow.ntooltip_border(this.address(), value);
        return this;
    }

    public NkStyleWindow popup_border(float value) {
        NkStyleWindow.npopup_border(this.address(), value);
        return this;
    }

    public NkStyleWindow min_row_height_padding(float value) {
        NkStyleWindow.nmin_row_height_padding(this.address(), value);
        return this;
    }

    public NkStyleWindow rounding(float value) {
        NkStyleWindow.nrounding(this.address(), value);
        return this;
    }

    public NkStyleWindow spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.nspacing(this.address(), value);
        return this;
    }

    public NkStyleWindow spacing(Consumer<NkVec2> consumer) {
        consumer.accept(this.spacing());
        return this;
    }

    public NkStyleWindow scrollbar_size(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.nscrollbar_size(this.address(), value);
        return this;
    }

    public NkStyleWindow scrollbar_size(Consumer<NkVec2> consumer) {
        consumer.accept(this.scrollbar_size());
        return this;
    }

    public NkStyleWindow min_size(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.nmin_size(this.address(), value);
        return this;
    }

    public NkStyleWindow min_size(Consumer<NkVec2> consumer) {
        consumer.accept(this.min_size());
        return this;
    }

    public NkStyleWindow padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.npadding(this.address(), value);
        return this;
    }

    public NkStyleWindow padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleWindow group_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.ngroup_padding(this.address(), value);
        return this;
    }

    public NkStyleWindow group_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.group_padding());
        return this;
    }

    public NkStyleWindow popup_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.npopup_padding(this.address(), value);
        return this;
    }

    public NkStyleWindow popup_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.popup_padding());
        return this;
    }

    public NkStyleWindow combo_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.ncombo_padding(this.address(), value);
        return this;
    }

    public NkStyleWindow combo_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.combo_padding());
        return this;
    }

    public NkStyleWindow contextual_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.ncontextual_padding(this.address(), value);
        return this;
    }

    public NkStyleWindow contextual_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.contextual_padding());
        return this;
    }

    public NkStyleWindow menu_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.nmenu_padding(this.address(), value);
        return this;
    }

    public NkStyleWindow menu_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.menu_padding());
        return this;
    }

    public NkStyleWindow tooltip_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleWindow.ntooltip_padding(this.address(), value);
        return this;
    }

    public NkStyleWindow tooltip_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.tooltip_padding());
        return this;
    }

    public NkStyleWindow set(NkStyleWindowHeader header, NkStyleItem fixed_background, NkColor background, NkColor border_color, NkColor popup_border_color, NkColor combo_border_color, NkColor contextual_border_color, NkColor menu_border_color, NkColor group_border_color, NkColor tooltip_border_color, NkStyleItem scaler, float border, float combo_border, float contextual_border, float menu_border, float group_border, float tooltip_border, float popup_border, float min_row_height_padding, float rounding, NkVec2 spacing, NkVec2 scrollbar_size, NkVec2 min_size, NkVec2 padding, NkVec2 group_padding, NkVec2 popup_padding, NkVec2 combo_padding, NkVec2 contextual_padding, NkVec2 menu_padding, NkVec2 tooltip_padding) {
        this.header(header);
        this.fixed_background(fixed_background);
        this.background(background);
        this.border_color(border_color);
        this.popup_border_color(popup_border_color);
        this.combo_border_color(combo_border_color);
        this.contextual_border_color(contextual_border_color);
        this.menu_border_color(menu_border_color);
        this.group_border_color(group_border_color);
        this.tooltip_border_color(tooltip_border_color);
        this.scaler(scaler);
        this.border(border);
        this.combo_border(combo_border);
        this.contextual_border(contextual_border);
        this.menu_border(menu_border);
        this.group_border(group_border);
        this.tooltip_border(tooltip_border);
        this.popup_border(popup_border);
        this.min_row_height_padding(min_row_height_padding);
        this.rounding(rounding);
        this.spacing(spacing);
        this.scrollbar_size(scrollbar_size);
        this.min_size(min_size);
        this.padding(padding);
        this.group_padding(group_padding);
        this.popup_padding(popup_padding);
        this.combo_padding(combo_padding);
        this.contextual_padding(contextual_padding);
        this.menu_padding(menu_padding);
        this.tooltip_padding(tooltip_padding);
        return this;
    }

    public NkStyleWindow set(NkStyleWindow src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleWindow malloc() {
        return new NkStyleWindow(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkStyleWindow calloc() {
        return new NkStyleWindow(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkStyleWindow create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkStyleWindow(MemoryUtil.memAddress(container), container);
    }

    public static NkStyleWindow create(long address) {
        return new NkStyleWindow(address, null);
    }

    public static @Nullable NkStyleWindow createSafe(long address) {
        return address == 0L ? null : new NkStyleWindow(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkStyleWindow.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleWindow.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleWindow mallocStack() {
        return NkStyleWindow.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleWindow callocStack() {
        return NkStyleWindow.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleWindow mallocStack(MemoryStack stack) {
        return NkStyleWindow.malloc(stack);
    }

    @Deprecated
    public static NkStyleWindow callocStack(MemoryStack stack) {
        return NkStyleWindow.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleWindow.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleWindow.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleWindow.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleWindow.calloc(capacity, stack);
    }

    public static NkStyleWindow malloc(MemoryStack stack) {
        return new NkStyleWindow(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleWindow calloc(MemoryStack stack) {
        return new NkStyleWindow(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleWindowHeader nheader(long struct) {
        return NkStyleWindowHeader.create(struct + (long)HEADER);
    }

    public static NkStyleItem nfixed_background(long struct) {
        return NkStyleItem.create(struct + (long)FIXED_BACKGROUND);
    }

    public static NkColor nbackground(long struct) {
        return NkColor.create(struct + (long)BACKGROUND);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor npopup_border_color(long struct) {
        return NkColor.create(struct + (long)POPUP_BORDER_COLOR);
    }

    public static NkColor ncombo_border_color(long struct) {
        return NkColor.create(struct + (long)COMBO_BORDER_COLOR);
    }

    public static NkColor ncontextual_border_color(long struct) {
        return NkColor.create(struct + (long)CONTEXTUAL_BORDER_COLOR);
    }

    public static NkColor nmenu_border_color(long struct) {
        return NkColor.create(struct + (long)MENU_BORDER_COLOR);
    }

    public static NkColor ngroup_border_color(long struct) {
        return NkColor.create(struct + (long)GROUP_BORDER_COLOR);
    }

    public static NkColor ntooltip_border_color(long struct) {
        return NkColor.create(struct + (long)TOOLTIP_BORDER_COLOR);
    }

    public static NkStyleItem nscaler(long struct) {
        return NkStyleItem.create(struct + (long)SCALER);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float ncombo_border(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)COMBO_BORDER);
    }

    public static float ncontextual_border(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CONTEXTUAL_BORDER);
    }

    public static float nmenu_border(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MENU_BORDER);
    }

    public static float ngroup_border(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GROUP_BORDER);
    }

    public static float ntooltip_border(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)TOOLTIP_BORDER);
    }

    public static float npopup_border(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)POPUP_BORDER);
    }

    public static float nmin_row_height_padding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MIN_ROW_HEIGHT_PADDING);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static NkVec2 nspacing(long struct) {
        return NkVec2.create(struct + (long)SPACING);
    }

    public static NkVec2 nscrollbar_size(long struct) {
        return NkVec2.create(struct + (long)SCROLLBAR_SIZE);
    }

    public static NkVec2 nmin_size(long struct) {
        return NkVec2.create(struct + (long)MIN_SIZE);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 ngroup_padding(long struct) {
        return NkVec2.create(struct + (long)GROUP_PADDING);
    }

    public static NkVec2 npopup_padding(long struct) {
        return NkVec2.create(struct + (long)POPUP_PADDING);
    }

    public static NkVec2 ncombo_padding(long struct) {
        return NkVec2.create(struct + (long)COMBO_PADDING);
    }

    public static NkVec2 ncontextual_padding(long struct) {
        return NkVec2.create(struct + (long)CONTEXTUAL_PADDING);
    }

    public static NkVec2 nmenu_padding(long struct) {
        return NkVec2.create(struct + (long)MENU_PADDING);
    }

    public static NkVec2 ntooltip_padding(long struct) {
        return NkVec2.create(struct + (long)TOOLTIP_PADDING);
    }

    public static void nheader(long struct, NkStyleWindowHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, NkStyleWindowHeader.SIZEOF);
    }

    public static void nfixed_background(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FIXED_BACKGROUND, NkStyleItem.SIZEOF);
    }

    public static void nbackground(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BACKGROUND, NkColor.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void npopup_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POPUP_BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ncombo_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COMBO_BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ncontextual_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CONTEXTUAL_BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nmenu_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MENU_BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ngroup_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)GROUP_BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ntooltip_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TOOLTIP_BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nscaler(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCALER, NkStyleItem.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void ncombo_border(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)COMBO_BORDER, value);
    }

    public static void ncontextual_border(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CONTEXTUAL_BORDER, value);
    }

    public static void nmenu_border(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MENU_BORDER, value);
    }

    public static void ngroup_border(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)GROUP_BORDER, value);
    }

    public static void ntooltip_border(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)TOOLTIP_BORDER, value);
    }

    public static void npopup_border(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)POPUP_BORDER, value);
    }

    public static void nmin_row_height_padding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MIN_ROW_HEIGHT_PADDING, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void nspacing(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SPACING, NkVec2.SIZEOF);
    }

    public static void nscrollbar_size(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCROLLBAR_SIZE, NkVec2.SIZEOF);
    }

    public static void nmin_size(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MIN_SIZE, NkVec2.SIZEOF);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void ngroup_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)GROUP_PADDING, NkVec2.SIZEOF);
    }

    public static void npopup_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POPUP_PADDING, NkVec2.SIZEOF);
    }

    public static void ncombo_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COMBO_PADDING, NkVec2.SIZEOF);
    }

    public static void ncontextual_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CONTEXTUAL_PADDING, NkVec2.SIZEOF);
    }

    public static void nmenu_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MENU_PADDING, NkVec2.SIZEOF);
    }

    public static void ntooltip_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TOOLTIP_PADDING, NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleWindow.__struct(NkStyleWindow.__member(NkStyleWindowHeader.SIZEOF, NkStyleWindowHeader.ALIGNOF), NkStyleWindow.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleWindow.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindow.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindow.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindow.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindow.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindow.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindow.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindow.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleWindow.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleWindow.__member(4), NkStyleWindow.__member(4), NkStyleWindow.__member(4), NkStyleWindow.__member(4), NkStyleWindow.__member(4), NkStyleWindow.__member(4), NkStyleWindow.__member(4), NkStyleWindow.__member(4), NkStyleWindow.__member(4), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleWindow.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        FIXED_BACKGROUND = layout.offsetof(1);
        BACKGROUND = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        POPUP_BORDER_COLOR = layout.offsetof(4);
        COMBO_BORDER_COLOR = layout.offsetof(5);
        CONTEXTUAL_BORDER_COLOR = layout.offsetof(6);
        MENU_BORDER_COLOR = layout.offsetof(7);
        GROUP_BORDER_COLOR = layout.offsetof(8);
        TOOLTIP_BORDER_COLOR = layout.offsetof(9);
        SCALER = layout.offsetof(10);
        BORDER = layout.offsetof(11);
        COMBO_BORDER = layout.offsetof(12);
        CONTEXTUAL_BORDER = layout.offsetof(13);
        MENU_BORDER = layout.offsetof(14);
        GROUP_BORDER = layout.offsetof(15);
        TOOLTIP_BORDER = layout.offsetof(16);
        POPUP_BORDER = layout.offsetof(17);
        MIN_ROW_HEIGHT_PADDING = layout.offsetof(18);
        ROUNDING = layout.offsetof(19);
        SPACING = layout.offsetof(20);
        SCROLLBAR_SIZE = layout.offsetof(21);
        MIN_SIZE = layout.offsetof(22);
        PADDING = layout.offsetof(23);
        GROUP_PADDING = layout.offsetof(24);
        POPUP_PADDING = layout.offsetof(25);
        COMBO_PADDING = layout.offsetof(26);
        CONTEXTUAL_PADDING = layout.offsetof(27);
        MENU_PADDING = layout.offsetof(28);
        TOOLTIP_PADDING = layout.offsetof(29);
    }

    public static class Buffer
    extends StructBuffer<NkStyleWindow, Buffer>
    implements NativeResource {
        private static final NkStyleWindow ELEMENT_FACTORY = NkStyleWindow.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkStyleWindow getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_window_header")
        public NkStyleWindowHeader header() {
            return NkStyleWindow.nheader(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem fixed_background() {
            return NkStyleWindow.nfixed_background(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor background() {
            return NkStyleWindow.nbackground(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleWindow.nborder_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor popup_border_color() {
            return NkStyleWindow.npopup_border_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor combo_border_color() {
            return NkStyleWindow.ncombo_border_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor contextual_border_color() {
            return NkStyleWindow.ncontextual_border_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor menu_border_color() {
            return NkStyleWindow.nmenu_border_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor group_border_color() {
            return NkStyleWindow.ngroup_border_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor tooltip_border_color() {
            return NkStyleWindow.ntooltip_border_color(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem scaler() {
            return NkStyleWindow.nscaler(this.address());
        }

        public float border() {
            return NkStyleWindow.nborder(this.address());
        }

        public float combo_border() {
            return NkStyleWindow.ncombo_border(this.address());
        }

        public float contextual_border() {
            return NkStyleWindow.ncontextual_border(this.address());
        }

        public float menu_border() {
            return NkStyleWindow.nmenu_border(this.address());
        }

        public float group_border() {
            return NkStyleWindow.ngroup_border(this.address());
        }

        public float tooltip_border() {
            return NkStyleWindow.ntooltip_border(this.address());
        }

        public float popup_border() {
            return NkStyleWindow.npopup_border(this.address());
        }

        public float min_row_height_padding() {
            return NkStyleWindow.nmin_row_height_padding(this.address());
        }

        public float rounding() {
            return NkStyleWindow.nrounding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 spacing() {
            return NkStyleWindow.nspacing(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 scrollbar_size() {
            return NkStyleWindow.nscrollbar_size(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 min_size() {
            return NkStyleWindow.nmin_size(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleWindow.npadding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 group_padding() {
            return NkStyleWindow.ngroup_padding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 popup_padding() {
            return NkStyleWindow.npopup_padding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 combo_padding() {
            return NkStyleWindow.ncombo_padding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 contextual_padding() {
            return NkStyleWindow.ncontextual_padding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 menu_padding() {
            return NkStyleWindow.nmenu_padding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 tooltip_padding() {
            return NkStyleWindow.ntooltip_padding(this.address());
        }

        public Buffer header(@NativeType(value="struct nk_style_window_header") NkStyleWindowHeader value) {
            NkStyleWindow.nheader(this.address(), value);
            return this;
        }

        public Buffer header(Consumer<NkStyleWindowHeader> consumer) {
            consumer.accept(this.header());
            return this;
        }

        public Buffer fixed_background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleWindow.nfixed_background(this.address(), value);
            return this;
        }

        public Buffer fixed_background(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.fixed_background());
            return this;
        }

        public Buffer background(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindow.nbackground(this.address(), value);
            return this;
        }

        public Buffer background(Consumer<NkColor> consumer) {
            consumer.accept(this.background());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindow.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer popup_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindow.npopup_border_color(this.address(), value);
            return this;
        }

        public Buffer popup_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.popup_border_color());
            return this;
        }

        public Buffer combo_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindow.ncombo_border_color(this.address(), value);
            return this;
        }

        public Buffer combo_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.combo_border_color());
            return this;
        }

        public Buffer contextual_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindow.ncontextual_border_color(this.address(), value);
            return this;
        }

        public Buffer contextual_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.contextual_border_color());
            return this;
        }

        public Buffer menu_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindow.nmenu_border_color(this.address(), value);
            return this;
        }

        public Buffer menu_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.menu_border_color());
            return this;
        }

        public Buffer group_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindow.ngroup_border_color(this.address(), value);
            return this;
        }

        public Buffer group_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.group_border_color());
            return this;
        }

        public Buffer tooltip_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleWindow.ntooltip_border_color(this.address(), value);
            return this;
        }

        public Buffer tooltip_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.tooltip_border_color());
            return this;
        }

        public Buffer scaler(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleWindow.nscaler(this.address(), value);
            return this;
        }

        public Buffer scaler(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.scaler());
            return this;
        }

        public Buffer border(float value) {
            NkStyleWindow.nborder(this.address(), value);
            return this;
        }

        public Buffer combo_border(float value) {
            NkStyleWindow.ncombo_border(this.address(), value);
            return this;
        }

        public Buffer contextual_border(float value) {
            NkStyleWindow.ncontextual_border(this.address(), value);
            return this;
        }

        public Buffer menu_border(float value) {
            NkStyleWindow.nmenu_border(this.address(), value);
            return this;
        }

        public Buffer group_border(float value) {
            NkStyleWindow.ngroup_border(this.address(), value);
            return this;
        }

        public Buffer tooltip_border(float value) {
            NkStyleWindow.ntooltip_border(this.address(), value);
            return this;
        }

        public Buffer popup_border(float value) {
            NkStyleWindow.npopup_border(this.address(), value);
            return this;
        }

        public Buffer min_row_height_padding(float value) {
            NkStyleWindow.nmin_row_height_padding(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleWindow.nrounding(this.address(), value);
            return this;
        }

        public Buffer spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.nspacing(this.address(), value);
            return this;
        }

        public Buffer spacing(Consumer<NkVec2> consumer) {
            consumer.accept(this.spacing());
            return this;
        }

        public Buffer scrollbar_size(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.nscrollbar_size(this.address(), value);
            return this;
        }

        public Buffer scrollbar_size(Consumer<NkVec2> consumer) {
            consumer.accept(this.scrollbar_size());
            return this;
        }

        public Buffer min_size(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.nmin_size(this.address(), value);
            return this;
        }

        public Buffer min_size(Consumer<NkVec2> consumer) {
            consumer.accept(this.min_size());
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer group_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.ngroup_padding(this.address(), value);
            return this;
        }

        public Buffer group_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.group_padding());
            return this;
        }

        public Buffer popup_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.npopup_padding(this.address(), value);
            return this;
        }

        public Buffer popup_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.popup_padding());
            return this;
        }

        public Buffer combo_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.ncombo_padding(this.address(), value);
            return this;
        }

        public Buffer combo_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.combo_padding());
            return this;
        }

        public Buffer contextual_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.ncontextual_padding(this.address(), value);
            return this;
        }

        public Buffer contextual_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.contextual_padding());
            return this;
        }

        public Buffer menu_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.nmenu_padding(this.address(), value);
            return this;
        }

        public Buffer menu_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.menu_padding());
            return this;
        }

        public Buffer tooltip_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleWindow.ntooltip_padding(this.address(), value);
            return this;
        }

        public Buffer tooltip_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.tooltip_padding());
            return this;
        }
    }
}

