/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkQueryFontGlyphCallback;
import org.lwjgl.nuklear.NkQueryFontGlyphCallbackI;
import org.lwjgl.nuklear.NkTextWidthCallback;
import org.lwjgl.nuklear.NkTextWidthCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_user_font")
public class NkUserFont
extends Struct<NkUserFont>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USERDATA;
    public static final int HEIGHT;
    public static final int WIDTH;
    public static final int QUERY;
    public static final int TEXTURE;

    protected NkUserFont(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkUserFont create(long address, @Nullable ByteBuffer container) {
        return new NkUserFont(address, container);
    }

    public NkUserFont(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkUserFont.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkUserFont.nuserdata(this.address());
    }

    public float height() {
        return NkUserFont.nheight(this.address());
    }

    @NativeType(value="nk_text_width_f")
    public @Nullable NkTextWidthCallback width() {
        return NkUserFont.nwidth(this.address());
    }

    @NativeType(value="nk_query_font_glyph_f")
    public @Nullable NkQueryFontGlyphCallback query() {
        return NkUserFont.nquery(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle texture() {
        return NkUserFont.ntexture(this.address());
    }

    public NkUserFont userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkUserFont.nuserdata(this.address(), value);
        return this;
    }

    public NkUserFont userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkUserFont height(float value) {
        NkUserFont.nheight(this.address(), value);
        return this;
    }

    public NkUserFont width(@NativeType(value="nk_text_width_f") @Nullable NkTextWidthCallbackI value) {
        NkUserFont.nwidth(this.address(), value);
        return this;
    }

    public NkUserFont query(@NativeType(value="nk_query_font_glyph_f") @Nullable NkQueryFontGlyphCallbackI value) {
        NkUserFont.nquery(this.address(), value);
        return this;
    }

    public NkUserFont texture(@NativeType(value="nk_handle") NkHandle value) {
        NkUserFont.ntexture(this.address(), value);
        return this;
    }

    public NkUserFont texture(Consumer<NkHandle> consumer) {
        consumer.accept(this.texture());
        return this;
    }

    public NkUserFont set(NkHandle userdata, float height, NkTextWidthCallbackI width, NkQueryFontGlyphCallbackI query, NkHandle texture) {
        this.userdata(userdata);
        this.height(height);
        this.width(width);
        this.query(query);
        this.texture(texture);
        return this;
    }

    public NkUserFont set(NkUserFont src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkUserFont malloc() {
        return new NkUserFont(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkUserFont calloc() {
        return new NkUserFont(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkUserFont create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkUserFont(MemoryUtil.memAddress(container), container);
    }

    public static NkUserFont create(long address) {
        return new NkUserFont(address, null);
    }

    public static @Nullable NkUserFont createSafe(long address) {
        return address == 0L ? null : new NkUserFont(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkUserFont.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkUserFont.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkUserFont mallocStack() {
        return NkUserFont.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkUserFont callocStack() {
        return NkUserFont.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkUserFont mallocStack(MemoryStack stack) {
        return NkUserFont.malloc(stack);
    }

    @Deprecated
    public static NkUserFont callocStack(MemoryStack stack) {
        return NkUserFont.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkUserFont.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkUserFont.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkUserFont.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkUserFont.calloc(capacity, stack);
    }

    public static NkUserFont malloc(MemoryStack stack) {
        return new NkUserFont(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkUserFont calloc(MemoryStack stack) {
        return new NkUserFont(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEIGHT);
    }

    public static @Nullable NkTextWidthCallback nwidth(long struct) {
        return NkTextWidthCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)WIDTH));
    }

    public static @Nullable NkQueryFontGlyphCallback nquery(long struct) {
        return NkQueryFontGlyphCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)QUERY));
    }

    public static NkHandle ntexture(long struct) {
        return NkHandle.create(struct + (long)TEXTURE);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HEIGHT, value);
    }

    public static void nwidth(long struct, @Nullable NkTextWidthCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)WIDTH, MemoryUtil.memAddressSafe(value));
    }

    public static void nquery(long struct, @Nullable NkQueryFontGlyphCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)QUERY, MemoryUtil.memAddressSafe(value));
    }

    public static void ntexture(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXTURE, NkHandle.SIZEOF);
    }

    static {
        Struct.Layout layout = NkUserFont.__struct(NkUserFont.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkUserFont.__member(4), NkUserFont.__member(POINTER_SIZE), NkUserFont.__member(POINTER_SIZE), NkUserFont.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USERDATA = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        QUERY = layout.offsetof(3);
        TEXTURE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NkUserFont, Buffer>
    implements NativeResource {
        private static final NkUserFont ELEMENT_FACTORY = NkUserFont.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkUserFont getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkUserFont.nuserdata(this.address());
        }

        public float height() {
            return NkUserFont.nheight(this.address());
        }

        @NativeType(value="nk_text_width_f")
        public @Nullable NkTextWidthCallback width() {
            return NkUserFont.nwidth(this.address());
        }

        @NativeType(value="nk_query_font_glyph_f")
        public @Nullable NkQueryFontGlyphCallback query() {
            return NkUserFont.nquery(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle texture() {
            return NkUserFont.ntexture(this.address());
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkUserFont.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer height(float value) {
            NkUserFont.nheight(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="nk_text_width_f") @Nullable NkTextWidthCallbackI value) {
            NkUserFont.nwidth(this.address(), value);
            return this;
        }

        public Buffer query(@NativeType(value="nk_query_font_glyph_f") @Nullable NkQueryFontGlyphCallbackI value) {
            NkUserFont.nquery(this.address(), value);
            return this;
        }

        public Buffer texture(@NativeType(value="nk_handle") NkHandle value) {
            NkUserFont.ntexture(this.address(), value);
            return this;
        }

        public Buffer texture(Consumer<NkHandle> consumer) {
            consumer.accept(this.texture());
            return this;
        }
    }
}

