/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputPoseActionData_t")
public class InputPoseActionData
extends Struct<InputPoseActionData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;
    public static final int POSE;

    protected InputPoseActionData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected InputPoseActionData create(long address, @Nullable ByteBuffer container) {
        return new InputPoseActionData(address, container);
    }

    public InputPoseActionData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), InputPoseActionData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputPoseActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputPoseActionData.nactiveOrigin(this.address());
    }

    @NativeType(value="TrackedDevicePose_t")
    public TrackedDevicePose pose() {
        return InputPoseActionData.npose(this.address());
    }

    public static InputPoseActionData malloc() {
        return new InputPoseActionData(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static InputPoseActionData calloc() {
        return new InputPoseActionData(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static InputPoseActionData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new InputPoseActionData(MemoryUtil.memAddress(container), container);
    }

    public static InputPoseActionData create(long address) {
        return new InputPoseActionData(address, null);
    }

    public static @Nullable InputPoseActionData createSafe(long address) {
        return address == 0L ? null : new InputPoseActionData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(InputPoseActionData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputPoseActionData.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static InputPoseActionData mallocStack() {
        return InputPoseActionData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputPoseActionData callocStack() {
        return InputPoseActionData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputPoseActionData mallocStack(MemoryStack stack) {
        return InputPoseActionData.malloc(stack);
    }

    @Deprecated
    public static InputPoseActionData callocStack(MemoryStack stack) {
        return InputPoseActionData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputPoseActionData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputPoseActionData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputPoseActionData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputPoseActionData.calloc(capacity, stack);
    }

    public static InputPoseActionData malloc(MemoryStack stack) {
        return new InputPoseActionData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static InputPoseActionData calloc(MemoryStack stack) {
        return new InputPoseActionData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbActive(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BACTIVE) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ACTIVEORIGIN);
    }

    public static TrackedDevicePose npose(long struct) {
        return TrackedDevicePose.create(struct + (long)POSE);
    }

    static {
        Struct.Layout layout = InputPoseActionData.__struct(InputPoseActionData.__member(1), InputPoseActionData.__member(8), InputPoseActionData.__member(TrackedDevicePose.SIZEOF, TrackedDevicePose.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
        POSE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<InputPoseActionData, Buffer>
    implements NativeResource {
        private static final InputPoseActionData ELEMENT_FACTORY = InputPoseActionData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected InputPoseActionData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputPoseActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputPoseActionData.nactiveOrigin(this.address());
        }

        @NativeType(value="TrackedDevicePose_t")
        public TrackedDevicePose pose() {
            return InputPoseActionData.npose(this.address());
        }
    }
}

