/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct PathWrite_t")
public class PathWrite
extends Struct<PathWrite>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ULPATH;
    public static final int WRITETYPE;
    public static final int ESETERROR;
    public static final int PVBUFFER;
    public static final int UNBUFFERSIZE;
    public static final int UNTAG;
    public static final int EERROR;
    public static final int PSZPATH;

    protected PathWrite(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected PathWrite create(long address, @Nullable ByteBuffer container) {
        return new PathWrite(address, container);
    }

    public PathWrite(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), PathWrite.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="PathHandle_t")
    public long ulPath() {
        return PathWrite.nulPath(this.address());
    }

    @NativeType(value="EPropertyWriteType")
    public int writeType() {
        return PathWrite.nwriteType(this.address());
    }

    @NativeType(value="ETrackedPropertyError")
    public int eSetError() {
        return PathWrite.neSetError(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer pvBuffer() {
        return PathWrite.npvBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int unBufferSize() {
        return PathWrite.nunBufferSize(this.address());
    }

    @NativeType(value="PropertyTypeTag_t")
    public int unTag() {
        return PathWrite.nunTag(this.address());
    }

    @NativeType(value="ETrackedPropertyError")
    public int eError() {
        return PathWrite.neError(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer pszPath() {
        return PathWrite.npszPath(this.address());
    }

    @NativeType(value="char *")
    public String pszPathString() {
        return PathWrite.npszPathString(this.address());
    }

    public PathWrite ulPath(@NativeType(value="PathHandle_t") long value) {
        PathWrite.nulPath(this.address(), value);
        return this;
    }

    public PathWrite writeType(@NativeType(value="EPropertyWriteType") int value) {
        PathWrite.nwriteType(this.address(), value);
        return this;
    }

    public PathWrite eSetError(@NativeType(value="ETrackedPropertyError") int value) {
        PathWrite.neSetError(this.address(), value);
        return this;
    }

    public PathWrite pvBuffer(@NativeType(value="void *") ByteBuffer value) {
        PathWrite.npvBuffer(this.address(), value);
        return this;
    }

    public PathWrite unTag(@NativeType(value="PropertyTypeTag_t") int value) {
        PathWrite.nunTag(this.address(), value);
        return this;
    }

    public PathWrite eError(@NativeType(value="ETrackedPropertyError") int value) {
        PathWrite.neError(this.address(), value);
        return this;
    }

    public PathWrite pszPath(@NativeType(value="char *") ByteBuffer value) {
        PathWrite.npszPath(this.address(), value);
        return this;
    }

    public PathWrite set(long ulPath, int writeType, int eSetError, ByteBuffer pvBuffer, int unTag, int eError, ByteBuffer pszPath) {
        this.ulPath(ulPath);
        this.writeType(writeType);
        this.eSetError(eSetError);
        this.pvBuffer(pvBuffer);
        this.unTag(unTag);
        this.eError(eError);
        this.pszPath(pszPath);
        return this;
    }

    public PathWrite set(PathWrite src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static PathWrite malloc() {
        return new PathWrite(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static PathWrite calloc() {
        return new PathWrite(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static PathWrite create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new PathWrite(MemoryUtil.memAddress(container), container);
    }

    public static PathWrite create(long address) {
        return new PathWrite(address, null);
    }

    public static @Nullable PathWrite createSafe(long address) {
        return address == 0L ? null : new PathWrite(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(PathWrite.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = PathWrite.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static PathWrite malloc(MemoryStack stack) {
        return new PathWrite(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static PathWrite calloc(MemoryStack stack) {
        return new PathWrite(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nulPath(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ULPATH);
    }

    public static int nwriteType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WRITETYPE);
    }

    public static int neSetError(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ESETERROR);
    }

    public static ByteBuffer npvBuffer(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PVBUFFER), PathWrite.nunBufferSize(struct));
    }

    public static int nunBufferSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNBUFFERSIZE);
    }

    public static int nunTag(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNTAG);
    }

    public static int neError(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EERROR);
    }

    public static ByteBuffer npszPath(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PSZPATH));
    }

    public static String npszPathString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)PSZPATH));
    }

    public static void nulPath(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)ULPATH, value);
    }

    public static void nwriteType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WRITETYPE, value);
    }

    public static void neSetError(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ESETERROR, value);
    }

    public static void npvBuffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVBUFFER, MemoryUtil.memAddress(value));
        PathWrite.nunBufferSize(struct, value.remaining());
    }

    public static void nunBufferSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNBUFFERSIZE, value);
    }

    public static void nunTag(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNTAG, value);
    }

    public static void neError(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)EERROR, value);
    }

    public static void npszPath(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PSZPATH, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PVBUFFER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSZPATH));
    }

    static {
        Struct.Layout layout = PathWrite.__struct(PathWrite.__member(8), PathWrite.__member(4), PathWrite.__member(4), PathWrite.__member(POINTER_SIZE), PathWrite.__member(4), PathWrite.__member(4), PathWrite.__member(4), PathWrite.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ULPATH = layout.offsetof(0);
        WRITETYPE = layout.offsetof(1);
        ESETERROR = layout.offsetof(2);
        PVBUFFER = layout.offsetof(3);
        UNBUFFERSIZE = layout.offsetof(4);
        UNTAG = layout.offsetof(5);
        EERROR = layout.offsetof(6);
        PSZPATH = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<PathWrite, Buffer>
    implements NativeResource {
        private static final PathWrite ELEMENT_FACTORY = PathWrite.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected PathWrite getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="PathHandle_t")
        public long ulPath() {
            return PathWrite.nulPath(this.address());
        }

        @NativeType(value="EPropertyWriteType")
        public int writeType() {
            return PathWrite.nwriteType(this.address());
        }

        @NativeType(value="ETrackedPropertyError")
        public int eSetError() {
            return PathWrite.neSetError(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer pvBuffer() {
            return PathWrite.npvBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int unBufferSize() {
            return PathWrite.nunBufferSize(this.address());
        }

        @NativeType(value="PropertyTypeTag_t")
        public int unTag() {
            return PathWrite.nunTag(this.address());
        }

        @NativeType(value="ETrackedPropertyError")
        public int eError() {
            return PathWrite.neError(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer pszPath() {
            return PathWrite.npszPath(this.address());
        }

        @NativeType(value="char *")
        public String pszPathString() {
            return PathWrite.npszPathString(this.address());
        }

        public Buffer ulPath(@NativeType(value="PathHandle_t") long value) {
            PathWrite.nulPath(this.address(), value);
            return this;
        }

        public Buffer writeType(@NativeType(value="EPropertyWriteType") int value) {
            PathWrite.nwriteType(this.address(), value);
            return this;
        }

        public Buffer eSetError(@NativeType(value="ETrackedPropertyError") int value) {
            PathWrite.neSetError(this.address(), value);
            return this;
        }

        public Buffer pvBuffer(@NativeType(value="void *") ByteBuffer value) {
            PathWrite.npvBuffer(this.address(), value);
            return this;
        }

        public Buffer unTag(@NativeType(value="PropertyTypeTag_t") int value) {
            PathWrite.nunTag(this.address(), value);
            return this;
        }

        public Buffer eError(@NativeType(value="ETrackedPropertyError") int value) {
            PathWrite.neError(this.address(), value);
            return this;
        }

        public Buffer pszPath(@NativeType(value="char *") ByteBuffer value) {
            PathWrite.npszPath(this.address(), value);
            return this;
        }
    }
}

