/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRBlockQueue {
    protected VRBlockQueue() {
        throw new UnsupportedOperationException();
    }

    public static int nVRBlockQueue_Create(long pulQueueHandle, long pchPath, int unBlockDataSize, int unBlockHeaderSize, int unBlockCount, int unFlags) {
        long __functionAddress = OpenVR.VRBlockQueue.Create;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(pulQueueHandle, pchPath, unBlockDataSize, unBlockHeaderSize, unBlockCount, unFlags, __functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_Create(@NativeType(value="PropertyContainerHandle_t *") LongBuffer pulQueueHandle, @NativeType(value="char *") @Nullable ByteBuffer pchPath, @NativeType(value="uint32_t") int unBlockDataSize, @NativeType(value="uint32_t") int unBlockHeaderSize, @NativeType(value="uint32_t") int unBlockCount, @NativeType(value="uint32_t") int unFlags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulQueueHandle, 1);
            Checks.checkNT1Safe(pchPath);
        }
        return VRBlockQueue.nVRBlockQueue_Create(MemoryUtil.memAddress(pulQueueHandle), MemoryUtil.memAddressSafe(pchPath), unBlockDataSize, unBlockHeaderSize, unBlockCount, unFlags);
    }

    public static int nVRBlockQueue_Connect(long pulQueueHandle, long pchPath) {
        long __functionAddress = OpenVR.VRBlockQueue.Connect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(pulQueueHandle, pchPath, __functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_Connect(@NativeType(value="PropertyContainerHandle_t *") LongBuffer pulQueueHandle, @NativeType(value="char *") @Nullable ByteBuffer pchPath) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulQueueHandle, 1);
            Checks.checkNT1Safe(pchPath);
        }
        return VRBlockQueue.nVRBlockQueue_Connect(MemoryUtil.memAddress(pulQueueHandle), MemoryUtil.memAddressSafe(pchPath));
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_Destroy(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle) {
        long __functionAddress = OpenVR.VRBlockQueue.Destroy;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(ulQueueHandle, __functionAddress);
    }

    public static int nVRBlockQueue_AcquireWriteOnlyBlock(long ulQueueHandle, long pulBlockHandle, long ppvBuffer) {
        long __functionAddress = OpenVR.VRBlockQueue.AcquireWriteOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(ulQueueHandle, pulBlockHandle, ppvBuffer, __functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_AcquireWriteOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t *") LongBuffer pulBlockHandle, @NativeType(value="void **") PointerBuffer ppvBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulBlockHandle, 1);
            Checks.check(ppvBuffer, 1);
        }
        return VRBlockQueue.nVRBlockQueue_AcquireWriteOnlyBlock(ulQueueHandle, MemoryUtil.memAddress(pulBlockHandle), MemoryUtil.memAddress(ppvBuffer));
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_ReleaseWriteOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t") long ulBlockHandle) {
        long __functionAddress = OpenVR.VRBlockQueue.ReleaseWriteOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJJI(ulQueueHandle, ulBlockHandle, __functionAddress);
    }

    public static int nVRBlockQueue_WaitAndAcquireReadOnlyBlock(long ulQueueHandle, long pulBlockHandle, long ppvBuffer, int eReadType, int unTimeoutMs) {
        long __functionAddress = OpenVR.VRBlockQueue.WaitAndAcquireReadOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(ulQueueHandle, pulBlockHandle, ppvBuffer, eReadType, unTimeoutMs, __functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_WaitAndAcquireReadOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t *") LongBuffer pulBlockHandle, @NativeType(value="void **") PointerBuffer ppvBuffer, @NativeType(value="EBlockQueueReadType") int eReadType, @NativeType(value="uint32_t") int unTimeoutMs) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulBlockHandle, 1);
            Checks.check(ppvBuffer, 1);
        }
        return VRBlockQueue.nVRBlockQueue_WaitAndAcquireReadOnlyBlock(ulQueueHandle, MemoryUtil.memAddress(pulBlockHandle), MemoryUtil.memAddress(ppvBuffer), eReadType, unTimeoutMs);
    }

    public static int nVRBlockQueue_AcquireReadOnlyBlock(long ulQueueHandle, long pulBlockHandle, long ppvBuffer, int eReadType) {
        long __functionAddress = OpenVR.VRBlockQueue.AcquireReadOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(ulQueueHandle, pulBlockHandle, ppvBuffer, eReadType, __functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_AcquireReadOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t *") LongBuffer pulBlockHandle, @NativeType(value="void **") PointerBuffer ppvBuffer, @NativeType(value="EBlockQueueReadType") int eReadType) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulBlockHandle, 1);
            Checks.check(ppvBuffer, 1);
        }
        return VRBlockQueue.nVRBlockQueue_AcquireReadOnlyBlock(ulQueueHandle, MemoryUtil.memAddress(pulBlockHandle), MemoryUtil.memAddress(ppvBuffer), eReadType);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_ReleaseReadOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t") long ulBlockHandle) {
        long __functionAddress = OpenVR.VRBlockQueue.ReleaseReadOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJJI(ulQueueHandle, ulBlockHandle, __functionAddress);
    }

    public static int nVRBlockQueue_QueueHasReader(long ulQueueHandle, long pbHasReaders) {
        long __functionAddress = OpenVR.VRBlockQueue.QueueHasReader;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(ulQueueHandle, pbHasReaders, __functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_QueueHasReader(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="bool *") ByteBuffer pbHasReaders) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pbHasReaders, 1);
        }
        return VRBlockQueue.nVRBlockQueue_QueueHasReader(ulQueueHandle, MemoryUtil.memAddress(pbHasReaders));
    }
}

