/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdQuad;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRChaperoneSetup {
    protected VRChaperoneSetup() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_CommitWorkingCopy(@NativeType(value="EChaperoneConfigFile") int configFile) {
        long __functionAddress = OpenVR.VRChaperoneSetup.CommitWorkingCopy;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(configFile, __functionAddress);
    }

    public static void VRChaperoneSetup_RevertWorkingCopy() {
        long __functionAddress = OpenVR.VRChaperoneSetup.RevertWorkingCopy;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static boolean nVRChaperoneSetup_GetWorkingPlayAreaSize(long pSizeX, long pSizeZ) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingPlayAreaSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(pSizeX, pSizeZ, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_GetWorkingPlayAreaSize(@NativeType(value="float *") FloatBuffer pSizeX, @NativeType(value="float *") FloatBuffer pSizeZ) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSizeX, 1);
            Checks.check((Buffer)pSizeZ, 1);
        }
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingPlayAreaSize(MemoryUtil.memAddress(pSizeX), MemoryUtil.memAddress(pSizeZ));
    }

    public static boolean nVRChaperoneSetup_GetWorkingPlayAreaRect(long rect) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingPlayAreaRect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(rect, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_GetWorkingPlayAreaRect(@NativeType(value="HmdQuad_t *") HmdQuad rect) {
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingPlayAreaRect(rect.address());
    }

    public static boolean nVRChaperoneSetup_GetWorkingCollisionBoundsInfo(long pQuadsBuffer, long punQuadsCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingCollisionBoundsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(pQuadsBuffer, punQuadsCount, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_GetWorkingCollisionBoundsInfo(@NativeType(value="HmdQuad_t *") @Nullable HmdQuad.Buffer pQuadsBuffer, @NativeType(value="uint32_t *") IntBuffer punQuadsCount) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punQuadsCount, 1);
            Checks.checkSafe(pQuadsBuffer, punQuadsCount.get(punQuadsCount.position()));
        }
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingCollisionBoundsInfo(MemoryUtil.memAddressSafe(pQuadsBuffer), MemoryUtil.memAddress(punQuadsCount));
    }

    public static boolean nVRChaperoneSetup_GetLiveCollisionBoundsInfo(long pQuadsBuffer, long punQuadsCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetLiveCollisionBoundsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(pQuadsBuffer, punQuadsCount, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_GetLiveCollisionBoundsInfo(@NativeType(value="HmdQuad_t *") @Nullable HmdQuad.Buffer pQuadsBuffer, @NativeType(value="uint32_t *") IntBuffer punQuadsCount) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punQuadsCount, 1);
            Checks.checkSafe(pQuadsBuffer, punQuadsCount.get(punQuadsCount.position()));
        }
        return VRChaperoneSetup.nVRChaperoneSetup_GetLiveCollisionBoundsInfo(MemoryUtil.memAddressSafe(pQuadsBuffer), MemoryUtil.memAddress(punQuadsCount));
    }

    public static boolean nVRChaperoneSetup_GetWorkingSeatedZeroPoseToRawTrackingPose(long pmatSeatedZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingSeatedZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(pmatSeatedZeroPoseToRawTrackingPose, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_GetWorkingSeatedZeroPoseToRawTrackingPose(@NativeType(value="HmdMatrix34_t *") HmdMatrix34 pmatSeatedZeroPoseToRawTrackingPose) {
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingSeatedZeroPoseToRawTrackingPose(pmatSeatedZeroPoseToRawTrackingPose.address());
    }

    public static boolean nVRChaperoneSetup_GetWorkingStandingZeroPoseToRawTrackingPose(long pmatStandingZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingStandingZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(pmatStandingZeroPoseToRawTrackingPose, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_GetWorkingStandingZeroPoseToRawTrackingPose(@NativeType(value="HmdMatrix34_t *") HmdMatrix34 pmatStandingZeroPoseToRawTrackingPose) {
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingStandingZeroPoseToRawTrackingPose(pmatStandingZeroPoseToRawTrackingPose.address());
    }

    public static void VRChaperoneSetup_SetWorkingPlayAreaSize(float sizeX, float sizeZ) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingPlayAreaSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(sizeX, sizeZ, __functionAddress);
    }

    public static void nVRChaperoneSetup_SetWorkingCollisionBoundsInfo(long pQuadsBuffer, int unQuadsCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingCollisionBoundsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(pQuadsBuffer, unQuadsCount, __functionAddress);
    }

    public static void VRChaperoneSetup_SetWorkingCollisionBoundsInfo(@NativeType(value="HmdQuad_t *") HmdQuad.Buffer pQuadsBuffer) {
        VRChaperoneSetup.nVRChaperoneSetup_SetWorkingCollisionBoundsInfo(pQuadsBuffer.address(), pQuadsBuffer.remaining());
    }

    public static void nVRChaperoneSetup_SetWorkingPerimeter(long pPointBuffer, int unPointCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingPerimeter;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(pPointBuffer, unPointCount, __functionAddress);
    }

    public static void VRChaperoneSetup_SetWorkingPerimeter(@NativeType(value="HmdVector2_t *") HmdVector2.Buffer pPointBuffer) {
        VRChaperoneSetup.nVRChaperoneSetup_SetWorkingPerimeter(pPointBuffer.address(), pPointBuffer.remaining());
    }

    public static void nVRChaperoneSetup_SetWorkingSeatedZeroPoseToRawTrackingPose(long pMatSeatedZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingSeatedZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(pMatSeatedZeroPoseToRawTrackingPose, __functionAddress);
    }

    public static void VRChaperoneSetup_SetWorkingSeatedZeroPoseToRawTrackingPose(@NativeType(value="HmdMatrix34_t const *") HmdMatrix34 pMatSeatedZeroPoseToRawTrackingPose) {
        VRChaperoneSetup.nVRChaperoneSetup_SetWorkingSeatedZeroPoseToRawTrackingPose(pMatSeatedZeroPoseToRawTrackingPose.address());
    }

    public static void nVRChaperoneSetup_SetWorkingStandingZeroPoseToRawTrackingPose(long pMatStandingZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingStandingZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(pMatStandingZeroPoseToRawTrackingPose, __functionAddress);
    }

    public static void VRChaperoneSetup_SetWorkingStandingZeroPoseToRawTrackingPose(@NativeType(value="HmdMatrix34_t const *") HmdMatrix34 pMatStandingZeroPoseToRawTrackingPose) {
        VRChaperoneSetup.nVRChaperoneSetup_SetWorkingStandingZeroPoseToRawTrackingPose(pMatStandingZeroPoseToRawTrackingPose.address());
    }

    public static void VRChaperoneSetup_ReloadFromDisk(@NativeType(value="EChaperoneConfigFile") int configFile) {
        long __functionAddress = OpenVR.VRChaperoneSetup.ReloadFromDisk;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(configFile, __functionAddress);
    }

    public static boolean nVRChaperoneSetup_GetLiveSeatedZeroPoseToRawTrackingPose(long pmatSeatedZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetLiveSeatedZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(pmatSeatedZeroPoseToRawTrackingPose, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_GetLiveSeatedZeroPoseToRawTrackingPose(@NativeType(value="HmdMatrix34_t *") HmdMatrix34 pmatSeatedZeroPoseToRawTrackingPose) {
        return VRChaperoneSetup.nVRChaperoneSetup_GetLiveSeatedZeroPoseToRawTrackingPose(pmatSeatedZeroPoseToRawTrackingPose.address());
    }

    public static boolean nVRChaperoneSetup_ExportLiveToBuffer(long pBuffer, long pnBufferLength) {
        long __functionAddress = OpenVR.VRChaperoneSetup.ExportLiveToBuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(pBuffer, pnBufferLength, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_ExportLiveToBuffer(@NativeType(value="char *") @Nullable ByteBuffer pBuffer, @NativeType(value="uint32_t *") IntBuffer pnBufferLength) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnBufferLength, 1);
            Checks.checkSafe((Buffer)pBuffer, pnBufferLength.get(pnBufferLength.position()));
        }
        return VRChaperoneSetup.nVRChaperoneSetup_ExportLiveToBuffer(MemoryUtil.memAddressSafe(pBuffer), MemoryUtil.memAddress(pnBufferLength));
    }

    public static boolean nVRChaperoneSetup_ImportFromBufferToWorking(long pBuffer, int nImportFlags) {
        long __functionAddress = OpenVR.VRChaperoneSetup.ImportFromBufferToWorking;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(pBuffer, nImportFlags, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperoneSetup_ImportFromBufferToWorking(@NativeType(value="char const *") ByteBuffer pBuffer, @NativeType(value="uint32_t") int nImportFlags) {
        return VRChaperoneSetup.nVRChaperoneSetup_ImportFromBufferToWorking(MemoryUtil.memAddress(pBuffer), nImportFlags);
    }

    public static void VRChaperoneSetup_ShowWorkingSetPreview() {
        long __functionAddress = OpenVR.VRChaperoneSetup.ShowWorkingSetPreview;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void VRChaperoneSetup_HideWorkingSetPreview() {
        long __functionAddress = OpenVR.VRChaperoneSetup.HideWorkingSetPreview;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void VRChaperoneSetup_RoomSetupStarting() {
        long __functionAddress = OpenVR.VRChaperoneSetup.RoomSetupStarting;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }
}

