/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.VRControllerAxis;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRControllerState_t")
public class VRControllerState
extends Struct<VRControllerState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UNPACKETNUM;
    public static final int ULBUTTONPRESSED;
    public static final int ULBUTTONTOUCHED;
    public static final int RAXIS;

    protected VRControllerState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VRControllerState create(long address, @Nullable ByteBuffer container) {
        return new VRControllerState(address, container);
    }

    public VRControllerState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VRControllerState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int unPacketNum() {
        return VRControllerState.nunPacketNum(this.address());
    }

    @NativeType(value="uint64_t")
    public long ulButtonPressed() {
        return VRControllerState.nulButtonPressed(this.address());
    }

    @NativeType(value="uint64_t")
    public long ulButtonTouched() {
        return VRControllerState.nulButtonTouched(this.address());
    }

    @NativeType(value="VRControllerAxis_t[5]")
    public VRControllerAxis.Buffer rAxis() {
        return VRControllerState.nrAxis(this.address());
    }

    @NativeType(value="VRControllerAxis_t")
    public VRControllerAxis rAxis(int index) {
        return VRControllerState.nrAxis(this.address(), index);
    }

    public VRControllerState unPacketNum(@NativeType(value="uint32_t") int value) {
        VRControllerState.nunPacketNum(this.address(), value);
        return this;
    }

    public VRControllerState ulButtonPressed(@NativeType(value="uint64_t") long value) {
        VRControllerState.nulButtonPressed(this.address(), value);
        return this;
    }

    public VRControllerState ulButtonTouched(@NativeType(value="uint64_t") long value) {
        VRControllerState.nulButtonTouched(this.address(), value);
        return this;
    }

    public VRControllerState rAxis(@NativeType(value="VRControllerAxis_t[5]") VRControllerAxis.Buffer value) {
        VRControllerState.nrAxis(this.address(), value);
        return this;
    }

    public VRControllerState rAxis(int index, @NativeType(value="VRControllerAxis_t") VRControllerAxis value) {
        VRControllerState.nrAxis(this.address(), index, value);
        return this;
    }

    public VRControllerState rAxis(Consumer<VRControllerAxis.Buffer> consumer) {
        consumer.accept(this.rAxis());
        return this;
    }

    public VRControllerState rAxis(int index, Consumer<VRControllerAxis> consumer) {
        consumer.accept(this.rAxis(index));
        return this;
    }

    public VRControllerState set(int unPacketNum, long ulButtonPressed, long ulButtonTouched, VRControllerAxis.Buffer rAxis) {
        this.unPacketNum(unPacketNum);
        this.ulButtonPressed(ulButtonPressed);
        this.ulButtonTouched(ulButtonTouched);
        this.rAxis(rAxis);
        return this;
    }

    public VRControllerState set(VRControllerState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRControllerState malloc() {
        return new VRControllerState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VRControllerState calloc() {
        return new VRControllerState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VRControllerState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VRControllerState(MemoryUtil.memAddress(container), container);
    }

    public static VRControllerState create(long address) {
        return new VRControllerState(address, null);
    }

    public static @Nullable VRControllerState createSafe(long address) {
        return address == 0L ? null : new VRControllerState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VRControllerState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRControllerState.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VRControllerState mallocStack() {
        return VRControllerState.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRControllerState callocStack() {
        return VRControllerState.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRControllerState mallocStack(MemoryStack stack) {
        return VRControllerState.malloc(stack);
    }

    @Deprecated
    public static VRControllerState callocStack(MemoryStack stack) {
        return VRControllerState.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRControllerState.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRControllerState.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRControllerState.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRControllerState.calloc(capacity, stack);
    }

    public static VRControllerState malloc(MemoryStack stack) {
        return new VRControllerState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRControllerState calloc(MemoryStack stack) {
        return new VRControllerState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nunPacketNum(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNPACKETNUM);
    }

    public static long nulButtonPressed(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ULBUTTONPRESSED);
    }

    public static long nulButtonTouched(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ULBUTTONTOUCHED);
    }

    public static VRControllerAxis.Buffer nrAxis(long struct) {
        return VRControllerAxis.create(struct + (long)RAXIS, 5);
    }

    public static VRControllerAxis nrAxis(long struct, int index) {
        return VRControllerAxis.create(struct + (long)RAXIS + Checks.check(index, 5) * (long)VRControllerAxis.SIZEOF);
    }

    public static void nunPacketNum(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNPACKETNUM, value);
    }

    public static void nulButtonPressed(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)ULBUTTONPRESSED, value);
    }

    public static void nulButtonTouched(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)ULBUTTONTOUCHED, value);
    }

    public static void nrAxis(long struct, VRControllerAxis.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 5);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)RAXIS, value.remaining() * VRControllerAxis.SIZEOF);
    }

    public static void nrAxis(long struct, int index, VRControllerAxis value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RAXIS + Checks.check(index, 5) * (long)VRControllerAxis.SIZEOF, VRControllerAxis.SIZEOF);
    }

    static {
        Struct.Layout layout = VRControllerState.__struct(VRControllerState.__member(4), VRControllerState.__member(8), VRControllerState.__member(8), VRControllerState.__array(VRControllerAxis.SIZEOF, VRControllerAxis.ALIGNOF, 5));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UNPACKETNUM = layout.offsetof(0);
        ULBUTTONPRESSED = layout.offsetof(1);
        ULBUTTONTOUCHED = layout.offsetof(2);
        RAXIS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VRControllerState, Buffer>
    implements NativeResource {
        private static final VRControllerState ELEMENT_FACTORY = VRControllerState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VRControllerState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int unPacketNum() {
            return VRControllerState.nunPacketNum(this.address());
        }

        @NativeType(value="uint64_t")
        public long ulButtonPressed() {
            return VRControllerState.nulButtonPressed(this.address());
        }

        @NativeType(value="uint64_t")
        public long ulButtonTouched() {
            return VRControllerState.nulButtonTouched(this.address());
        }

        @NativeType(value="VRControllerAxis_t[5]")
        public VRControllerAxis.Buffer rAxis() {
            return VRControllerState.nrAxis(this.address());
        }

        @NativeType(value="VRControllerAxis_t")
        public VRControllerAxis rAxis(int index) {
            return VRControllerState.nrAxis(this.address(), index);
        }

        public Buffer unPacketNum(@NativeType(value="uint32_t") int value) {
            VRControllerState.nunPacketNum(this.address(), value);
            return this;
        }

        public Buffer ulButtonPressed(@NativeType(value="uint64_t") long value) {
            VRControllerState.nulButtonPressed(this.address(), value);
            return this;
        }

        public Buffer ulButtonTouched(@NativeType(value="uint64_t") long value) {
            VRControllerState.nulButtonTouched(this.address(), value);
            return this;
        }

        public Buffer rAxis(@NativeType(value="VRControllerAxis_t[5]") VRControllerAxis.Buffer value) {
            VRControllerState.nrAxis(this.address(), value);
            return this;
        }

        public Buffer rAxis(int index, @NativeType(value="VRControllerAxis_t") VRControllerAxis value) {
            VRControllerState.nrAxis(this.address(), index, value);
            return this;
        }

        public Buffer rAxis(Consumer<VRControllerAxis.Buffer> consumer) {
            consumer.accept(this.rAxis());
            return this;
        }

        public Buffer rAxis(int index, Consumer<VRControllerAxis> consumer) {
            consumer.accept(this.rAxis(index));
            return this;
        }
    }
}

