/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Mouse_t")
public class VREventMouse
extends Struct<VREventMouse> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int BUTTON;
    public static final int CURSORINDEX;

    protected VREventMouse(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VREventMouse create(long address, @Nullable ByteBuffer container) {
        return new VREventMouse(address, container);
    }

    public VREventMouse(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VREventMouse.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VREventMouse.nx(this.address());
    }

    public float y() {
        return VREventMouse.ny(this.address());
    }

    @NativeType(value="uint32_t")
    public int button() {
        return VREventMouse.nbutton(this.address());
    }

    @NativeType(value="uint32_t")
    public int cursorIndex() {
        return VREventMouse.ncursorIndex(this.address());
    }

    public static VREventMouse create(long address) {
        return new VREventMouse(address, null);
    }

    public static @Nullable VREventMouse createSafe(long address) {
        return address == 0L ? null : new VREventMouse(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static int nbutton(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUTTON);
    }

    public static int ncursorIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURSORINDEX);
    }

    static {
        Struct.Layout layout = VREventMouse.__struct(VREventMouse.__member(4), VREventMouse.__member(4), VREventMouse.__member(4), VREventMouse.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        BUTTON = layout.offsetof(2);
        CURSORINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VREventMouse, Buffer> {
        private static final VREventMouse ELEMENT_FACTORY = VREventMouse.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VREventMouse getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return VREventMouse.nx(this.address());
        }

        public float y() {
            return VREventMouse.ny(this.address());
        }

        @NativeType(value="uint32_t")
        public int button() {
            return VREventMouse.nbutton(this.address());
        }

        @NativeType(value="uint32_t")
        public int cursorIndex() {
            return VREventMouse.ncursorIndex(this.address());
        }
    }
}

