/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRNativeDevice_t")
public class VRNativeDevice
extends Struct<VRNativeDevice>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;

    protected VRNativeDevice(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VRNativeDevice create(long address, @Nullable ByteBuffer container) {
        return new VRNativeDevice(address, container);
    }

    public VRNativeDevice(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VRNativeDevice.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return VRNativeDevice.nhandle(this.address());
    }

    @NativeType(value="EDeviceType")
    public int eType() {
        return VRNativeDevice.neType(this.address());
    }

    public VRNativeDevice handle(@NativeType(value="void *") long value) {
        VRNativeDevice.nhandle(this.address(), value);
        return this;
    }

    public VRNativeDevice eType(@NativeType(value="EDeviceType") int value) {
        VRNativeDevice.neType(this.address(), value);
        return this;
    }

    public VRNativeDevice set(long handle, int eType) {
        this.handle(handle);
        this.eType(eType);
        return this;
    }

    public VRNativeDevice set(VRNativeDevice src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRNativeDevice malloc() {
        return new VRNativeDevice(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VRNativeDevice calloc() {
        return new VRNativeDevice(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VRNativeDevice create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VRNativeDevice(MemoryUtil.memAddress(container), container);
    }

    public static VRNativeDevice create(long address) {
        return new VRNativeDevice(address, null);
    }

    public static @Nullable VRNativeDevice createSafe(long address) {
        return address == 0L ? null : new VRNativeDevice(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VRNativeDevice.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRNativeDevice.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VRNativeDevice malloc(MemoryStack stack) {
        return new VRNativeDevice(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRNativeDevice calloc(MemoryStack stack) {
        return new VRNativeDevice(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static int neType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ETYPE);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void neType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ETYPE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
    }

    static {
        Struct.Layout layout = VRNativeDevice.__struct(VRNativeDevice.__member(POINTER_SIZE), VRNativeDevice.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VRNativeDevice, Buffer>
    implements NativeResource {
        private static final VRNativeDevice ELEMENT_FACTORY = VRNativeDevice.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VRNativeDevice getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return VRNativeDevice.nhandle(this.address());
        }

        @NativeType(value="EDeviceType")
        public int eType() {
            return VRNativeDevice.neType(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            VRNativeDevice.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="EDeviceType") int value) {
            VRNativeDevice.neType(this.address(), value);
            return this;
        }
    }
}

