/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.VROverlayIntersectionMaskPrimitiveData;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VROverlayIntersectionMaskPrimitive_t")
public class VROverlayIntersectionMaskPrimitive
extends Struct<VROverlayIntersectionMaskPrimitive>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NPRIMITIVETYPE;
    public static final int M_PRIMITIVE;

    protected VROverlayIntersectionMaskPrimitive(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VROverlayIntersectionMaskPrimitive create(long address, @Nullable ByteBuffer container) {
        return new VROverlayIntersectionMaskPrimitive(address, container);
    }

    public VROverlayIntersectionMaskPrimitive(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VROverlayIntersectionMaskPrimitive.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="EVROverlayIntersectionMaskPrimitiveType")
    public int m_nPrimitiveType() {
        return VROverlayIntersectionMaskPrimitive.nm_nPrimitiveType(this.address());
    }

    @NativeType(value="VROverlayIntersectionMaskPrimitive_Data_t")
    public VROverlayIntersectionMaskPrimitiveData m_Primitive() {
        return VROverlayIntersectionMaskPrimitive.nm_Primitive(this.address());
    }

    public VROverlayIntersectionMaskPrimitive m_nPrimitiveType(@NativeType(value="EVROverlayIntersectionMaskPrimitiveType") int value) {
        VROverlayIntersectionMaskPrimitive.nm_nPrimitiveType(this.address(), value);
        return this;
    }

    public VROverlayIntersectionMaskPrimitive m_Primitive(@NativeType(value="VROverlayIntersectionMaskPrimitive_Data_t") VROverlayIntersectionMaskPrimitiveData value) {
        VROverlayIntersectionMaskPrimitive.nm_Primitive(this.address(), value);
        return this;
    }

    public VROverlayIntersectionMaskPrimitive m_Primitive(Consumer<VROverlayIntersectionMaskPrimitiveData> consumer) {
        consumer.accept(this.m_Primitive());
        return this;
    }

    public VROverlayIntersectionMaskPrimitive set(int m_nPrimitiveType, VROverlayIntersectionMaskPrimitiveData m_Primitive) {
        this.m_nPrimitiveType(m_nPrimitiveType);
        this.m_Primitive(m_Primitive);
        return this;
    }

    public VROverlayIntersectionMaskPrimitive set(VROverlayIntersectionMaskPrimitive src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VROverlayIntersectionMaskPrimitive malloc() {
        return new VROverlayIntersectionMaskPrimitive(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VROverlayIntersectionMaskPrimitive calloc() {
        return new VROverlayIntersectionMaskPrimitive(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VROverlayIntersectionMaskPrimitive create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VROverlayIntersectionMaskPrimitive(MemoryUtil.memAddress(container), container);
    }

    public static VROverlayIntersectionMaskPrimitive create(long address) {
        return new VROverlayIntersectionMaskPrimitive(address, null);
    }

    public static @Nullable VROverlayIntersectionMaskPrimitive createSafe(long address) {
        return address == 0L ? null : new VROverlayIntersectionMaskPrimitive(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VROverlayIntersectionMaskPrimitive.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VROverlayIntersectionMaskPrimitive.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VROverlayIntersectionMaskPrimitive mallocStack() {
        return VROverlayIntersectionMaskPrimitive.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VROverlayIntersectionMaskPrimitive callocStack() {
        return VROverlayIntersectionMaskPrimitive.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VROverlayIntersectionMaskPrimitive mallocStack(MemoryStack stack) {
        return VROverlayIntersectionMaskPrimitive.malloc(stack);
    }

    @Deprecated
    public static VROverlayIntersectionMaskPrimitive callocStack(MemoryStack stack) {
        return VROverlayIntersectionMaskPrimitive.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VROverlayIntersectionMaskPrimitive.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VROverlayIntersectionMaskPrimitive.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionMaskPrimitive.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionMaskPrimitive.calloc(capacity, stack);
    }

    public static VROverlayIntersectionMaskPrimitive malloc(MemoryStack stack) {
        return new VROverlayIntersectionMaskPrimitive(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VROverlayIntersectionMaskPrimitive calloc(MemoryStack stack) {
        return new VROverlayIntersectionMaskPrimitive(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nm_nPrimitiveType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NPRIMITIVETYPE);
    }

    public static VROverlayIntersectionMaskPrimitiveData nm_Primitive(long struct) {
        return VROverlayIntersectionMaskPrimitiveData.create(struct + (long)M_PRIMITIVE);
    }

    public static void nm_nPrimitiveType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NPRIMITIVETYPE, value);
    }

    public static void nm_Primitive(long struct, VROverlayIntersectionMaskPrimitiveData value) {
        MemoryUtil.memCopy(value.address(), struct + (long)M_PRIMITIVE, VROverlayIntersectionMaskPrimitiveData.SIZEOF);
    }

    static {
        Struct.Layout layout = VROverlayIntersectionMaskPrimitive.__struct(VROverlayIntersectionMaskPrimitive.__member(4), VROverlayIntersectionMaskPrimitive.__member(VROverlayIntersectionMaskPrimitiveData.SIZEOF, VROverlayIntersectionMaskPrimitiveData.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NPRIMITIVETYPE = layout.offsetof(0);
        M_PRIMITIVE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VROverlayIntersectionMaskPrimitive, Buffer>
    implements NativeResource {
        private static final VROverlayIntersectionMaskPrimitive ELEMENT_FACTORY = VROverlayIntersectionMaskPrimitive.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VROverlayIntersectionMaskPrimitive getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="EVROverlayIntersectionMaskPrimitiveType")
        public int m_nPrimitiveType() {
            return VROverlayIntersectionMaskPrimitive.nm_nPrimitiveType(this.address());
        }

        @NativeType(value="VROverlayIntersectionMaskPrimitive_Data_t")
        public VROverlayIntersectionMaskPrimitiveData m_Primitive() {
            return VROverlayIntersectionMaskPrimitive.nm_Primitive(this.address());
        }

        public Buffer m_nPrimitiveType(@NativeType(value="EVROverlayIntersectionMaskPrimitiveType") int value) {
            VROverlayIntersectionMaskPrimitive.nm_nPrimitiveType(this.address(), value);
            return this;
        }

        public Buffer m_Primitive(@NativeType(value="VROverlayIntersectionMaskPrimitive_Data_t") VROverlayIntersectionMaskPrimitiveData value) {
            VROverlayIntersectionMaskPrimitive.nm_Primitive(this.address(), value);
            return this;
        }

        public Buffer m_Primitive(Consumer<VROverlayIntersectionMaskPrimitiveData> consumer) {
            consumer.accept(this.m_Primitive());
            return this;
        }
    }
}

