/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VROverlayProjection_t")
public class VROverlayProjection
extends Struct<VROverlayProjection>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLEFT;
    public static final int FRIGHT;
    public static final int FTOP;
    public static final int FBOTTOM;

    protected VROverlayProjection(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VROverlayProjection create(long address, @Nullable ByteBuffer container) {
        return new VROverlayProjection(address, container);
    }

    public VROverlayProjection(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VROverlayProjection.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float fLeft() {
        return VROverlayProjection.nfLeft(this.address());
    }

    public float fRight() {
        return VROverlayProjection.nfRight(this.address());
    }

    public float fTop() {
        return VROverlayProjection.nfTop(this.address());
    }

    public float fBottom() {
        return VROverlayProjection.nfBottom(this.address());
    }

    public VROverlayProjection fLeft(float value) {
        VROverlayProjection.nfLeft(this.address(), value);
        return this;
    }

    public VROverlayProjection fRight(float value) {
        VROverlayProjection.nfRight(this.address(), value);
        return this;
    }

    public VROverlayProjection fTop(float value) {
        VROverlayProjection.nfTop(this.address(), value);
        return this;
    }

    public VROverlayProjection fBottom(float value) {
        VROverlayProjection.nfBottom(this.address(), value);
        return this;
    }

    public VROverlayProjection set(float fLeft, float fRight, float fTop, float fBottom) {
        this.fLeft(fLeft);
        this.fRight(fRight);
        this.fTop(fTop);
        this.fBottom(fBottom);
        return this;
    }

    public VROverlayProjection set(VROverlayProjection src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VROverlayProjection malloc() {
        return new VROverlayProjection(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VROverlayProjection calloc() {
        return new VROverlayProjection(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VROverlayProjection create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VROverlayProjection(MemoryUtil.memAddress(container), container);
    }

    public static VROverlayProjection create(long address) {
        return new VROverlayProjection(address, null);
    }

    public static @Nullable VROverlayProjection createSafe(long address) {
        return address == 0L ? null : new VROverlayProjection(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VROverlayProjection.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VROverlayProjection.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VROverlayProjection malloc(MemoryStack stack) {
        return new VROverlayProjection(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VROverlayProjection calloc(MemoryStack stack) {
        return new VROverlayProjection(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nfLeft(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FLEFT);
    }

    public static float nfRight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FRIGHT);
    }

    public static float nfTop(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FTOP);
    }

    public static float nfBottom(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FBOTTOM);
    }

    public static void nfLeft(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FLEFT, value);
    }

    public static void nfRight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FRIGHT, value);
    }

    public static void nfTop(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FTOP, value);
    }

    public static void nfBottom(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FBOTTOM, value);
    }

    static {
        Struct.Layout layout = VROverlayProjection.__struct(VROverlayProjection.__member(4), VROverlayProjection.__member(4), VROverlayProjection.__member(4), VROverlayProjection.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLEFT = layout.offsetof(0);
        FRIGHT = layout.offsetof(1);
        FTOP = layout.offsetof(2);
        FBOTTOM = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VROverlayProjection, Buffer>
    implements NativeResource {
        private static final VROverlayProjection ELEMENT_FACTORY = VROverlayProjection.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VROverlayProjection getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float fLeft() {
            return VROverlayProjection.nfLeft(this.address());
        }

        public float fRight() {
            return VROverlayProjection.nfRight(this.address());
        }

        public float fTop() {
            return VROverlayProjection.nfTop(this.address());
        }

        public float fBottom() {
            return VROverlayProjection.nfBottom(this.address());
        }

        public Buffer fLeft(float value) {
            VROverlayProjection.nfLeft(this.address(), value);
            return this;
        }

        public Buffer fRight(float value) {
            VROverlayProjection.nfRight(this.address(), value);
            return this;
        }

        public Buffer fTop(float value) {
            VROverlayProjection.nfTop(this.address(), value);
            return this;
        }

        public Buffer fBottom(float value) {
            VROverlayProjection.nfBottom(this.address(), value);
            return this;
        }
    }
}

