/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.PathRead;
import org.lwjgl.openvr.PathWrite;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRPaths {
    protected VRPaths() {
        throw new UnsupportedOperationException();
    }

    public static int nVRPaths_ReadPathBatch(long ulRootHandle, long pBatch, int unBatchEntryCount) {
        long __functionAddress = OpenVR.VRPaths.ReadPathBatch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(ulRootHandle, pBatch, unBatchEntryCount, __functionAddress);
    }

    @NativeType(value="ETrackedPropertyError")
    public static int VRPaths_ReadPathBatch(@NativeType(value="PropertyContainerHandle_t") long ulRootHandle, @NativeType(value="PathRead_t *") PathRead.Buffer pBatch) {
        return VRPaths.nVRPaths_ReadPathBatch(ulRootHandle, pBatch.address(), pBatch.remaining());
    }

    public static int nVRPaths_WritePathBatch(long ulRootHandle, long pBatch, int unBatchEntryCount) {
        long __functionAddress = OpenVR.VRPaths.WritePathBatch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(ulRootHandle, pBatch, unBatchEntryCount, __functionAddress);
    }

    @NativeType(value="ETrackedPropertyError")
    public static int VRPaths_WritePathBatch(@NativeType(value="PropertyContainerHandle_t") long ulRootHandle, @NativeType(value="PathWrite_t *") PathWrite.Buffer pBatch) {
        return VRPaths.nVRPaths_WritePathBatch(ulRootHandle, pBatch.address(), pBatch.remaining());
    }

    public static int nVRPaths_StringToHandle(long pHandle, long pchPath) {
        long __functionAddress = OpenVR.VRPaths.StringToHandle;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(pHandle, pchPath, __functionAddress);
    }

    @NativeType(value="ETrackedPropertyError")
    public static int VRPaths_StringToHandle(@NativeType(value="PathHandle_t *") LongBuffer pHandle, @NativeType(value="char *") ByteBuffer pchPath) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandle, 1);
            Checks.checkNT1(pchPath);
        }
        return VRPaths.nVRPaths_StringToHandle(MemoryUtil.memAddress(pHandle), MemoryUtil.memAddress(pchPath));
    }

    public static int nVRPaths_HandleToString(long pHandle, long pchBuffer, int unBufferSize, long punBufferSizeUsed) {
        long __functionAddress = OpenVR.VRPaths.HandleToString;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(pHandle, pchBuffer, unBufferSize, punBufferSizeUsed, __functionAddress);
    }

    @NativeType(value="ETrackedPropertyError")
    public static int VRPaths_HandleToString(@NativeType(value="PathHandle_t") long pHandle, @NativeType(value="char *") ByteBuffer pchBuffer, @NativeType(value="uint32_t *") IntBuffer punBufferSizeUsed) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punBufferSizeUsed, 1);
        }
        return VRPaths.nVRPaths_HandleToString(pHandle, MemoryUtil.memAddress(pchBuffer), pchBuffer.remaining(), MemoryUtil.memAddress(punBufferSizeUsed));
    }
}

