/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRResources {
    protected VRResources() {
        throw new UnsupportedOperationException();
    }

    public static int nVRResources_LoadSharedResource(long pchResourceName, long pchBuffer, int unBufferLen) {
        long __functionAddress = OpenVR.VRResources.LoadSharedResource;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(pchResourceName, pchBuffer, unBufferLen, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRResources_LoadSharedResource(@NativeType(value="char const *") ByteBuffer pchResourceName, @NativeType(value="char *") @Nullable ByteBuffer pchBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchResourceName);
        }
        return VRResources.nVRResources_LoadSharedResource(MemoryUtil.memAddress(pchResourceName), MemoryUtil.memAddressSafe(pchBuffer), Checks.remainingSafe(pchBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRResources_LoadSharedResource(@NativeType(value="char const *") CharSequence pchResourceName, @NativeType(value="char *") @Nullable ByteBuffer pchBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchResourceName, true);
            long pchResourceNameEncoded = stack.getPointerAddress();
            int n = VRResources.nVRResources_LoadSharedResource(pchResourceNameEncoded, MemoryUtil.memAddressSafe(pchBuffer), Checks.remainingSafe(pchBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRResources_LoadSharedResource(@NativeType(value="char const *") CharSequence pchResourceName, @NativeType(value="uint32_t") int unBufferLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchResourceName, true);
            long pchResourceNameEncoded = stack.getPointerAddress();
            ByteBuffer pchBuffer = stack.malloc(unBufferLen);
            int __result = VRResources.nVRResources_LoadSharedResource(pchResourceNameEncoded, MemoryUtil.memAddress(pchBuffer), unBufferLen);
            String string = MemoryUtil.memASCII(pchBuffer, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRResources_GetResourceFullPath(long pchResourceName, long pchResourceTypeDirectory, long pchPathBuffer, int unBufferLen) {
        long __functionAddress = OpenVR.VRResources.GetResourceFullPath;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(pchResourceName, pchResourceTypeDirectory, pchPathBuffer, unBufferLen, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRResources_GetResourceFullPath(@NativeType(value="char const *") ByteBuffer pchResourceName, @NativeType(value="char const *") ByteBuffer pchResourceTypeDirectory, @NativeType(value="char *") @Nullable ByteBuffer pchPathBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchResourceName);
            Checks.checkNT1(pchResourceTypeDirectory);
        }
        return VRResources.nVRResources_GetResourceFullPath(MemoryUtil.memAddress(pchResourceName), MemoryUtil.memAddress(pchResourceTypeDirectory), MemoryUtil.memAddressSafe(pchPathBuffer), Checks.remainingSafe(pchPathBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRResources_GetResourceFullPath(@NativeType(value="char const *") CharSequence pchResourceName, @NativeType(value="char const *") CharSequence pchResourceTypeDirectory, @NativeType(value="char *") @Nullable ByteBuffer pchPathBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchResourceName, true);
            long pchResourceNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchResourceTypeDirectory, true);
            long pchResourceTypeDirectoryEncoded = stack.getPointerAddress();
            int n = VRResources.nVRResources_GetResourceFullPath(pchResourceNameEncoded, pchResourceTypeDirectoryEncoded, MemoryUtil.memAddressSafe(pchPathBuffer), Checks.remainingSafe(pchPathBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRResources_GetResourceFullPath(@NativeType(value="char const *") CharSequence pchResourceName, @NativeType(value="char const *") CharSequence pchResourceTypeDirectory, @NativeType(value="uint32_t") int unBufferLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchResourceName, true);
            long pchResourceNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchResourceTypeDirectory, true);
            long pchResourceTypeDirectoryEncoded = stack.getPointerAddress();
            ByteBuffer pchPathBuffer = stack.malloc(unBufferLen);
            int __result = VRResources.nVRResources_GetResourceFullPath(pchResourceNameEncoded, pchResourceTypeDirectoryEncoded, MemoryUtil.memAddress(pchPathBuffer), unBufferLen);
            String string = MemoryUtil.memASCII(pchPathBuffer, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

