/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.VRTextureDepthInfo;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureWithPoseAndDepth_t")
public class VRTextureWithPoseAndDepth
extends Struct<VRTextureWithPoseAndDepth>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;
    public static final int ECOLORSPACE;
    public static final int MDEVICETOABSOLUTETRACKING;
    public static final int DEPTH;

    protected VRTextureWithPoseAndDepth(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VRTextureWithPoseAndDepth create(long address, @Nullable ByteBuffer container) {
        return new VRTextureWithPoseAndDepth(address, container);
    }

    public VRTextureWithPoseAndDepth(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VRTextureWithPoseAndDepth.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return VRTextureWithPoseAndDepth.nhandle(this.address());
    }

    @NativeType(value="ETextureType")
    public int eType() {
        return VRTextureWithPoseAndDepth.neType(this.address());
    }

    @NativeType(value="EColorSpace")
    public int eColorSpace() {
        return VRTextureWithPoseAndDepth.neColorSpace(this.address());
    }

    @NativeType(value="HmdMatrix34_t")
    public HmdMatrix34 mDeviceToAbsoluteTracking() {
        return VRTextureWithPoseAndDepth.nmDeviceToAbsoluteTracking(this.address());
    }

    @NativeType(value="VRTextureDepthInfo_t")
    public VRTextureDepthInfo depth() {
        return VRTextureWithPoseAndDepth.ndepth(this.address());
    }

    public VRTextureWithPoseAndDepth handle(@NativeType(value="void *") long value) {
        VRTextureWithPoseAndDepth.nhandle(this.address(), value);
        return this;
    }

    public VRTextureWithPoseAndDepth eType(@NativeType(value="ETextureType") int value) {
        VRTextureWithPoseAndDepth.neType(this.address(), value);
        return this;
    }

    public VRTextureWithPoseAndDepth eColorSpace(@NativeType(value="EColorSpace") int value) {
        VRTextureWithPoseAndDepth.neColorSpace(this.address(), value);
        return this;
    }

    public VRTextureWithPoseAndDepth mDeviceToAbsoluteTracking(@NativeType(value="HmdMatrix34_t") HmdMatrix34 value) {
        VRTextureWithPoseAndDepth.nmDeviceToAbsoluteTracking(this.address(), value);
        return this;
    }

    public VRTextureWithPoseAndDepth mDeviceToAbsoluteTracking(Consumer<HmdMatrix34> consumer) {
        consumer.accept(this.mDeviceToAbsoluteTracking());
        return this;
    }

    public VRTextureWithPoseAndDepth depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
        VRTextureWithPoseAndDepth.ndepth(this.address(), value);
        return this;
    }

    public VRTextureWithPoseAndDepth depth(Consumer<VRTextureDepthInfo> consumer) {
        consumer.accept(this.depth());
        return this;
    }

    public VRTextureWithPoseAndDepth set(long handle, int eType, int eColorSpace, HmdMatrix34 mDeviceToAbsoluteTracking, VRTextureDepthInfo depth) {
        this.handle(handle);
        this.eType(eType);
        this.eColorSpace(eColorSpace);
        this.mDeviceToAbsoluteTracking(mDeviceToAbsoluteTracking);
        this.depth(depth);
        return this;
    }

    public VRTextureWithPoseAndDepth set(VRTextureWithPoseAndDepth src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRTextureWithPoseAndDepth malloc() {
        return new VRTextureWithPoseAndDepth(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VRTextureWithPoseAndDepth calloc() {
        return new VRTextureWithPoseAndDepth(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VRTextureWithPoseAndDepth create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VRTextureWithPoseAndDepth(MemoryUtil.memAddress(container), container);
    }

    public static VRTextureWithPoseAndDepth create(long address) {
        return new VRTextureWithPoseAndDepth(address, null);
    }

    public static @Nullable VRTextureWithPoseAndDepth createSafe(long address) {
        return address == 0L ? null : new VRTextureWithPoseAndDepth(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VRTextureWithPoseAndDepth.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRTextureWithPoseAndDepth.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VRTextureWithPoseAndDepth mallocStack() {
        return VRTextureWithPoseAndDepth.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureWithPoseAndDepth callocStack() {
        return VRTextureWithPoseAndDepth.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureWithPoseAndDepth mallocStack(MemoryStack stack) {
        return VRTextureWithPoseAndDepth.malloc(stack);
    }

    @Deprecated
    public static VRTextureWithPoseAndDepth callocStack(MemoryStack stack) {
        return VRTextureWithPoseAndDepth.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRTextureWithPoseAndDepth.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRTextureWithPoseAndDepth.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureWithPoseAndDepth.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureWithPoseAndDepth.calloc(capacity, stack);
    }

    public static VRTextureWithPoseAndDepth malloc(MemoryStack stack) {
        return new VRTextureWithPoseAndDepth(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRTextureWithPoseAndDepth calloc(MemoryStack stack) {
        return new VRTextureWithPoseAndDepth(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static int neType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ETYPE);
    }

    public static int neColorSpace(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ECOLORSPACE);
    }

    public static HmdMatrix34 nmDeviceToAbsoluteTracking(long struct) {
        return HmdMatrix34.create(struct + (long)MDEVICETOABSOLUTETRACKING);
    }

    public static VRTextureDepthInfo ndepth(long struct) {
        return VRTextureDepthInfo.create(struct + (long)DEPTH);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void neType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ETYPE, value);
    }

    public static void neColorSpace(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ECOLORSPACE, value);
    }

    public static void nmDeviceToAbsoluteTracking(long struct, HmdMatrix34 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MDEVICETOABSOLUTETRACKING, HmdMatrix34.SIZEOF);
    }

    public static void ndepth(long struct, VRTextureDepthInfo value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEPTH, VRTextureDepthInfo.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
        VRTextureDepthInfo.validate(struct + (long)DEPTH);
    }

    static {
        Struct.Layout layout = VRTextureWithPoseAndDepth.__struct(VRTextureWithPoseAndDepth.__member(POINTER_SIZE), VRTextureWithPoseAndDepth.__member(4), VRTextureWithPoseAndDepth.__member(4), VRTextureWithPoseAndDepth.__member(HmdMatrix34.SIZEOF, HmdMatrix34.ALIGNOF), VRTextureWithPoseAndDepth.__member(VRTextureDepthInfo.SIZEOF, VRTextureDepthInfo.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
        ECOLORSPACE = layout.offsetof(2);
        MDEVICETOABSOLUTETRACKING = layout.offsetof(3);
        DEPTH = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VRTextureWithPoseAndDepth, Buffer>
    implements NativeResource {
        private static final VRTextureWithPoseAndDepth ELEMENT_FACTORY = VRTextureWithPoseAndDepth.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VRTextureWithPoseAndDepth getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return VRTextureWithPoseAndDepth.nhandle(this.address());
        }

        @NativeType(value="ETextureType")
        public int eType() {
            return VRTextureWithPoseAndDepth.neType(this.address());
        }

        @NativeType(value="EColorSpace")
        public int eColorSpace() {
            return VRTextureWithPoseAndDepth.neColorSpace(this.address());
        }

        @NativeType(value="HmdMatrix34_t")
        public HmdMatrix34 mDeviceToAbsoluteTracking() {
            return VRTextureWithPoseAndDepth.nmDeviceToAbsoluteTracking(this.address());
        }

        @NativeType(value="VRTextureDepthInfo_t")
        public VRTextureDepthInfo depth() {
            return VRTextureWithPoseAndDepth.ndepth(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            VRTextureWithPoseAndDepth.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="ETextureType") int value) {
            VRTextureWithPoseAndDepth.neType(this.address(), value);
            return this;
        }

        public Buffer eColorSpace(@NativeType(value="EColorSpace") int value) {
            VRTextureWithPoseAndDepth.neColorSpace(this.address(), value);
            return this;
        }

        public Buffer mDeviceToAbsoluteTracking(@NativeType(value="HmdMatrix34_t") HmdMatrix34 value) {
            VRTextureWithPoseAndDepth.nmDeviceToAbsoluteTracking(this.address(), value);
            return this;
        }

        public Buffer mDeviceToAbsoluteTracking(Consumer<HmdMatrix34> consumer) {
            consumer.accept(this.mDeviceToAbsoluteTracking());
            return this;
        }

        public Buffer depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
            VRTextureWithPoseAndDepth.ndepth(this.address(), value);
            return this;
        }

        public Buffer depth(Consumer<VRTextureDepthInfo> consumer) {
            consumer.accept(this.depth());
            return this;
        }
    }
}

