/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrPerformanceMetricsCounterMETA;
import org.lwjgl.openxr.XrPerformanceMetricsStateMETA;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class METAPerformanceMetrics {
    public static final int XR_META_performance_metrics_SPEC_VERSION = 2;
    public static final String XR_META_PERFORMANCE_METRICS_EXTENSION_NAME = "XR_META_performance_metrics";
    public static final int XR_TYPE_PERFORMANCE_METRICS_STATE_META = 1000232001;
    public static final int XR_TYPE_PERFORMANCE_METRICS_COUNTER_META = 1000232002;
    public static final int XR_PERFORMANCE_METRICS_COUNTER_ANY_VALUE_VALID_BIT_META = 1;
    public static final int XR_PERFORMANCE_METRICS_COUNTER_UINT_VALUE_VALID_BIT_META = 2;
    public static final int XR_PERFORMANCE_METRICS_COUNTER_FLOAT_VALUE_VALID_BIT_META = 4;
    public static final int XR_PERFORMANCE_METRICS_COUNTER_UNIT_GENERIC_META = 0;
    public static final int XR_PERFORMANCE_METRICS_COUNTER_UNIT_PERCENTAGE_META = 1;
    public static final int XR_PERFORMANCE_METRICS_COUNTER_UNIT_MILLISECONDS_META = 2;
    public static final int XR_PERFORMANCE_METRICS_COUNTER_UNIT_BYTES_META = 3;
    public static final int XR_PERFORMANCE_METRICS_COUNTER_UNIT_HERTZ_META = 4;

    protected METAPerformanceMetrics() {
        throw new UnsupportedOperationException();
    }

    public static int nxrEnumeratePerformanceMetricsCounterPathsMETA(XrInstance instance, int counterPathCapacityInput, long counterPathCountOutput, long counterPaths) {
        long __functionAddress = instance.getCapabilities().xrEnumeratePerformanceMetricsCounterPathsMETA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(instance.address(), counterPathCapacityInput, counterPathCountOutput, counterPaths, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumeratePerformanceMetricsCounterPathsMETA(XrInstance instance, @NativeType(value="uint32_t *") IntBuffer counterPathCountOutput, @NativeType(value="XrPath *") @Nullable LongBuffer counterPaths) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)counterPathCountOutput, 1);
        }
        return METAPerformanceMetrics.nxrEnumeratePerformanceMetricsCounterPathsMETA(instance, Checks.remainingSafe(counterPaths), MemoryUtil.memAddress(counterPathCountOutput), MemoryUtil.memAddressSafe(counterPaths));
    }

    public static int nxrSetPerformanceMetricsStateMETA(XrSession session, long state) {
        long __functionAddress = session.getCapabilities().xrSetPerformanceMetricsStateMETA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(session.address(), state, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSetPerformanceMetricsStateMETA(XrSession session, @NativeType(value="XrPerformanceMetricsStateMETA const *") XrPerformanceMetricsStateMETA state) {
        return METAPerformanceMetrics.nxrSetPerformanceMetricsStateMETA(session, state.address());
    }

    public static int nxrGetPerformanceMetricsStateMETA(XrSession session, long state) {
        long __functionAddress = session.getCapabilities().xrGetPerformanceMetricsStateMETA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(session.address(), state, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetPerformanceMetricsStateMETA(XrSession session, @NativeType(value="XrPerformanceMetricsStateMETA *") XrPerformanceMetricsStateMETA state) {
        return METAPerformanceMetrics.nxrGetPerformanceMetricsStateMETA(session, state.address());
    }

    public static int nxrQueryPerformanceMetricsCounterMETA(XrSession session, long counterPath, long counter) {
        long __functionAddress = session.getCapabilities().xrQueryPerformanceMetricsCounterMETA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(session.address(), counterPath, counter, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrQueryPerformanceMetricsCounterMETA(XrSession session, @NativeType(value="XrPath") long counterPath, @NativeType(value="XrPerformanceMetricsCounterMETA *") XrPerformanceMetricsCounterMETA counter) {
        return METAPerformanceMetrics.nxrQueryPerformanceMetricsCounterMETA(session, counterPath, counter.address());
    }
}

