/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrActiveActionSetPriorityEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActiveActionSetPrioritiesEXT
extends Struct<XrActiveActionSetPrioritiesEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTIONSETPRIORITYCOUNT;
    public static final int ACTIONSETPRIORITIES;

    protected XrActiveActionSetPrioritiesEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrActiveActionSetPrioritiesEXT create(long address, @Nullable ByteBuffer container) {
        return new XrActiveActionSetPrioritiesEXT(address, container);
    }

    public XrActiveActionSetPrioritiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrActiveActionSetPrioritiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActiveActionSetPrioritiesEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrActiveActionSetPrioritiesEXT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int actionSetPriorityCount() {
        return XrActiveActionSetPrioritiesEXT.nactionSetPriorityCount(this.address());
    }

    @NativeType(value="XrActiveActionSetPriorityEXT const *")
    public XrActiveActionSetPriorityEXT.Buffer actionSetPriorities() {
        return XrActiveActionSetPrioritiesEXT.nactionSetPriorities(this.address());
    }

    public XrActiveActionSetPrioritiesEXT type(@NativeType(value="XrStructureType") int value) {
        XrActiveActionSetPrioritiesEXT.ntype(this.address(), value);
        return this;
    }

    public XrActiveActionSetPrioritiesEXT type$Default() {
        return this.type(1000373000);
    }

    public XrActiveActionSetPrioritiesEXT next(@NativeType(value="void const *") long value) {
        XrActiveActionSetPrioritiesEXT.nnext(this.address(), value);
        return this;
    }

    public XrActiveActionSetPrioritiesEXT actionSetPriorities(@NativeType(value="XrActiveActionSetPriorityEXT const *") XrActiveActionSetPriorityEXT.Buffer value) {
        XrActiveActionSetPrioritiesEXT.nactionSetPriorities(this.address(), value);
        return this;
    }

    public XrActiveActionSetPrioritiesEXT set(int type, long next, XrActiveActionSetPriorityEXT.Buffer actionSetPriorities) {
        this.type(type);
        this.next(next);
        this.actionSetPriorities(actionSetPriorities);
        return this;
    }

    public XrActiveActionSetPrioritiesEXT set(XrActiveActionSetPrioritiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrActiveActionSetPrioritiesEXT malloc() {
        return new XrActiveActionSetPrioritiesEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrActiveActionSetPrioritiesEXT calloc() {
        return new XrActiveActionSetPrioritiesEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrActiveActionSetPrioritiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrActiveActionSetPrioritiesEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrActiveActionSetPrioritiesEXT create(long address) {
        return new XrActiveActionSetPrioritiesEXT(address, null);
    }

    public static @Nullable XrActiveActionSetPrioritiesEXT createSafe(long address) {
        return address == 0L ? null : new XrActiveActionSetPrioritiesEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrActiveActionSetPrioritiesEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActiveActionSetPrioritiesEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActiveActionSetPrioritiesEXT malloc(MemoryStack stack) {
        return new XrActiveActionSetPrioritiesEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActiveActionSetPrioritiesEXT calloc(MemoryStack stack) {
        return new XrActiveActionSetPrioritiesEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nactionSetPriorityCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACTIONSETPRIORITYCOUNT);
    }

    public static XrActiveActionSetPriorityEXT.Buffer nactionSetPriorities(long struct) {
        return XrActiveActionSetPriorityEXT.create(MemoryUtil.memGetAddress(struct + (long)ACTIONSETPRIORITIES), XrActiveActionSetPrioritiesEXT.nactionSetPriorityCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nactionSetPriorityCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ACTIONSETPRIORITYCOUNT, value);
    }

    public static void nactionSetPriorities(long struct, XrActiveActionSetPriorityEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)ACTIONSETPRIORITIES, value.address());
        XrActiveActionSetPrioritiesEXT.nactionSetPriorityCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        int actionSetPriorityCount = XrActiveActionSetPrioritiesEXT.nactionSetPriorityCount(struct);
        long actionSetPriorities = MemoryUtil.memGetAddress(struct + (long)ACTIONSETPRIORITIES);
        Checks.check(actionSetPriorities);
        XrActiveActionSetPrioritiesEXT.validate(actionSetPriorities, actionSetPriorityCount, XrActiveActionSetPriorityEXT.SIZEOF, XrActiveActionSetPriorityEXT::validate);
    }

    static {
        Struct.Layout layout = XrActiveActionSetPrioritiesEXT.__struct(XrActiveActionSetPrioritiesEXT.__member(4), XrActiveActionSetPrioritiesEXT.__member(POINTER_SIZE), XrActiveActionSetPrioritiesEXT.__member(4), XrActiveActionSetPrioritiesEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTIONSETPRIORITYCOUNT = layout.offsetof(2);
        ACTIONSETPRIORITIES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrActiveActionSetPrioritiesEXT, Buffer>
    implements NativeResource {
        private static final XrActiveActionSetPrioritiesEXT ELEMENT_FACTORY = XrActiveActionSetPrioritiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrActiveActionSetPrioritiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActiveActionSetPrioritiesEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrActiveActionSetPrioritiesEXT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int actionSetPriorityCount() {
            return XrActiveActionSetPrioritiesEXT.nactionSetPriorityCount(this.address());
        }

        @NativeType(value="XrActiveActionSetPriorityEXT const *")
        public XrActiveActionSetPriorityEXT.Buffer actionSetPriorities() {
            return XrActiveActionSetPrioritiesEXT.nactionSetPriorities(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActiveActionSetPrioritiesEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000373000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrActiveActionSetPrioritiesEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer actionSetPriorities(@NativeType(value="XrActiveActionSetPriorityEXT const *") XrActiveActionSetPriorityEXT.Buffer value) {
            XrActiveActionSetPrioritiesEXT.nactionSetPriorities(this.address(), value);
            return this;
        }
    }
}

