/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrApplicationInfo
extends Struct<XrApplicationInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int APPLICATIONNAME;
    public static final int APPLICATIONVERSION;
    public static final int ENGINENAME;
    public static final int ENGINEVERSION;
    public static final int APIVERSION;

    protected XrApplicationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrApplicationInfo create(long address, @Nullable ByteBuffer container) {
        return new XrApplicationInfo(address, container);
    }

    public XrApplicationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrApplicationInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]")
    public ByteBuffer applicationName() {
        return XrApplicationInfo.napplicationName(this.address());
    }

    @NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]")
    public String applicationNameString() {
        return XrApplicationInfo.napplicationNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int applicationVersion() {
        return XrApplicationInfo.napplicationVersion(this.address());
    }

    @NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]")
    public ByteBuffer engineName() {
        return XrApplicationInfo.nengineName(this.address());
    }

    @NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]")
    public String engineNameString() {
        return XrApplicationInfo.nengineNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int engineVersion() {
        return XrApplicationInfo.nengineVersion(this.address());
    }

    @NativeType(value="XrVersion")
    public long apiVersion() {
        return XrApplicationInfo.napiVersion(this.address());
    }

    public XrApplicationInfo applicationName(@NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]") ByteBuffer value) {
        XrApplicationInfo.napplicationName(this.address(), value);
        return this;
    }

    public XrApplicationInfo applicationVersion(@NativeType(value="uint32_t") int value) {
        XrApplicationInfo.napplicationVersion(this.address(), value);
        return this;
    }

    public XrApplicationInfo engineName(@NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]") ByteBuffer value) {
        XrApplicationInfo.nengineName(this.address(), value);
        return this;
    }

    public XrApplicationInfo engineVersion(@NativeType(value="uint32_t") int value) {
        XrApplicationInfo.nengineVersion(this.address(), value);
        return this;
    }

    public XrApplicationInfo apiVersion(@NativeType(value="XrVersion") long value) {
        XrApplicationInfo.napiVersion(this.address(), value);
        return this;
    }

    public XrApplicationInfo set(ByteBuffer applicationName, int applicationVersion, ByteBuffer engineName, int engineVersion, long apiVersion) {
        this.applicationName(applicationName);
        this.applicationVersion(applicationVersion);
        this.engineName(engineName);
        this.engineVersion(engineVersion);
        this.apiVersion(apiVersion);
        return this;
    }

    public XrApplicationInfo set(XrApplicationInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrApplicationInfo malloc() {
        return new XrApplicationInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrApplicationInfo calloc() {
        return new XrApplicationInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrApplicationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrApplicationInfo(MemoryUtil.memAddress(container), container);
    }

    public static XrApplicationInfo create(long address) {
        return new XrApplicationInfo(address, null);
    }

    public static @Nullable XrApplicationInfo createSafe(long address) {
        return address == 0L ? null : new XrApplicationInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrApplicationInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrApplicationInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrApplicationInfo malloc(MemoryStack stack) {
        return new XrApplicationInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrApplicationInfo calloc(MemoryStack stack) {
        return new XrApplicationInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer napplicationName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)APPLICATIONNAME, 128);
    }

    public static String napplicationNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)APPLICATIONNAME);
    }

    public static int napplicationVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)APPLICATIONVERSION);
    }

    public static ByteBuffer nengineName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)ENGINENAME, 128);
    }

    public static String nengineNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)ENGINENAME);
    }

    public static int nengineVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENGINEVERSION);
    }

    public static long napiVersion(long struct) {
        return MemoryUtil.memGetLong(struct + (long)APIVERSION);
    }

    public static void napplicationName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 128);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)APPLICATIONNAME, value.remaining());
    }

    public static void napplicationVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)APPLICATIONVERSION, value);
    }

    public static void nengineName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 128);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ENGINENAME, value.remaining());
    }

    public static void nengineVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ENGINEVERSION, value);
    }

    public static void napiVersion(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)APIVERSION, value);
    }

    static {
        Struct.Layout layout = XrApplicationInfo.__struct(XrApplicationInfo.__array(1, 128), XrApplicationInfo.__member(4), XrApplicationInfo.__array(1, 128), XrApplicationInfo.__member(4), XrApplicationInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        APPLICATIONNAME = layout.offsetof(0);
        APPLICATIONVERSION = layout.offsetof(1);
        ENGINENAME = layout.offsetof(2);
        ENGINEVERSION = layout.offsetof(3);
        APIVERSION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrApplicationInfo, Buffer>
    implements NativeResource {
        private static final XrApplicationInfo ELEMENT_FACTORY = XrApplicationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrApplicationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]")
        public ByteBuffer applicationName() {
            return XrApplicationInfo.napplicationName(this.address());
        }

        @NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]")
        public String applicationNameString() {
            return XrApplicationInfo.napplicationNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int applicationVersion() {
            return XrApplicationInfo.napplicationVersion(this.address());
        }

        @NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]")
        public ByteBuffer engineName() {
            return XrApplicationInfo.nengineName(this.address());
        }

        @NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]")
        public String engineNameString() {
            return XrApplicationInfo.nengineNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int engineVersion() {
            return XrApplicationInfo.nengineVersion(this.address());
        }

        @NativeType(value="XrVersion")
        public long apiVersion() {
            return XrApplicationInfo.napiVersion(this.address());
        }

        public Buffer applicationName(@NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]") ByteBuffer value) {
            XrApplicationInfo.napplicationName(this.address(), value);
            return this;
        }

        public Buffer applicationVersion(@NativeType(value="uint32_t") int value) {
            XrApplicationInfo.napplicationVersion(this.address(), value);
            return this;
        }

        public Buffer engineName(@NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]") ByteBuffer value) {
            XrApplicationInfo.nengineName(this.address(), value);
            return this;
        }

        public Buffer engineVersion(@NativeType(value="uint32_t") int value) {
            XrApplicationInfo.nengineVersion(this.address(), value);
            return this;
        }

        public Buffer apiVersion(@NativeType(value="XrVersion") long value) {
            XrApplicationInfo.napiVersion(this.address(), value);
            return this;
        }
    }
}

