/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrBodyJointLocationHTC;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodyJointLocationsHTC
extends Struct<XrBodyJointLocationsHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int COMBINEDLOCATIONFLAGS;
    public static final int CONFIDENCELEVEL;
    public static final int JOINTLOCATIONCOUNT;
    public static final int JOINTLOCATIONS;
    public static final int SKELETONGENERATIONID;

    protected XrBodyJointLocationsHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBodyJointLocationsHTC create(long address, @Nullable ByteBuffer container) {
        return new XrBodyJointLocationsHTC(address, container);
    }

    public XrBodyJointLocationsHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBodyJointLocationsHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodyJointLocationsHTC.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrBodyJointLocationsHTC.nnext(this.address());
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long combinedLocationFlags() {
        return XrBodyJointLocationsHTC.ncombinedLocationFlags(this.address());
    }

    @NativeType(value="XrBodyJointConfidenceHTC")
    public int confidenceLevel() {
        return XrBodyJointLocationsHTC.nconfidenceLevel(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointLocationCount() {
        return XrBodyJointLocationsHTC.njointLocationCount(this.address());
    }

    @NativeType(value="XrBodyJointLocationHTC *")
    public XrBodyJointLocationHTC.Buffer jointLocations() {
        return XrBodyJointLocationsHTC.njointLocations(this.address());
    }

    @NativeType(value="uint32_t")
    public int skeletonGenerationId() {
        return XrBodyJointLocationsHTC.nskeletonGenerationId(this.address());
    }

    public XrBodyJointLocationsHTC type(@NativeType(value="XrStructureType") int value) {
        XrBodyJointLocationsHTC.ntype(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsHTC type$Default() {
        return this.type(1000320003);
    }

    public XrBodyJointLocationsHTC next(@NativeType(value="void *") long value) {
        XrBodyJointLocationsHTC.nnext(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsHTC combinedLocationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
        XrBodyJointLocationsHTC.ncombinedLocationFlags(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsHTC confidenceLevel(@NativeType(value="XrBodyJointConfidenceHTC") int value) {
        XrBodyJointLocationsHTC.nconfidenceLevel(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsHTC jointLocations(@NativeType(value="XrBodyJointLocationHTC *") XrBodyJointLocationHTC.Buffer value) {
        XrBodyJointLocationsHTC.njointLocations(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsHTC skeletonGenerationId(@NativeType(value="uint32_t") int value) {
        XrBodyJointLocationsHTC.nskeletonGenerationId(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsHTC set(int type, long next, long combinedLocationFlags, int confidenceLevel, XrBodyJointLocationHTC.Buffer jointLocations, int skeletonGenerationId) {
        this.type(type);
        this.next(next);
        this.combinedLocationFlags(combinedLocationFlags);
        this.confidenceLevel(confidenceLevel);
        this.jointLocations(jointLocations);
        this.skeletonGenerationId(skeletonGenerationId);
        return this;
    }

    public XrBodyJointLocationsHTC set(XrBodyJointLocationsHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBodyJointLocationsHTC malloc() {
        return new XrBodyJointLocationsHTC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBodyJointLocationsHTC calloc() {
        return new XrBodyJointLocationsHTC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBodyJointLocationsHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBodyJointLocationsHTC(MemoryUtil.memAddress(container), container);
    }

    public static XrBodyJointLocationsHTC create(long address) {
        return new XrBodyJointLocationsHTC(address, null);
    }

    public static @Nullable XrBodyJointLocationsHTC createSafe(long address) {
        return address == 0L ? null : new XrBodyJointLocationsHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBodyJointLocationsHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodyJointLocationsHTC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodyJointLocationsHTC malloc(MemoryStack stack) {
        return new XrBodyJointLocationsHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodyJointLocationsHTC calloc(MemoryStack stack) {
        return new XrBodyJointLocationsHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ncombinedLocationFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)COMBINEDLOCATIONFLAGS);
    }

    public static int nconfidenceLevel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONFIDENCELEVEL);
    }

    public static int njointLocationCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)JOINTLOCATIONCOUNT);
    }

    public static XrBodyJointLocationHTC.Buffer njointLocations(long struct) {
        return XrBodyJointLocationHTC.create(MemoryUtil.memGetAddress(struct + (long)JOINTLOCATIONS), XrBodyJointLocationsHTC.njointLocationCount(struct));
    }

    public static int nskeletonGenerationId(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SKELETONGENERATIONID);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncombinedLocationFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)COMBINEDLOCATIONFLAGS, value);
    }

    public static void nconfidenceLevel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONFIDENCELEVEL, value);
    }

    public static void njointLocationCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)JOINTLOCATIONCOUNT, value);
    }

    public static void njointLocations(long struct, XrBodyJointLocationHTC.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTLOCATIONS, value.address());
        XrBodyJointLocationsHTC.njointLocationCount(struct, value.remaining());
    }

    public static void nskeletonGenerationId(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SKELETONGENERATIONID, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JOINTLOCATIONS));
    }

    static {
        Struct.Layout layout = XrBodyJointLocationsHTC.__struct(XrBodyJointLocationsHTC.__member(4), XrBodyJointLocationsHTC.__member(POINTER_SIZE), XrBodyJointLocationsHTC.__member(8), XrBodyJointLocationsHTC.__member(4), XrBodyJointLocationsHTC.__member(4), XrBodyJointLocationsHTC.__member(POINTER_SIZE), XrBodyJointLocationsHTC.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        COMBINEDLOCATIONFLAGS = layout.offsetof(2);
        CONFIDENCELEVEL = layout.offsetof(3);
        JOINTLOCATIONCOUNT = layout.offsetof(4);
        JOINTLOCATIONS = layout.offsetof(5);
        SKELETONGENERATIONID = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrBodyJointLocationsHTC, Buffer>
    implements NativeResource {
        private static final XrBodyJointLocationsHTC ELEMENT_FACTORY = XrBodyJointLocationsHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBodyJointLocationsHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodyJointLocationsHTC.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrBodyJointLocationsHTC.nnext(this.address());
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long combinedLocationFlags() {
            return XrBodyJointLocationsHTC.ncombinedLocationFlags(this.address());
        }

        @NativeType(value="XrBodyJointConfidenceHTC")
        public int confidenceLevel() {
            return XrBodyJointLocationsHTC.nconfidenceLevel(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointLocationCount() {
            return XrBodyJointLocationsHTC.njointLocationCount(this.address());
        }

        @NativeType(value="XrBodyJointLocationHTC *")
        public XrBodyJointLocationHTC.Buffer jointLocations() {
            return XrBodyJointLocationsHTC.njointLocations(this.address());
        }

        @NativeType(value="uint32_t")
        public int skeletonGenerationId() {
            return XrBodyJointLocationsHTC.nskeletonGenerationId(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodyJointLocationsHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000320003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrBodyJointLocationsHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer combinedLocationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
            XrBodyJointLocationsHTC.ncombinedLocationFlags(this.address(), value);
            return this;
        }

        public Buffer confidenceLevel(@NativeType(value="XrBodyJointConfidenceHTC") int value) {
            XrBodyJointLocationsHTC.nconfidenceLevel(this.address(), value);
            return this;
        }

        public Buffer jointLocations(@NativeType(value="XrBodyJointLocationHTC *") XrBodyJointLocationHTC.Buffer value) {
            XrBodyJointLocationsHTC.njointLocations(this.address(), value);
            return this;
        }

        public Buffer skeletonGenerationId(@NativeType(value="uint32_t") int value) {
            XrBodyJointLocationsHTC.nskeletonGenerationId(this.address(), value);
            return this;
        }
    }
}

